<?php

namespace Mpdf\Config;

class FontVariables
{

	private $defaults;

	public function __construct()
	{
		$this->defaults = [

			'fontDescriptor' => 'win',

			'backupSubsFont' => ['dejavusanscondensed'],

			'backupSIPFont' => 'sun-extb',
			'fonttrans' => [
				'times' => 'timesnewroman',
				'courier' => 'couriernew',
				'trebuchet' => 'trebuchetms',
				'comic' => 'comicsansms',
				'franklin' => 'franklingothicbook',
				'ocr-b' => 'ocrb',
				'ocr-b10bt' => 'ocrb',
				'damase' => 'mph2bdamase',
			],

			'fontdata' => [
				"dejavusanscondensed" => [
					'R' => "DejaVuSansCondensed.ttf",
					'B' => "DejaVuSansCondensed-Bold.ttf",
					'I' => "DejaVuSansCondensed-Oblique.ttf",
					'BI' => "DejaVuSansCondensed-BoldOblique.ttf",
					'useOTL' => 0xFF,
					'useKashida' => 75,
				],
                                "pridi" => [
                                    'R' => "Pridi-Regular.ttf",
                                    'B' => "Pridi-Bold.ttf",
                                    'L' => "Pridi-Light.ttf",
                                    'EL' => "Pridi-ExtraLight.ttf",   
                                    'M' => "Pridi-Medium.ttf",
                                    'SB' => "Pridi-SemiBold.ttf",
                                    'useOTL' => 0x00,
                                    'useKashida' => 75,
                                ],
                            "notoSans" => [
                                'NSB' => 'NotoSans-Bold.ttf',
                                'NSI' => 'NotoSans-Italic.ttf',
                                'NSL' => 'NotoSans-Light.ttf',
                                'NSM' => 'NotoSans-Medium.ttf',
                                'NSMI' => 'NotoSans-MediumItalic.ttf',
                                'NSR' => 'NotoSans-Regular.ttf',
                                'NSTR' => 'NotoSansThaiUI-Regular.ttf',
                                'useOTL' => 0x00,
                                'useKashida' => 75,
                            ]
			],

			'BMPonly' => ["notoSans"],

			'sans_fonts' => ['notoSans'],

			'serif_fonts' => ['notoSans'],

			'mono_fonts' => ['notoSans'],
		];
	}

	public function getDefaults()
	{       
		return $this->defaults;
	}

}
