<?php
class NBSmartInvoiceFrontend{
    private $_NBCreatePDF;
    public function __construct()
    {
        $this->_NBCreatePDF = new NBCreatePDF();
        add_action('woocommerce_thankyou', array($this, 'enroll_student'), 30, 1);
        add_action( 'wp_enqueue_scripts', array($this, 'nb_invoice_enqueue_styles' ));
        add_action( 'nb_smartinvoice_download', array($this, 'check_url') );
        add_filter( 'woocommerce_my_account_my_orders_actions', array($this, 'netbase_invoice_add_download_button_fronend'), 100, 2 );
    }

    function check_url() {
        if( $this->check_confirm_url() ) {

            if(isset($_GET['order_id']) && isset($_GET['type']) ){

                if((int) $_GET['order_id'] > 0  && $_GET['type'] != '' && ! empty($_GET['key']) ) {
                    $order = new WC_Order ( absint($_GET['order_id']) );

                    if( $order ) {
                        $orderKey = get_post_meta( $order->get_id(), '_order_key', true );

                        if( $orderKey == $_GET['key'] ) {
                            if($this->_NBCreatePDF->invoice_checkOrderStatus($order) === false) {
                                wp_die( esc_html__( 'This Order do not have Invoice & Delivery','netbase-smart-invoice' ) );
                            }

                            $this->_NBCreatePDF->invoice_createPDF($order->get_id(), $_GET['type'], "D", '', true);
                        }
                    }
                }
            }
        }
    }
    
    function check_confirm_url() {
        return false !== strpos( $_SERVER[ 'REQUEST_URI' ], '/nb_invoice/confirm' );
    }

    function nb_invoice_enqueue_styles() 
    {
        wp_enqueue_style('nb-invoice-admin-frontent-css', NETBASE_SMART_INVOICE_PLUGIN_URL . 'assets/css/nb_invoice_frontend.css');
    }
    function enroll_student( $order_id ) {
        if ( ! $order_id )
            return;

        if( ! get_post_meta( $order_id, '_thankyou_action_done', true ) ) {

            $order = wc_get_order( $order_id );

            if($order->is_paid())
                $paid = esc_html__('yes','netbase-smart-invoice');
            else
                $paid = esc_html__('no','netbase-smart-invoice');

            foreach ( $order->get_items() as $item_id => $item ) {

                $product = $item->get_product();

                $product_id = $product->get_id();

                $product_id = $item->get_name();
            }

            echo "<section class='netbase-invoice'>";
            echo "<h2 class='netbase-invoice-title-download-pdf'>Download Invoice</h2>";
            echo "<div class='container'><div class='row'>";
            echo "<a href='" . get_home_url() . '/nb_invoice/confirm?order_id=' . $order_id . '&type=invoice&key=' . $_GET['key'] . "' class='button'>Download Invoice</a>";
            echo "<div class='col-md-6'></div>";
            echo "</div></div>";
            echo "</section>";
            $order->update_meta_data( '_thankyou_action_done', true );
            $order->save();
        }
    }
    function netbase_invoice_add_download_button_fronend($actions, $order) {
        $download_url = wp_nonce_url( admin_url( 'admin-ajax.php?action=downloadInvoicePDF&btask=download_invoice_PDF&type=invoice&order_ids=' . $order->get_id()), 'netbase_generate_invoice' );
        
        if($this->_NBCreatePDF->invoice_customer_can_download($order) == false)
            return $actions;
        
        $actions['netbase_download_invoice'] = array(
            'url'  => $download_url,
            'name' => apply_filters( 'invoice_download_button', esc_html__( 'Invoice (PDF)','netbase-smart-invoice') )
        );		
        
        return apply_filters( 'invoice_add_more_buttons_frontend', $actions, $order );
    }
}