<?php
    function nb_invoice_ceateDB(){
        global $wpdb;
        $bd_name = $wpdb->prefix . "netbase_invoice_templates";
        $tables = "CREATE TABLE IF NOT EXISTS $bd_name (
                id int(11) NOT NULL AUTO_INCREMENT,
                template_landscape tinyint(1) DEFAULT '0',
                name_template varchar(255) COLLATE utf8_unicode_ci NOT NULL,
                template_invoice_header text COLLATE utf8_unicode_ci,
                template_invoice_content text COLLATE utf8_unicode_ci,
                template_invoice_footer text COLLATE utf8_unicode_ci,
                template_custom_css text COLLATE utf8_unicode_ci,
                columns_number int(5) DEFAULT '0',
                item_title_json varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
                item_key_value_json varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
                item_title_color_json varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
                item_title_background_Json varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL,
                public int(1) DEFAULT '0',
                type varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'invoice',
                PRIMARY KEY (`id`)
               );";
        $wpdb->query($tables); 

        $db_invoice_order = $wpdb->prefix . 'netbase_invoice_order';
        $tables_invoice_order = "
            CREATE TABLE IF NOT EXISTS $db_invoice_order (
            id_invoice int(11) NOT NULL AUTO_INCREMENT,
            id_order int(11) NOT NULL,
            invoice_number int(11) NOT NULL DEFAULT '0',
            delivery_number int(11) NOT NULL DEFAULT '0',
            delivery_date datetime DEFAULT NULL,
            invoice_date datetime DEFAULT NULL,
            date_add datetime NOT NULL,
            date_update datetime NOT NULL,
            PRIMARY KEY  (`id_invoice`)
            );";
        $wpdb->query($tables_invoice_order);
    }
    function nd_create_settingDefault(){
        $netbase_invoice_setting_default = [
            'pdf_template_debug' => 1,
            'nb_order_status_wc-pending' => 1,
            'nb_order_status_wc-processing' => 1,
            'nb_order_status_wc-on-hold' => 1,
            'nb_order_status_wc-completed' => 1,
            'nb_order_status_wc-cancelled' => 1,
            'nb_order_status_wc-refunded' => 1,
            'nb_order_status_wc-failed' => 1,
            'new_order_email' => 0,
            'customer_invoice' => 0,
            'processing_order_email' => 0,
            'completed_order_email' => 1,
            'cancelled_order_email' => 0,
            'failed_order_email' => 0,
            'order_onhold_email' => 0,
            'refunded_order_email' => 0,
            'customer_can_download_pdf' => "option",
            'digits' => 6,
            'invoice_number_start' => 1,
            'invoice_number_format' => "#IN[number]",
            'delivery_number_start' => 1,
            'delivery_number_format' => "#DE[number]",
            'date_format' => "Y-m-d"
        ];
        add_option('nd_invoice_template_settings', $netbase_invoice_setting_default, $deprecated='', $autoload = 'yes');
    }
    function nb_invoice_ceateDB_demo(){
        global $wpdb;
        $list_items = [
            [
                'name_template' => 'Invoice Template 01',
                'template_landscape' => 0,
                'template_invoice_header' => '',
                'template_invoice_content' => '<table id="table1">
                            <tbody>
                            <tr>
                            <td id="td1" style="padding-left: 0px;">NETBASE JSC ...</td>
                            <td id="td2" rowspan="3"><img id="image_logo" class="alignnone wp-image-54" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/Asset-1.png" alt="" width="200" height="69" />
                            <p style="font-size: 24px; position: absolute; top: 80px; right: 130px; color: #ffffff;">INVOICE</p>
                            <p style="font-size: 13px; position: absolute; top: 130px; right: 100px; color: gray;">INVOICE NO. #437861</p>
                            </td>
                            </tr>
                            <tr>
                            <td style="color: gray; font-size: 13px;">ROOM A702, M3 M4 BULDING</td>
                            </tr>
                            <tr>
                            <td style="color: gray; font-size: 13px;">91 NGUYEN TRI THANH STR</td>
                            </tr>
                            <tr>
                            <td style="color: gray; font-size: 13px;">DONG DA DIST, HA NOI, VIET NAM</td>
                            </tr>
                            </tbody>
                            </table>
                            <div style="width: 90%; height: 1px; background: black; margin-left: 0px; margin-top: 40px;"></div>
                            <table id="table2">
                            <tbody>
                            <tr>
                            <td style="color: gray;">Supplier:</td>
                            <td style="color: gray;">Client:</td>
                            </tr>
                            <tr>
                            <td id="td1">NETBASE JSC...</td>
                            <td id="td1">ALEX WILLIAM</td>
                            </tr>
                            <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: gray;">Room A702,M3M4 Bulding</td>
                            <td style="font-size: 13px; color: gray;">Room A702,M3M4 Bulding</td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: gray;">91 Nguyen Tri Thanh Str</td>
                            <td style="font-size: 13px; color: gray;">91 Nguyen Tri Thanh Str</td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: gray;">Dong Da Dist,Ha Noi,Viet Nam</td>
                            <td style="font-size: 13px; color: gray;">Dong Da Dist,Ha Noi,Viet Nam</td>
                            </tr>
                            </tbody>
                            </table>
                            <div style="width: 500px; height: 1px; background: black; margin-left: 0px; margin-top: 20px;"></div>
                            <table id="table3" cellpadding="-5">
                            <tbody>
                            <tr>
                            <td id="td1" style="font-size: 13px; color: #616060;"><b>Payment Method: </b>Credit Card</td>
                            <td id="td2" style="font-size: 13px; color: #616060;"><b>Date: </b>June 1,2019</td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: #616060;"><b>Oder Number: </b>#012921</td>
                            <td></td>
                            </tr>
                            </tbody>
                            </table>
                            [products_list]
                            <table id="table5">
                            <tbody>
                            <tr>
                            <td id="td01">Thanks you for business</td>
                            <td id="td02" style="font-size: 18px; padding-left: 10px; color: gray;">Subtotal:</td>
                            <td class="td00" style="padding-right: 10px; color: gray; padding-top: 20px; font-size: 18px;">$20.00</td>
                            </tr>
                            <tr>
                            <td id="td03" style="padding-top: -40px;">payment is due max 7 days after invoice without deduction</td>
                            <td id="td04" style="font-size: 18px; padding-left: 10px; color: gray;">Taxes</td>
                            <td class="td00" style="padding-right: 10px; padding-top: 10px; font-size: 18px; color: gray;">$0.00</td>
                            </tr>
                            <tr>
                            <td id="td05" rowspan="4"><img class="wp-image-56 size-full aligncenter" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/Asset-2.png" alt="" width="146" height="128" /></td>
                            <td id="td06" style="padding-left: 10px; font-size: 18px; color: gray;">Discount:</td>
                            <td class="td00" style="padding-right: 10px; padding-top: 10px; font-size: 18px; color: gray;">$0.00</td>
                            </tr>
                            <tr>
                            <td id="td07" style="padding-left: 10px; height: 50px; border-top: 1px solid red; border-right: none; border-left: 1px solid red; border-bottom: 1px solid red; font-size: 18px; color: gray;">Total:</td>
                            <td class="td00" style="border-top: 1px solid red; border-left: none; border-right: 1px solid red; border-bottom: 1px solid red; height: 50px; color: gray; font-size: 18px; padding-right: 10px;">$20.00</td>
                            </tr>
                            <tr>
                            <td id="td08" style="padding-top: 10px;" colspan="2"><img class="wp-image-57 alignright" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/Asset-4.png" alt="" width="221" height="72" /></td>
                            </tr>
                            <tr>
                            <td></td>
                            <td style="padding-right: 10px; padding-top: 20px; text-align: right;">Signature</td>
                            </tr>
                            </tbody>
                            </table>',
                'template_invoice_footer' => '<div style="width: 100%; height: 1px; background: black; margin-top: 20px;"></div>
                            <table id="table6" style="height: 40px;" width="100%">
                            <tbody>
                            <tr>
                            <td style="text-align: center;"><img class="alignnone size-full wp-image-60" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/icon-3.png" alt="" width="13" height="13" /><span style="padding-right:10px;font-family: inherit; font-size: inherit;color: gray;"> +84 912 345678</span></td>
                            <td style="text-align: center;"><img class="alignnone size-full wp-image-58" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/icon-1.png" alt="" width="13" height="15" /><span style="padding-right:10px;font-family: inherit; font-size: inherit;color: gray;"> netbase@gmail.com</span></td>
                            <td style="text-align: center;"><img class="alignnone size-full wp-image-59" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/icon-2.png" alt="" width="13" height="13" /><span style="padding-right:10px;font-family: inherit; font-size: inherit;color: gray;"> netbasajsc.net</span></td>
                            </tr>
                            </tbody>
                            </table>
                            <div style="width: 100%; height: 5px; background: #1eb6ca; margin-left: 0px; margin-top: 20px;"></div>',
                'template_custom_css' => '#table1{
                                        margin-left:0px
                                        width: 100%;
                                    }
                                    #table1 #td1{
                                        font-size: 30px; text-align: left; font-weight: bold;width: 382px
                                    }
                                    #table1 #td2{
                                        width: 382px;
                                        text-align: right;
                                        display: block;
                                        position: relative;
                                    }
                                    #image_logo{
                                        display: block;
                                        position: absolute;
                                        top: 0px;
                                        right: 0px;
                                    }
                                    #table2{
                                        margin-left:0px;margin-top: 40px;
                                    }
                                    #table2 #td1{
                                        font-size: 30px; color:#1eb6ca ;width: 382px;
                                    }
                                    #table2 #td2{
                                        width: 382px;
                                    } 
                                    #table3{
                                        margin-left:0px;margin-top: 10px;
                                    }
                                    #table3 #td1{
                                        width:382px;
                                        height: 50px;
                                    }
                                    #table3 #td2{
                                        width:382px;
                                        height: 50px;
                                    }
                                    #table4{
                                        margin-left:0px;
                                            margin-top: 20px;
                                            width: 100%;
                                    }
                                    #table4 #tr1{
                                        background-color:#1eb6ca; color:white;
                                    }
                                    #table4 #tr1 #th1{
                                        width: 350px;
                                    }
                                    #table4 #tr1 th{
                                        width:120px;
                                    }
                                    #table4 #td1 img{
                                        float: left;position:relative;
                                    }
                                    #table4 #td1 #p1{
                                        float: left;position:absolute; margin-top: 2px; margin-left: 40px;
                                    
                                    }
                                    #table4 #td1 #p2{
                                        float: left;position:relative;margin:0px;padding: 0px;margin-top: 18px; margin-left:5px
                                    
                                    }
                                    #table4 td{
                                        text-align: center;
                                    }
                                    
                                    #table6{
                                        margin-left:0px;margin-top: 20px;
                                    }
                                    #table6 td{
                                        width:0px;
                                    }
                                    #product_list_tempalte_invoice td{
                                            padding:5px;
                                    }
                                    #product_list_tempalte_invoice th{
                                            padding:5px;
                                    }
                                    .product_list_content_5{
                                    color:gray;
                                    border-left: 1px solid #808080;
                                        border-top: 1px solid #808080;
                                    border-right: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_content_4{
                                    color:gray;
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_content_2{
                                    color:gray;
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: left;
                                    border-left: none !important;
                                    }
                                    .product_list_content_3{
                                    color:gray;
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_content_1{
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    border-left: 1px solid #808080;
                                    text-align: right;
                                    border-right: none !important;
                                    }
                                    .product_list_title_1{
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: right;
                                    border-right: none !important;
                                    }
                                    .product_list_title_2{
                                    border-top: 1px solid #808080;
                                    text-align: left;
                                    border-left: none !important;
                                    }
                                    .product_list_title_3{
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_title_4{
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_title_5{
                                    border-left: 1px solid #808080;
                                    border-right: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: center;
                                    }
                                    
                                    #table5 #td01{
                                    width: 382px;
                                    }
                                    #table5{
                                    border-collapse: collapse;
                                    }
                                    #table5 #td04{
                                    position: relative;
                                    }
                                    #td01, #td03{
                                    font-size: 12px; 
                                    color:gray;
                                    }
                                    #td04,#td02,#td06,#td07,#td08{
                                    padding-left:50px;
                                    }
                                    #td02{
                                    padding-top:20px;
                                    }
                                    #td04,#td07{
                                    padding-top:10px;
                                    }
                                    #td06{
                                    padding-top:10px;
                                    }
                                    
                                    #table5 #td02{
                                        width:200px
                                    }
                                    #table5 .td00{
                                        width:182px
                                    padding-left:20px;
                                    }',
                'columns_number' => '5',
                'item_title' => ['Item','Description','Price','Qty','Total'],
                'item_key_value' => ['p_image','p_name','unit_price_ex_tax','qty','total_in_tax'],
                'item_title_color' => ['FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF'],
                'item_title_background' => ['1EB6CA','1EB6CA','1EB6CA','1EB6CA','1EB6CA'],
                'public' => 1,
                'type_template' => 'invoice'
            ],[
                'name_template' => 'Delivery Template 01',
                'template_landscape' => 0,
                'template_invoice_header' => '',
                'template_invoice_content' => '<table id="table1">
                            <tbody>
                            <tr>
                            <td id="td1" style="padding-left: 0px;">NETBASE JSC ...</td>
                            <td id="td2" rowspan="3"><img id="image_logo" class="alignnone wp-image-54" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/Asset-1.png" alt="" width="200" height="69" />
                            <p style="font-size: 24px; position: absolute; top: 80px; right: 130px; color: #ffffff;">DELIVERY</p>
                            <p style="font-size: 13px; position: absolute; top: 130px; right: 100px; color: gray;">DELIVERY NO. #437861</p>
                            </td>
                            </tr>
                            <tr>
                            <td style="color: gray; font-size: 13px;">ROOM A702, M3 M4 BULDING</td>
                            </tr>
                            <tr>
                            <td style="color: gray; font-size: 13px;">91 NGUYEN TRI THANH STR</td>
                            </tr>
                            <tr>
                            <td style="color: gray; font-size: 13px;">DONG DA DIST, HA NOI, VIET NAM</td>
                            </tr>
                            </tbody>
                            </table>
                            <div style="width: 90%; height: 1px; background: black; margin-left: 0px; margin-top: 40px;"></div>
                            <table id="table2">
                            <tbody>
                            <tr>
                            <td style="color: gray;">Supplier:</td>
                            <td style="color: gray;">Client:</td>
                            </tr>
                            <tr>
                            <td id="td1">NETBASE JSC...</td>
                            <td id="td1">ALEX WILLIAM</td>
                            </tr>
                            <tr>
                            <td></td>
                            <td></td>
                            <td></td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: gray;">Room A702,M3M4 Bulding</td>
                            <td style="font-size: 13px; color: gray;">Room A702,M3M4 Bulding</td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: gray;">91 Nguyen Tri Thanh Str</td>
                            <td style="font-size: 13px; color: gray;">91 Nguyen Tri Thanh Str</td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: gray;">Dong Da Dist,Ha Noi,Viet Nam</td>
                            <td style="font-size: 13px; color: gray;">Dong Da Dist,Ha Noi,Viet Nam</td>
                            </tr>
                            </tbody>
                            </table>
                            <div style="width: 500px; height: 1px; background: black; margin-left: 0px; margin-top: 20px;"></div>
                            <table id="table3" cellpadding="-5">
                            <tbody>
                            <tr>
                            <td id="td1" style="font-size: 13px; color: #616060;"><b>Payment Method: </b>Credit Card</td>
                            <td id="td2" style="font-size: 13px; color: #616060;"><b>Date: </b>June 1,2019</td>
                            </tr>
                            <tr>
                            <td style="font-size: 13px; color: #616060;"><b>Oder Number: </b>#012921</td>
                            <td></td>
                            </tr>
                            </tbody>
                            </table>
                            [products_list]
                            <table id="table5">
                            <tbody>
                            <tr>
                            <td id="td01">Thanks you for business</td>
                            <td id="td02" style="font-size: 18px; padding-left: 10px; color: gray;">Subtotal:</td>
                            <td class="td00" style="padding-right: 10px; color: gray; padding-top: 20px; font-size: 18px;">$20.00</td>
                            </tr>
                            <tr>
                            <td id="td03" style="padding-top: -40px;">payment is due max 7 days after delivery without deduction</td>
                            <td id="td04" style="font-size: 18px; padding-left: 10px; color: gray;">Taxes</td>
                            <td class="td00" style="padding-right: 10px; padding-top: 10px; font-size: 18px; color: gray;">$0.00</td>
                            </tr>
                            <tr>
                            <td id="td05" rowspan="4"><img class="wp-image-56 size-full aligncenter" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/Asset-2.png" alt="" width="146" height="128" /></td>
                            <td id="td06" style="padding-left: 10px; font-size: 18px; color: gray;">Discount:</td>
                            <td class="td00" style="padding-right: 10px; padding-top: 10px; font-size: 18px; color: gray;">$0.00</td>
                            </tr>
                            <tr>
                            <td id="td07" style="padding-left: 10px; height: 50px; border-top: 1px solid red; border-right: none; border-left: 1px solid red; border-bottom: 1px solid red; font-size: 18px; color: gray;">Total:</td>
                            <td class="td00" style="border-top: 1px solid red; border-left: none; border-right: 1px solid red; border-bottom: 1px solid red; height: 50px; color: gray; font-size: 18px; padding-right: 10px;">$20.00</td>
                            </tr>
                            <tr>
                            <td id="td08" style="padding-top: 10px;" colspan="2"><img class="wp-image-57 alignright" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/Asset-4.png" alt="" width="221" height="72" /></td>
                            </tr>
                            <tr>
                            <td></td>
                            <td style="padding-right: 10px; padding-top: 20px; text-align: right;">Signature</td>
                            </tr>
                            </tbody>
                            </table>',
                'template_invoice_footer' => '<div style="width: 100%; height: 1px; background: black; margin-top: 20px;"></div>
                            <table id="table6" style="height: 40px;" width="100%">
                            <tbody>
                            <tr>
                            <td style="text-align: center;"><img class="alignnone size-full wp-image-60" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/icon-3.png" alt="" width="13" height="13" /><span style="padding-right:10px;font-family: inherit; font-size: inherit;color: gray;"> +84 912 345678</span></td>
                            <td style="text-align: center;"><img class="alignnone size-full wp-image-58" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/icon-1.png" alt="" width="13" height="15" /><span style="padding-right:10px;font-family: inherit; font-size: inherit;color: gray;"> netbase@gmail.com</span></td>
                            <td style="text-align: center;"><img class="alignnone size-full wp-image-59" src="http://demo7.cmsmart.net/netbase_developer/server_import/wp-content/uploads/2020/03/icon-2.png" alt="" width="13" height="13" /><span style="padding-right:10px;font-family: inherit; font-size: inherit;color: gray;"> netbasajsc.net</span></td>
                            </tr>
                            </tbody>
                            </table>
                            <div style="width: 100%; height: 5px; background: #1eb6ca; margin-left: 0px; margin-top: 20px;"></div>',
                'template_custom_css' => '#table1{
                                        margin-left:0px
                                        width: 100%;
                                    }
                                    #table1 #td1{
                                        font-size: 30px; text-align: left; font-weight: bold;width: 382px
                                    }
                                    #table1 #td2{
                                        width: 382px;
                                        text-align: right;
                                        display: block;
                                        position: relative;
                                    }
                                    #image_logo{
                                        display: block;
                                        position: absolute;
                                        top: 0px;
                                        right: 0px;
                                    }
                                    #table2{
                                        margin-left:0px;margin-top: 40px;
                                    }
                                    #table2 #td1{
                                        font-size: 30px; color:#1eb6ca ;width: 382px;
                                    }
                                    #table2 #td2{
                                        width: 382px;
                                    } 
                                    #table3{
                                        margin-left:0px;margin-top: 10px;
                                    }
                                    #table3 #td1{
                                        width:382px;
                                        height: 50px;
                                    }
                                    #table3 #td2{
                                        width:382px;
                                        height: 50px;
                                    }
                                    #table4{
                                        margin-left:0px;
                                            margin-top: 20px;
                                            width: 100%;
                                    }
                                    #table4 #tr1{
                                        background-color:#1eb6ca; color:white;
                                    }
                                    #table4 #tr1 #th1{
                                        width: 350px;
                                    }
                                    #table4 #tr1 th{
                                        width:120px;
                                    }
                                    #table4 #td1 img{
                                        float: left;position:relative;
                                    }
                                    #table4 #td1 #p1{
                                        float: left;position:absolute; margin-top: 2px; margin-left: 40px;
                                    
                                    }
                                    #table4 #td1 #p2{
                                        float: left;position:relative;margin:0px;padding: 0px;margin-top: 18px; margin-left:5px
                                    
                                    }
                                    #table4 td{
                                        text-align: center;
                                    }
                                    
                                    #table6{
                                        margin-left:0px;margin-top: 20px;
                                    }
                                    #table6 td{
                                        width:0px;
                                    }
                                    #product_list_tempalte_invoice td{
                                            padding:5px;
                                    }
                                    #product_list_tempalte_invoice th{
                                            padding:5px;
                                    }
                                    .product_list_content_5{
                                    color:gray;
                                    border-left: 1px solid #808080;
                                        border-top: 1px solid #808080;
                                    border-right: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_content_4{
                                    color:gray;
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_content_2{
                                    color:gray;
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: left;
                                    border-left: none !important;
                                    }
                                    .product_list_content_3{
                                    color:gray;
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_content_1{
                                    border-top: 1px solid #808080;
                                    border-bottom: 1px solid #808080;
                                    border-left: 1px solid #808080;
                                    text-align: right;
                                    border-right: none !important;
                                    }
                                    .product_list_title_1{
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: right;
                                    border-right: none !important;
                                    }
                                    .product_list_title_2{
                                    border-top: 1px solid #808080;
                                    text-align: left;
                                    border-left: none !important;
                                    }
                                    .product_list_title_3{
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_title_4{
                                    border-left: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: center;
                                    }
                                    .product_list_title_5{
                                    border-left: 1px solid #808080;
                                    border-right: 1px solid #808080;
                                    border-top: 1px solid #808080;
                                    text-align: center;
                                    }
                                    
                                    #table5 #td01{
                                    width: 382px;
                                    }
                                    #table5{
                                    border-collapse: collapse;
                                    }
                                    #table5 #td04{
                                    position: relative;
                                    }
                                    #td01, #td03{
                                    font-size: 12px; 
                                    color:gray;
                                    }
                                    #td04,#td02,#td06,#td07,#td08{
                                    padding-left:50px;
                                    }
                                    #td02{
                                    padding-top:20px;
                                    }
                                    #td04,#td07{
                                    padding-top:10px;
                                    }
                                    #td06{
                                    padding-top:10px;
                                    }
                                    
                                    #table5 #td02{
                                        width:200px
                                    }
                                    #table5 .td00{
                                        width:182px
                                    padding-left:20px;
                                    }',
                'columns_number' => '5',
                'item_title' => ['Item','Description','Price','Qty','Total'],
                'item_key_value' => ['p_image','p_name','unit_price_ex_tax','qty','total_in_tax'],
                'item_title_color' => ['FFFFFF','FFFFFF','FFFFFF','FFFFFF','FFFFFF'],
                'item_title_background' => ['1EB6CA','1EB6CA','1EB6CA','1EB6CA','1EB6CA'],
                'public' => 1,
                'type_template' => 'delivery'
            ]
        ];
        foreach ($list_items as $data) {
            $data_insert = array(
                'name_template' 		=> (string)$data['name_template'],
                'template_landscape' 			=> (int)$data['template_landscape'],
                'template_invoice_header' 		=> ((string)$data['template_invoice_header']),
                'template_invoice_content' 		=> ((string)$data['template_invoice_content']),
                'template_invoice_footer' 		=> ((string)$data['template_invoice_footer']),
                'template_custom_css' => (string)$data['template_custom_css'],
                'columns_number' 		=> (int)$data['columns_number'],
                'item_title_json' 		=> json_encode( $data['item_title'] ),
                'item_key_value_json' 	=> json_encode( $data['item_key_value'] ),
                'item_title_color_json' 		=> json_encode( $data['item_title_color'] ),
                'item_title_background_Json' 	=> json_encode( $data['item_title_background'] ),
                'public' 		=> (int)$data['public'],
                'type' 					=> (string)$data['type_template'],
            );
            $wpdb->insert("{$wpdb->prefix}netbase_invoice_templates", $data_insert );
        }
    }
    function nb_invoice_template_install(){
        nd_create_settingDefault();
        nb_invoice_ceateDB();
        nb_invoice_ceateDB_demo();
    }