<?php
// Register and load the widget
function wpb_load_pcat_widget() {
	register_widget( 'printshop_pcat_widget' );
}
add_action( 'widgets_init', 'wpb_load_pcat_widget' );

// Creating the widget 
class printshop_pcat_widget extends WP_Widget {

	function __construct() {
		parent::__construct(

			// Base ID of your widget
			'printshop_pcat_widget', 

			// Widget name will appear in UI
			__('Printshop: Product Categories Widget', 'nb-elements'), 

			// Widget description
			array( 'description' => __( 'Sample widget based on WPBeginner Tutorial', 'nb-elements' ), ) 
		);
	}

	// Creating widget front-end
	public function widget( $args, $instance ) {
		global $post;
		$title = apply_filters( 'widget_title', $instance['title'] );
		$deprecated_term = (!empty($instance['deprecated_term'])?$instance['deprecated_term']:'no');

		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) )
			if($title){
				echo $args['before_title'] . $title . $args['after_title'];
			}

			$terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'hide_empty' => false,
			) );

			if($terms){
				echo '<ul class="product_categories">';
				foreach ($terms as $key => $term) {
					if($deprecated_term=='yes' && $term->count==0) {
						continue;
					}
					?>
					<li><a href="<?php echo esc_url(get_term_link($term)); ?>"><?php echo esc_attr( $term->name );?></a><span class="pc-count"><?php echo esc_attr($term->count);?></span></li>
					<?php
				}
				echo '</ul>';

			}

			echo $args['after_widget'];
		}

	// Widget Backend 
		public function form( $instance ) {
			if ( isset( $instance[ 'title' ] ) ) {
				$title = $instance[ 'title' ];
			}
			else {
				$title = __( 'New title', 'nb-elements' );
			}

		// Widget admin form
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'deprecated_term' ); ?>">Hidden the category is empty</label>
				<select id="<?php echo $this->get_field_id('deprecated_term'); ?>" name="<?php echo $this->get_field_name('deprecated_term'); ?>" class="widefat" style="width:100%;">
					<option <?php selected( $instance['deprecated_term'], 'no'); ?> value="no">No</option>
					<option <?php selected( $instance['deprecated_term'], 'yes'); ?> value="yes">Yes</option>
				</select>
			</p>
			<?php 
		}

	// Updating widget replacing old instances with new
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance[ 'deprecated_term' ] = $new_instance[ 'deprecated_term' ];
			return $instance;
		}
} // Class wpb_widget ends here