<?php
// Register and load the widget
function wpb_load_pslider_widget() {
    register_widget( 'printshop_price_slider_widget' );
}
add_action( 'widgets_init', 'wpb_load_pslider_widget' );
 
// Creating the widget 
class printshop_price_slider_widget extends WP_Widget {
 
	function __construct() {
		parent::__construct(
		 
			// Base ID of your widget
			'printshop_price_slider_widget', 
			 
			// Widget name will appear in UI
			__('Printshop: Price Slider Widget', 'nb-elements'), 
			 
			// Widget description
			array( 'description' => __( 'Sample widget based on WPBeginner Tutorial', 'nb-elements' ), ) 
		);


	}
 
	// Creating widget front-end
	public function widget( $args, $instance ) {
		global $post, $wp;
		$current_url = home_url(add_query_arg(array(),$wp->request));

		$title = apply_filters( 'widget_title', $instance['title'] );

		// Find min and max price in current result set.
		$prices = $this->get_filtered_price();

		$min    = (int)floor( $prices->min_price );
		$max    = (int)ceil( $prices->max_price );


		if( $min && $max && $min != $max) {
			// before and after widget arguments are defined by themes
			echo $args['before_widget'];
			if ( ! empty( $title ) ) {
				if($title){
					echo $args['before_title'] . $title . $args['after_title'];
				}



				wp_enqueue_style( 'asRange' );
				wp_enqueue_script( 'asRange' );

				?>
				<div class="wc-range-slider" data-min="<?php echo esc_attr( $min );?>" data-max="<?php echo esc_attr( $max );?>" data-currency="<?php echo get_woocommerce_currency_symbol();?>" data-url="<?php echo esc_url( $current_url );?>"></div>
				<div class="wc-action-filter">
					<div class="wcrs-price-show">Price: <span class="wcrs-price-show-from"><?php echo get_woocommerce_currency_symbol() . esc_attr( $min );?></span> - <span class="wcrs-price-show-to"><?php echo get_woocommerce_currency_symbol() . esc_attr( $max );?></span></div>
					<button type="button" class="button"><?php esc_html_e('Filter', 'nb-elements');?></button>

				</div>
				<div class="wcrs-price">
					<div class="wcrs-price-input">
						<span><?php echo get_woocommerce_currency_symbol();?></span><input type="text" name="wcrs-price-input-from" value="<?php echo esc_attr( $min );?>">
					</div>
					<span><?php esc_html_e('To', 'nb-elements');?></span>
					<div class="wcrs-price-input">
						<span><?php echo get_woocommerce_currency_symbol();?></span><input type="text" name="wcrs-price-input-to" value="<?php echo esc_attr( $max );?>">
					</div>
				</div>
				<?php
				echo $args['after_widget'];
			}
		}
	}
         
	// Widget Backend 
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		}
		else {
			$title = __( 'New title', 'nb-elements' );
		}
		// Widget admin form
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<?php 
	}
     
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}

	/**
	 * Get filtered min price for current products.
	 * @return int
	 */
	protected function get_filtered_price() {
		global $wpdb, $wp_the_query;

		$args       = $wp_the_query->query_vars;
		$tax_query  = isset( $args['tax_query'] ) ? $args['tax_query'] : array();
		$meta_query = isset( $args['meta_query'] ) ? $args['meta_query'] : array();

		if ( ! is_post_type_archive( 'product' ) && ! empty( $args['taxonomy'] ) && ! empty( $args['term'] ) ) {
			$tax_query[] = array(
				'taxonomy' => $args['taxonomy'],
				'terms'    => array( $args['term'] ),
				'field'    => 'slug',
			);
		}

		foreach ( $meta_query + $tax_query as $key => $query ) {
			if ( ! empty( $query['price_filter'] ) || ! empty( $query['rating_filter'] ) ) {
				unset( $meta_query[ $key ] );
			}
		}

		$meta_query = new WP_Meta_Query( $meta_query );
		$tax_query  = new WP_Tax_Query( $tax_query );

		$meta_query_sql = $meta_query->get_sql( 'post', $wpdb->posts, 'ID' );
		$tax_query_sql  = $tax_query->get_sql( $wpdb->posts, 'ID' );

		$sql  = "SELECT min( FLOOR( price_meta.meta_value ) ) as min_price, max( CEILING( price_meta.meta_value ) ) as max_price FROM {$wpdb->posts} ";
		$sql .= " LEFT JOIN {$wpdb->postmeta} as price_meta ON {$wpdb->posts}.ID = price_meta.post_id " . $tax_query_sql['join'] . $meta_query_sql['join'];
		$sql .= " 	WHERE {$wpdb->posts}.post_type IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_post_type', array( 'product' ) ) ) ) . "')
					AND {$wpdb->posts}.post_status = 'publish'
					AND price_meta.meta_key IN ('" . implode( "','", array_map( 'esc_sql', apply_filters( 'woocommerce_price_filter_meta_keys', array( '_price' ) ) ) ) . "')
					AND price_meta.meta_value > '' ";
		$sql .= $tax_query_sql['where'];

		if ( $search = WC_Query::get_main_search_query_sql() ) {
			$sql .= ' AND ' . $search;
		}


		return $wpdb->get_row( $sql );
	}
}