<?php
// Register and load the widget
function wpb_load_title_widget() {
	register_widget( 'printshop_title_widget' );
}
add_action( 'widgets_init', 'wpb_load_title_widget' );

// Creating the widget 
class printshop_title_widget extends WP_Widget {

	function __construct() {

		// This is where we add the style and script
		add_action( 'load-widgets.php', array(&$this, 'my_custom_load') );

		parent::__construct(

			// Base ID of your widget
			'printshop_title_widget', 

			// Widget name will appear in UI
			__('Printshop: Title Widget', 'nb-elements'), 

			// Widget description
			array( 'description' => __( 'Sample widget based on WPBeginner Tutorial', 'nb-elements' ), ) 
		);
	}

	function my_custom_load() {    
		wp_enqueue_style( 'wp-color-picker' );        
		wp_enqueue_script( 'wp-color-picker' );    
	}

	// Creating widget front-end
	public function widget( $args, $instance ) {
		global $post;
		$title = apply_filters( 'widget_title', $instance['title'] );
		$option_style = (!empty($instance['option_style'])?$instance['option_style']:'default');
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) )
			if($title) {
				echo str_replace('widget-title','widget-title '.$option_style, $args['before_title']) . $title . '<span></span>' . $args['after_title'];
			}

			echo $args['after_widget'];
		}

	// Widget Backend 
		public function form( $instance ) {
			if ( isset( $instance[ 'title' ] ) ) {
				$title = $instance[ 'title' ];
			}
			else {
				$title = __( 'New title', 'nb-elements' );
			}
		// Widget admin form
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'nb-elements' ); ?></label> 
				<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id( 'option_style' ); ?>"><?php _e( 'Style of title:', 'nb-elements' ); ?></label>
				<select id="<?php echo $this->get_field_id('option_style'); ?>" name="<?php echo $this->get_field_name('option_style'); ?>" class="widefat" style="width:100%;">
					<option <?php selected( $instance['option_style'], 'default'); ?> value="default"><?php _e( 'Default (No border)', 'nb-elements' ); ?></option>
					<option <?php selected( $instance['option_style'], 'border_below'); ?> value="border_below"><?php _e( 'Show border below the title', 'nb-elements' ); ?></option> 
					<option <?php selected( $instance['option_style'], 'border_right'); ?> value="border_right"><?php _e( 'Show border right the title', 'nb-elements' ); ?></option>   
				</select>
			</p>
			<?php 
		}

	// Updating widget replacing old instances with new
		public function update( $new_instance, $old_instance ) {
			$instance = array();
			$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
			$instance[ 'option_style' ] = $new_instance[ 'option_style' ];
			return $instance;
		}
} // Class wpb_widget ends here