<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Wc_List_Products extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'netbase_element_wc_list_products', array( $this, 'shortcode_element_wc_list_products' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
       
        vc_map(array(
            'name' => esc_html__('List Products', 'nb-elements'),
            'base' => 'netbase_element_wc_list_products',
            'category' => esc_html__('PrintCart', 'nb-elements'),
            
            "params" => array(
                array(
                    'type' 			=> 'textfield',
                    'heading' 		=> esc_html__( 'Block title', 'nb-elements' ),
                    'param_name' 	=> 'title',
                    'admin_label' 	=> true,
                    'value' 		=> '',
                    'description' 	=> ''
                ),
                

                array(
                    'heading'     => __( 'Background Image', 'nb-elements' ),
                    'param_name'  => 'background_img',
                    'type'        => 'attach_image',
                ),

                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Product type', 'nb-elements' ),
                    'param_name' 	=> 'product_type',
                    'admin_label' 	=> true,
                    'value' 		=> array(
                        esc_html__('Recent', 'nb-elements')		=> 'recent',
                        esc_html__('Featured', 'nb-elements')	=> 'featured',
                        esc_html__('Best Selling', 'nb-elements')	=> 'best_selling',
                        esc_html__('Top Rated', 'nb-elements')	=> 'top_rated',
                        esc_html__('Mixed Order', 'nb-elements')	=> 'mixed_order'
                    ),
                    'description' 	=> esc_html__( 'Select type of product', 'nb-elements' )
                ),

                
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Per page', 'nb-elements' ),
                    'value' => 8,
                    'save_always' => true,
                    'param_name' => 'per_page',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => __( 'The "per_page" shortcode determines how many posts to show on the page', 'nb-elements' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Columns', 'nb-elements' ),
                    'value' => array(
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                    ),
                    'std' => '4',
                    'param_name' => 'columns',
                    'save_always' => true,
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Box Align', 'nb-elements' ),
                    'param_name' 	=> 'box_align',
                    'admin_label' 	=> true,
                    'value' 		=> array(
                        esc_html__('Left', 'nb-elements')		=> 'text-left',
                        esc_html__('Center', 'nb-elements')	=> 'text-center',
                        esc_html__('Right', 'nb-elements')	=> 'text-right',
                    ),

                ),

            )
        ));
    }

    public function nb_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
                break;
            case 'best_selling':
                $args['meta_key'] 	= 'total_sales';
                $args['orderby'] 	= 'meta_value_num';
                $args['order'] 		= 'desc';
                break;
            case 'top_rated':
                $args['meta_key'] 	= '_wc_average_rating';
                $args['orderby'] 	= 'meta_value_num';
                $args['order'] 		= 'desc';
                break;
            case 'mixed_order':
                $args['orderby'] 	= 'rand';
                break;
            default: /* Recent */
                $args['orderby'] 	= 'date';
                $args['order'] 		= 'desc';
                break;
        }
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_element_wc_list_products($atts, $content = null)
    {
        extract(shortcode_atts(
            array(
                'title' 				=> '',
                'background_img' => '',
                'product_type'			=> 'recent',
                'per_page' 				=> 8,
                'columns' 				=> 4,
                'box_align' =>'text-left',
            ), $atts, 'nb_product_hotdeals'
        ));

        if ( !class_exists('WooCommerce') ){
            return;
        }
        $bg_image_style = '';
        
        if($background_img) {
            $bg_image      = wp_get_attachment_image_src($background_img, 'full');
            $bg_image_style = "style='background: url(" . esc_url( $bg_image[0] ) . ")  center/cover no-repeat'";
        }
        $per_page = absint($per_page);

        $args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
           /* 'product_cat' => $product_cat,*/
            'posts_per_page' => $per_page,
        );
        switch ($columns){
            case '1':
                $columns_class = '';
                break;
            case '2':
                $columns_class = 'two-columns';
                break;
            case '3':
                $columns_class = 'three-columns';
                break;
            case '4':
                $columns_class = 'four-columns';
                break;
            default:
                $columns_class ='four-columns';
                break;
        }

        $this->nb_filter_product_by_product_type($args, $product_type);

        ob_start();
        global $woocommerce_loop, $post, $product;

        /*$old_woocommerce_loop_columns = $woocommerce_loop['columns'];
        $woocommerce_loop['columns'] = $columns;*/

        $products = new WP_Query( $args );

        if( $products->have_posts() ){
            echo '<div class="shop-main '.$columns_class.' ">';
            echo '<div class="products row grid-type">';
            while( $products->have_posts() ){

                $products->the_post();
                wc_get_template_part( 'content', 'product' );
            }
            echo '</div>';
            echo '</div>';
        }

        wp_reset_postdata();

        return '<div class="nb-fw list_products woocommerce" ' . $bg_image_style . '>' . ob_get_clean() . '</div>';
    }

    

}
new NB_Element_Wc_List_Products();
}