<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Wc_Hotdeals extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'netbase_element_wc_hotdeals', array( $this, 'shortcode_element_wc_hotdeals' ) );
    }

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
       
        vc_map(array(
            'name' => esc_html__('Product Hotdeals', 'nb-elements'),
            'base' => 'netbase_element_wc_hotdeals',
            'category' => esc_html__('PrintCart', 'nb-elements'),
            'description' => esc_html__('Display Product Hotdeals.', 'nb-elements'),
            "params" => array(
                array(
                    'type' 			=> 'textfield',
                    'heading' 		=> esc_html__( 'Block title', 'nb-elements' ),
                    'param_name' 	=> 'title',
                    'admin_label' 	=> true,
                    'value' 		=> '',
                    'description' 	=> ''
                ),
                /*array(
                    'type' => 'colorpicker',
                    'admin_label' => true,
                    'heading' => esc_html__('Primary Color', 'nb-elements'),
                    'param_name' => 'primary_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),*/

                array(
                    'heading'     => __( 'Background Image', 'nb-elements' ),
                    'param_name'  => 'background_img',
                    'type'        => 'attach_image',
                ),

                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Product type', 'nb-elements' ),
                    'param_name' 	=> 'product_type',
                    'admin_label' 	=> true,
                    'value' 		=> array(
                        esc_html__('Recent', 'nb-elements')		=> 'recent',
                        esc_html__('Featured', 'nb-elements')	=> 'featured',
                        esc_html__('Best Selling', 'nb-elements')	=> 'best_selling',
                        esc_html__('Top Rated', 'nb-elements')	=> 'top_rated',
                        esc_html__('Mixed Order', 'nb-elements')	=> 'mixed_order'
                    ),
                    'description' 	=> esc_html__( 'Select type of product', 'nb-elements' )
                ),

                /*array(
                        'type' => 'dropdown',
                        'heading' => __( 'Category', 'nb-elements' ),
                        'value' => $product_categories_dropdown,
                        'param_name' => 'product_cats',
                        'save_always' => true,
                        'description' => __( 'Product category list', 'nb-elements' ),

                    ),*/
                array(
                    'type' => 'textfield',
                    'heading' => __( 'Per page', 'nb-elements' ),
                    'value' => 12,
                    'save_always' => true,
                    'param_name' => 'per_page',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => __( 'The "per_page" shortcode determines how many posts to show on the page', 'nb-elements' ),
                ),
                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Columns', 'nb-elements' ),
                    'value' => array(
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                        '5' => '5',
                        '6' => '6',
                    ),
                    'std' => '4',
                    'param_name' => 'columns',
                    'save_always' => true,
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Style', 'nb-elements' ),
                    'param_name' 	=> 'style',
                    'admin_label' 	=> true,
                    'std' => 'style1',
                    'value' 		=> array(
                        esc_html__('Style 1', 'nb-elements')		=> 'style1',
                        esc_html__('Style 2', 'nb-elements')	=> 'style2',
                    ),
                ),
                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Show counter', 'nb-elements' ),
                    'param_name' 	=> 'show_counter',
                    'admin_label' 	=> false,
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'value' 		=> array(
                        esc_html__('Yes', 'nb-elements')	=> 1,
                        esc_html__('No', 'nb-elements')	=> 0
                    ),
                    'description' 	=> ''
                ),

                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Show Description', 'nb-elements' ),
                    'param_name' 	=> 'show_des',
                    'admin_label' 	=> false,
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'value' 		=> array(
                        esc_html__('Yes', 'nb-elements')	=> 1,
                        esc_html__('No', 'nb-elements')	=> 0
                    ),
                    'description' 	=> ''
                ),

                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Show Add to Cart button', 'nb-elements' ),
                    'param_name' 	=> 'show_cart_button',
                    'admin_label' 	=> false,
                    'value' 		=> array(
                        esc_html__('Yes', 'nb-elements')	=> 1,
                        esc_html__('No', 'nb-elements')	=> 0
                    ),
                    'description' 	=> ''
                ),
                /*array(
                    'type' => 'colorpicker',
                    'admin_label' => true,
                    'heading' => esc_html__('Text Number Color', 'nb-elements'),
                    'param_name' => 'txt_number_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'dependency' => array(
                        'element' => 'show_counter',
                        'value'   => '1',
                    ),
                ),*/

               /* array(
                    'type' => 'colorpicker',
                    'admin_label' => true,
                    'heading' => esc_html__('Background Number Color', 'nb-elements'),
                    'param_name' => 'bg_number_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'dependency' => array(
                        'element' => 'show_counter',
                        'value'   => '1',
                    ),
                ),*/

                /*array(
                    'type' => 'colorpicker',
                    'admin_label' => true,
                    'heading' => esc_html__('Border Number Color', 'nb-elements'),
                    'param_name' => 'border_number_color',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'dependency' => array(
                        'element' => 'show_counter',
                        'value'   => '1',
                    ),
                ),*/
                /*array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Style box Number', 'nb-elements' ),
                    'param_name' 	=> 'style_box_number',
                    'admin_label' 	=> true,
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'value' 		=> array(
                        esc_html__('Circle', 'nb-elements')		=> 'circle',
                        esc_html__('Square', 'nb-elements')	=> 'square',
                    ),

                ),*/
                array(
                    'type' 			=> 'dropdown',
                    'heading' 		=> esc_html__( 'Box Align', 'nb-elements' ),
                    'param_name' 	=> 'box_align',
                    'admin_label' 	=> true,
                    'value' 		=> array(
                        esc_html__('Left', 'nb-elements')		=> 'text-left',
                        esc_html__('Center', 'nb-elements')	=> 'text-center',
                        esc_html__('Right', 'nb-elements')	=> 'text-right',
                    ),

                ),

            )
        ));
    }

    public function nb_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
                break;
            case 'best_selling':
                $args['meta_key'] 	= 'total_sales';
                $args['orderby'] 	= 'meta_value_num';
                $args['order'] 		= 'desc';
                break;
            case 'top_rated':
                $args['meta_key'] 	= '_wc_average_rating';
                $args['orderby'] 	= 'meta_value_num';
                $args['order'] 		= 'desc';
                break;
            case 'mixed_order':
                $args['orderby'] 	= 'rand';
                break;
            default: /* Recent */
                $args['orderby'] 	= 'date';
                $args['order'] 		= 'desc';
                break;
        }
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_element_wc_hotdeals($atts, $content = null)
    {
        extract(shortcode_atts(
            array(
                'title' 				=> '',
                /*'primary_color' => '',*/
                'background_img' => '',
                'product_type'			=> 'recent',
                'per_page' 				=> 5,
                'columns' 				=> 4,
                'style' => 'style1',
                'show_counter'			=> 1,
                'show_des'			=> 1,
                'show_cart_button'			=> 1,
                /*'txt_number_color' 			=> '',*/
                /*'bg_number_color' => '',*/
                /*'border_number_color' => '',*/
                /*'style_box_number' => 'circle',*/
                'box_align' =>'text-left',

            ), $atts, 'nb_product_hotdeals'
        ));

        if ( !class_exists('WooCommerce') ){
            return;
        }
        $colortitle = $css = $bg_image_style = '';
        /*if ( $txt_number_color != '') {
            $css .= 'color:' . $txt_number_color . ';';
        }
        if ( $css ) {
            $css = ' style="' . $css . '"';
        }*/

        /*if ( $primary_color != '') {
            $colortitle .= 'color:' . $primary_color . ';';
        }
        if ( $colortitle ) {
            $colortitle = ' style="' . $colortitle . '"';
        }*/

        if($background_img) {
            $bg_image      = wp_get_attachment_image_src($background_img, 'full');
            $bg_image_style = "style='background: url(" . esc_url( $bg_image[0] ) . ")  center/cover no-repeat'";
        }
        $per_page = absint($per_page);
        $id = uniqid('netbase_custom_css_');
        /*if( $show_counter ){
            add_action('woocommerce_after_shop_loop_item_title', 'printshop_template_loop_time_deals', 65);
        }*/

        $args = array(
            'post_type'				=> array('product', 'product_variation')
        ,'post_status' 			=> 'publish'
        ,'ignore_sticky_posts'	=> 1
        ,'posts_per_page' 		=> -1
        ,'orderby' 				=> 'date'
        ,'order' 				=> 'desc'
        ,'meta_query' => array(
                array(
                    'key'		=> '_sale_price_dates_to'
                ,'value'	=> current_time( 'timestamp', true )
                ,'compare'	=> '>'
                ,'type'		=> 'numeric'
                )
            ,array(
                    'key'		=> '_sale_price_dates_from'
                ,'value'	=> current_time( 'timestamp', true )
                ,'compare'	=> '<'
                ,'type'		=> 'numeric'
                )
            )
        ,'tax_query'		=> array()
        );

        $this->nb_filter_product_by_product_type($args, $product_type);

        ob_start();
        global $woocommerce_loop, $post, $product;

        $old_woocommerce_loop_columns = $woocommerce_loop['columns'];
        $woocommerce_loop['columns'] = $columns;

        $product_ids_on_sale = array();

        $products = new WP_Query( $args );

        if( $products->have_posts() ){
            while( $products->have_posts() ){
                $products->the_post();
                if( $post->post_type == 'product' ){
                    $_product = wc_get_product( $post->ID );
                    if( is_object( $_product ) && $_product->is_visible() ){
                        /*if( isset($product_cats) && $product_cats!='' ){
                            $post_terms = wp_get_post_terms($post->ID, 'product_cat', array('fields' => $product_cats));
                            if( is_array($post_terms) ){
                                $product_ids_on_sale[] = $post->ID;

                            }
                        }else{*/
                        $product_ids_on_sale[] = $post->ID;
                        /*}*/
                    }
                }
                else{ /* Variation product */
                    $post_parent_id = $post->post_parent;
                    $parent_product = wc_get_product( $post_parent_id );
                    if( is_object( $parent_product ) && $parent_product->is_visible() ){
                        $product_ids_on_sale[] = $post_parent_id;

                    }
                }

                $product_ids_on_sale = array_unique($product_ids_on_sale);
                if( count($product_ids_on_sale) == $per_page ){
                    break;
                }
            }
        }

        if( count($product_ids_on_sale) == 0 ){
            $product_ids_on_sale = array(0);
        }

        $args = array(
            'post_type'				=> 'product'
        ,'post_status' 			=> 'publish'
        ,'ignore_sticky_posts'	=> 1
        ,'posts_per_page' 		=> $per_page
        ,'orderby' 				=> 'date'
        ,'order' 				=> 'desc'
        ,'post__in'				=> $product_ids_on_sale
        ,'meta_query' 			=> WC()->query->get_meta_query()
        ,'tax_query'           	=> WC()->query->get_tax_query()
        );
        $this->nb_filter_product_by_product_type($args, $product_type);
        $products = new WP_Query($args);

        if( $products->have_posts() ):
            if( strlen($title) > 0 ):
                echo '<h3 class="heading-title">'. esc_html($title).'</h3>';
            endif; ?>

            <div class="hotdeal-content-wrapper <?php echo $style; ?>">
                    <?php while( $products->have_posts() ): $products->the_post();
                        global $product;
                        ?>
                        <div class="hotdeal-list-wrap <?php echo $box_align; ?>">
                            <div class="item-product-image">
                                <?php
                                if (has_post_thumbnail()) the_post_thumbnail();
                                if ( $product->is_on_sale() ) {

                                    if ( ! $product->is_type( 'variable' ) ) {
                                        $max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;

                                    } else {
                                        $max_percentage = 0;
                                        foreach ( $product->get_children() as $child_id ) {
                                            $variation = wc_get_product( $child_id );
                                            $price = $variation->get_regular_price();
                                            $sale = $variation->get_sale_price();
                                            if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
                                            if ( $percentage > $max_percentage ) {
                                                $max_percentage = $percentage;
                                            }
                                        }
                                    }
                                    echo '<div class="sale-perc"><span>'. esc_html__( "Sale", 'nb-elements' ).'</span> -' . round($max_percentage) . '%</div>';
                                }
                                ?>
                            </div>
                            <div class="item-product-meta">
                                <?php
                                if($style =='style2'){
                                    if( $show_counter ){
                                        echo '<div '.$css.'>';
                                        $this->printshop_template_loop_time_deals();
                                        echo '</div>';
                                    }
                                }
                                the_title( '<h2 class="product_title entry-title">', '</h2>' );
                                echo $product->get_price_html();
                                if($show_des){
                                    if ( has_excerpt() ){
                                        echo '<p class="product-description">' . wp_trim_words(get_the_excerpt(),18,'...') . '</p>';
                                    }
                                }
                                if($style !='style2'){
                                    if( $show_counter ){
                                        echo '<div '.$css.'>';
                                        $this->printshop_template_loop_time_deals();
                                        echo '</div>';
                                    }
                                }
                                if($show_cart_button){
                                    $product_link = get_permalink( $products->ID );
                                ?>
                                    <a rel="nofollow" href="<?php echo esc_attr($product_link);?>" class="button product-go-to-shop-now"><?php echo esc_html__( 'SHOP NOW', 'nb-elements' );?></a>
                                <?php } ?>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
        <?php
        endif;

        wp_reset_postdata();

        return '<div id="' . esc_attr($id) . '" class="nb-fw product_hotdeals woocommerce" ' . $bg_image_style . '>' . ob_get_clean() . '</div>';
    }

    public function printshop_template_loop_time_deals(){
        global $product;
        $date_to = '';
        $date_from = '';
        if( $product->get_type() == 'variable' ){
            $children = $product->get_children();
            if( is_array($children) && count($children) > 0 ){
                foreach( $children as $children_id ){
                    $date_to = get_post_meta($children_id, '_sale_price_dates_to', true);
                    $date_from = get_post_meta($children_id, '_sale_price_dates_from', true);
                    if( $date_to != '' ){
                        break;
                    }
                }
            }
        }
        else{
            $date_to = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
            $date_from = get_post_meta($product->get_id(), '_sale_price_dates_from', true);
        }

        $current_time = current_time('timestamp', true);

        if( $date_to == '' || $date_from == '' || $date_from > $current_time || $date_to < $current_time ){
            return;
        }

        $delta = $date_to - $current_time;

        $time_day = 60 * 60 * 24;
        $time_hour = 60 * 60;
        $time_minute = 60;

        $day = floor( $delta / $time_day );
        $delta -= $day * $time_day;

        $hour = floor( $delta / $time_hour );
        $delta -= $hour * $time_hour;

        $minute = floor( $delta / $time_minute );
        $delta -= $minute * $time_minute;

        if( $delta > 0 ){
            $second = $delta;
        }
        else{
            $second = 0;
        }

        $day = zeroise($day, 2);
        $hour = zeroise($hour, 2);
        $minute = zeroise($minute, 2);
        $second = zeroise($second, 2);

        ?>
        <div class="counter-wrapper days-<?php echo strlen($day); ?>">
            <div class="days">
                <div class="number-wrapper">
                    <span class="number"><?php echo esc_html($day); ?></span>
                </div>
                <div class="ref-wrapper">
                    <?php esc_html_e('Days', 'nb-elements'); ?>
                </div>
            </div>
            <div class="hours">
                <div class="number-wrapper">
                    <span class="number"><?php echo esc_html($hour); ?></span>
                </div>
                <div class="ref-wrapper">
                    <?php esc_html_e('Hours', 'nb-elements'); ?>
                </div>
            </div>
            <div class="minutes">
                <div class="number-wrapper">
                    <span class="number"><?php echo esc_html($minute); ?></span>
                </div>
                <div class="ref-wrapper">
                    <?php esc_html_e('Mins', 'nb-elements'); ?>
                </div>
            </div>
            <div class="seconds">
                <div class="number-wrapper">
                    <span class="number"><?php echo esc_html($second); ?></span>
                </div>
                <div class="ref-wrapper">
                    <?php esc_html_e('Secs', 'nb-elements'); ?>
                </div>
            </div>
        </div>
        <?php
    }

}
new NB_Element_Wc_Hotdeals();
}