<?php
if (!defined('ABSPATH'))
  exit;

if (class_exists("WPBakeryShortCode")) {
  class NB_Element_Feature_Posts extends WPBakeryShortCode {
    function __construct() {
      add_action( 'init', array( $this, 'map' ), 12 );
      add_shortcode( 'vc_printshop_feature', array( $this, 'vc_printshop_feature' ) );
    }

    public function map() {
      vc_map( array(
        "name" => __( "Feature Posts", "nb-elements" ),
        "base" => "vc_printshop_feature",
        "class" => "",
        "category" => __( "PrintCart", "nb-elements"),
        "params" => array(
          array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __( "Title", "nb-elements" ),
            "param_name" => "vc_tab_title_post",
            "value" => 8,
          ),
          array(
            "type" => "textarea",
            "heading" => __( "Description", 'nb-elements' ),
            "param_name" => "description_post",
            "value" => __( "", 'nb-elements' ),
            "description" => __( "Enter description.", 'nb-elements'),
          ),
          array(
            'type' => 'param_group',
            'value' => '',
            'heading' => __('Lists', 'nb-elements'),
            'param_name' => 'add_vc_feature_lists',
            'group' => __('Content Options', 'nb-elements'),
            // Note params is mapped inside param-group:
            'params' => array(
                array(
                  "type" => "textfield",
                  "holder" => "div",
                  'group' => __('Content Options', 'nb-elements'),
                  "class" => "",
                  "heading" => __( "ID", "nb-elements" ),
                  "param_name" => "add_vc_feature_posts",
                  "value" => '',
              )
            )
          ),
          array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => __( "Limit", "nb-elements" ),
            "param_name" => "vc_tab_product_limit",
            "value" => 8,
          )
        )
      ));
    }

    public function vc_printshop_feature($atts, $content = null) {
      extract( shortcode_atts( array(
          'vc_tab_title_post' => '',
          'description_post' => '',
          'vc_tab_product_limit' => 8
      ), $atts ) );
    
    
      ob_start();
      $add_vc_feature_lists = vc_param_group_parse_atts($atts['add_vc_feature_lists']);
      if($add_vc_feature_lists) {
      ?>
      <div class="vc-getto-info">
          <div class="vc-getto-para">
            <h2 class="vc-heading-title"><?php echo $vc_tab_title_post; ?></h2>
            <?php echo $description_post; ?>
          </div>
    
          <div class="vc-getto-blog">
            <?php foreach ($add_vc_feature_lists as $key => $feature) {
                $feature_post = get_post($feature['add_vc_feature_posts']);
                $add_vc_feature_posts = wp_get_attachment_image_src(get_post_thumbnail_id( $feature['add_vc_feature_posts'] ), 'blog-thumb');
                ?>
                <div class="getblog-item">
                  <a href="<?php echo get_permalink($feature['add_vc_feature_posts']);?>" title="<?php echo esc_attr($feature_post->post_title);?>"><img src="<?php echo esc_url($add_vc_feature_posts[0]);?>" /></a> 
                  <div class="bg-getblog-item">
                      <h3><a href="<?php echo get_permalink($feature['add_vc_feature_posts']);?>" title="<?php echo esc_attr($feature_post->post_title);?>"><?php echo esc_attr(get_excerpt($feature_post->post_title, 5, '...'));?></a></h3>
                      <p><?php echo get_excerpt($feature_post->post_content, 30, '...');?></p>
                      <a href="<?php echo get_permalink($feature['add_vc_feature_posts']);?>" class="learn-more"><?php esc_html_e( 'Learn more', 'nb-elements' );?> <i class="long-arrow-right"></i></a>
                  </div>
                </div>
                <?php
            }?>
          </div>
      </div>
      <?php
      }
      
      return ob_get_clean();
    }
  }

  new NB_Element_Feature_Posts();
}