<?php
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
    class NB_Element_Contact_Info extends WPBakeryShortCode {
        function __construct() {
            add_action( 'init', array( $this, 'map' ), 12 );
            add_shortcode( 'vc_printshop_cinfo', array( $this, 'shortcode_contact_info' ) );
        }

        public function map() {
            vc_map( array(
                "name" => __( "Contact Info", "nb-elements" ),
                "base" => "vc_printshop_cinfo",
                "class" => "",
                "category" => __( "PrintCart", "nb-elements"),
                "params" => array(
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __( "Title", "nb-elements" ),
                        "param_name" => "vc_tab_title_post",
                        "value" => 8,
                    ),
                    array(
                        "type" => "textarea",
                        "heading" => __( "Description", 'nb-elements' ),
                        "param_name" => "description_post",
                        "value" => __( "", 'nb-elements' ),
                        "description" => __( "Enter description.", 'nb-elements'),
                    ),
                    array(
                        'type' => 'param_group',
                        'value' => '',
                        'heading' => __('Info', 'nb-elements'),
                        'param_name' => 'add_vc_cinfo_lists',
                        'group' => __('Content Options', 'nb-elements'),
                      // Note params is mapped inside param-group:
                        'params' => array(
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-elements'),
                                "class" => "",
                                "heading" => __( "Icon", "nb-elements" ),
                                "param_name" => "add_vc_cinfo_icon",
                                "value" => '',
                            ),
                            array(
                                "type" => "textfield",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-elements'),
                                "class" => "",
                                "heading" => __( "Label", "nb-elements" ),
                                "param_name" => "add_vc_cinfo_label",
                                "value" => '',
                            ),
                            array(
                                "type" => "textarea",
                                "holder" => "div",
                                'group' => __('Content Options', 'nb-elements'),
                                "class" => "",
                                "heading" => __( "Description", "nb-elements" ),
                                "param_name" => "add_vc_cinfo_description",
                                "value" => '',
                            ),
                        )
                    ),
                    array(
                        "type" => "textfield",
                        "holder" => "div",
                        "class" => "",
                        "heading" => __( "Limit", "nb-elements" ),
                        "param_name" => "vc_tab_product_limit",
                        "value" => 8,
                    )
                )
            ));
        }

        public function shortcode_contact_info($atts, $content = null) {
            extract( shortcode_atts( array(
                'vc_tab_title_post' => '',
                'description_post' => '',
                'vc_tab_product_limit' => 8
            ), $atts ) );
        
        
            ob_start();
            $add_vc_cinfo_lists = vc_param_group_parse_atts($atts['add_vc_cinfo_lists']);
            if($add_vc_cinfo_lists) {
            ?>
            <div class="vc-pcontact-info">
            <div class="vc-pcontact-para">
                <h3><?php echo $vc_tab_title_post; ?></h3>
                <?php echo $description_post; ?>
            </div>
        
            <ul>
                <?php
                foreach ($add_vc_cinfo_lists as $key => $value) {?>
                    <li>
                        <i class="<?php echo esc_attr($value['add_vc_cinfo_icon']);?>"></i>
                        <div class="cinfo-lists">
                        <h5><?php echo esc_attr($value['add_vc_cinfo_label']);?></h5>
                        <div class="cinfo-description"><?php echo $value['add_vc_cinfo_description'];?></div>
                        </div>
                    </li>
                    <?php
                } ?>
            </ul>
            </div>
            <?php
            }
            
            return ob_get_clean();
        }
    }

    new NB_Element_Contact_Info();
}