<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Product Tabs
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Product_Tabs extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'vc_printshop_tab_product', array( $this, 'vc_printshop_tab_product' ) );
        add_shortcode( 'yith_compare_buttons', array( $this, 'yith_compare_buttons' ) );
        add_action('wp_ajax_product_tabs', array($this, 'product_tabs_ajax_content'));
        add_action('wp_ajax_nopriv_product_tabs', array($this, 'product_tabs_ajax_content'));
    }
    
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }

        $args = array(
            'type' => 'post',
            'child_of' => 0,
            'parent' => '',
            'orderby' => 'parent',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'number' => '',
            'taxonomy' => 'product_cat',
            'pad_counts' => false,
        );
        $categories = get_categories( $args );
        $product_categories_dropdown[] = array(
                'label' => 'All categories',
                'value' => '',
        );
        $this->getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
         
        vc_map( array(
            "name" => __( "Product Tabs", "nb-elements" ),
            "base" => "vc_printshop_tab_product",
            "class" => "",
            "category" => __( "PrintCart", "nb-elements"),


            "params" => array(

                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__( 'Product type', 'nb-elements' ),
                    'param_name'    => 'product_type',
                    'admin_label'   => true,
                    'value'         => array(
                            esc_html__('Recent', 'nb-elements')       => 'recent',
                            esc_html__('Featured', 'nb-elements') => 'featured',
                            esc_html__('Best Selling', 'nb-elements') => 'best_selling',
                            esc_html__('Top Rated', 'nb-elements')    => 'top_rated',
                            esc_html__('Mixed Order', 'nb-elements')  => 'mixed_order'
                            ),
                    'description'   => esc_html__( 'Select type of product', 'nb-elements' ),
                    'group'         =>'Content',
                ),

                array(
                    'type'          => 'param_group',
                    'value'         => '',
                    'heading'       => __('Product Categories', 'nb-elements'),
                    'param_name'    => 'vc_tab_product_lists',
                    'group'         =>'Content',
                    'params'        => array(
                        array(
                            "type"          => "textfield",
                            "holder"        => "div",
                            "class"         => "",
                            "heading"       => __( "Label", "nb-elements" ),
                            "param_name"    => "vc_tab_product_label",
                            "value"         => '',
                        ),
                        array(
                            'type'          => 'dropdown',
                            'heading'       => __('Product Cat', 'nb-elements'),
                            'param_name'    => 'vc_tab_product_cat',
                            'value'         => $product_categories_dropdown,
                            'save_always'   => true,
                            'admin_label'   => true,
                            'dependency'    => array(
                                'element'   => 'layout',
                                'value_not_equal_to' => 'wp-list',
                            ),
                        ),
                        array(
                            'param_name' => 'cat_img',
                            'heading'    => esc_html__( 'Category Images', 'nb-elements' ),
                            'type'       => 'attach_images',
                        ),
                        array(
                            'param_name'    => 'cat_img_url',
                            'heading'       => esc_html__( 'Image URLs', 'nb-elements' ),
                            'type'          => 'exploded_textarea',
                            'description'   => esc_html__( 'Each URL is a new line', 'nb-elements' )
                        ),
                        array(
                            'type' => 'dropdown',
                            'heading' => esc_html__( 'Category Images Align', 'nb-elements' ),
                            'value' => array(
                                esc_html__('Left', 'nb-elements') => 'left',
                                esc_html__('Right', 'nb-elements') => 'right',
                                esc_html__('Top', 'nb-elements') => 'top',
                                esc_html__('Bottom', 'nb-elements') => 'bottom',
                            ),
                            'std' => 'left',
                            'param_name' => 'cat_img_align',                                
                            'save_always' => true,
                        ),
                    )
                ),
                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab color", "nb-elements" ),
                   "param_name"         => "tab_color",
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Dark', 'nb-elements' )         => 'dark',
                       __( 'Light', 'nb-elements' )        => 'light'
                   ),
                ),
                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab style", "nb-elements" ),
                   "param_name"         => "tab_style",
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Rounded', 'nb-elements' )         => 'rounded',
                       __( 'Separated', 'nb-elements' )       => 'separated',
                       __( 'Classic', 'nb-elements' )         => 'classic',
                       __( 'Border bottom', 'nb-elements' )   => 'border_bottom',
                   ),
                ),

                array(
                   "type"               => "dropdown",
                   "heading"            => __( "Tab align", "nb-elements" ),
                   "param_name"         => "tab_title_align",
                   'group'              =>'Content',
                   'value'              => array(                            
                       __( 'Center', 'nb-elements' )      => 'center',
                       __( 'Left', 'nb-elements' )        => 'left',
                       __( 'Right', 'nb-elements' )       => 'right'
                   ),
                ),
                array(
                    "type"          => "textfield",
                    "holder"        => "div",
                    "class"         => "",
                    "heading"       => __( "Limit", "nb-elements" ),
                    "param_name"    => "vc_tab_product_limit",
                    'group'         =>'Content',
                    "value"         => 8,
                ),
                array(
                   "type"           => "dropdown",
                   "heading"        => __( "Column", "nb-elements" ),
                   "param_name"     => "vc_tab_product_col",
                   'std'            => 4,
                   'group'          =>'Content',
                   'value'          => array(                            
                       __( '1', 'nb-elements' )       => 1,
                       __( '2', 'nb-elements' )       => 2,
                       __( '3', 'nb-elements' )       => 3,
                       __( '4', 'nb-elements' )       => 4,
                       __( '5', 'nb-elements' )       => 5,
                   ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading', 'nb-elements' ),
                    'param_name'  => 'heading_tab',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading Color', 'nb-elements' ),
                    'param_name'  => 'heading_tab_color',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    'group'=>'Heading',
                    "heading" => __( "Heading Font size", "nb-elements" ),
                    "param_name" => "heading_font_size",
                    "value" => '', 
                    "description" => __( "Add heading font size ( Example: 15px or 15% )", "nb-elements" )
                ),

                array(
                    'type' => 'checkbox',
                    'heading' => __( 'Show Heading Line', 'nb-elements' ),
                    'param_name' => 'show_heading_line',
                    'group'=>'Heading',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Sub Heading', 'nb-elements' ),
                    'param_name'  => 'sub_heading_tab',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Sub Heading Color', 'nb-elements' ),
                    'param_name'  => 'sub_heading_tab_color',
                    'value'       => '',
                    'group'       =>'Heading',
                ),
                array(
                    "type" => "textfield",
                    "class" => "",
                    'group'=>'Heading',
                    "heading" => __( "Sub Heading Font size", "nb-elements" ),
                    "param_name" => "sub_heading_font_size",
                    "value" => '', 
                    "description" => __( "Add sub heading font size ( Example: 15px or 15% )", "nb-elements" )
                ),
                 array(
                    "type" => "textfield",
                    "class" => "",
                    'group'=>'Heading',
                    "heading" => __( "Add text button", "nb-elements" ),
                    "param_name" => "text_button",
                    "value" => '', 
                    "description" => __( "Add text button", "nb-elements" )
                ),
            )
        ));
    }     
     
    // Element HTML
    public function vc_printshop_tab_product($atts, $content = null)
    {
        extract( shortcode_atts( array(
            'heading_tab'               => '',
            'heading_tab_color'         => '',
            'show_heading_line'         => '',
            'sub_heading_tab'           => '',
            'sub_heading_tab_color'     => '',
            'heading_font_size'         => '',
            'sub_heading_font_size'     => '',
            'tab_color'                 => 'dark',
            'tab_style'                 => 'rounded',
            'tab_title_align'           => 'center',
            'product_type'              => '',
            'vc_tab_product_lists'      => '',
            'vc_tab_product_limit'      => 8,
            'vc_tab_product_col'        => 4,
            'text_button'               => '',
        ), $atts ) );

        ob_start();
        $vc_tab_product_lists = vc_param_group_parse_atts($vc_tab_product_lists);

        // Generate custom ID
        $product_tab_id = uniqid('product_tab_');

        if($vc_tab_product_lists):

            $columns = printcart_get_options('nbcore_loop_columns');

            if( $vc_tab_product_col == 4 ) {
                $columns = 'four-columns';
            } elseif( $vc_tab_product_col == 3 ) {
                $columns = 'three-columns';
            } elseif( $vc_tab_product_col == 2 ) {
                $columns = 'two-columns';
            } elseif( $vc_tab_product_col == 5 ) {
                $columns = 'five-columns';
            }

            $has_separated_border_class = printcart_get_options('nbcore_show_separated_border') ? 'has-separated-border' : '';


            $tab_title_align_class = 'align-' . $tab_title_align;
            $tab_style_class = 'style-' . $tab_style;
            $tab_color_class = $tab_color;

            $heading_tab_inline_css = $sub_heading_tab_inline_css = '';


            if($heading_tab_color != '') {
                $heading_tab_inline_css .= 'color: ' . $heading_tab_color . ';';
            }
            
            if($heading_font_size != '') {
                $heading_tab_inline_css .= 'font-size: ' . $heading_font_size . ';';
            }

            $heading_tab_css = $heading_tab_inline_css != '' ? 'style="' . $heading_tab_inline_css . '"' : '';


            if($sub_heading_tab_color != '') {
                $sub_heading_tab_inline_css .= 'color: ' . $sub_heading_tab_color . ';';
            }

            if($sub_heading_font_size != '') {
                $sub_heading_tab_inline_css .= 'font-size: ' . $sub_heading_font_size . ';';
            }

            $sub_heading_tab_css = $sub_heading_tab_inline_css != '' ? 'style="' . $sub_heading_tab_inline_css . '"' : '';


            $no_header_class = ($heading_tab == '' && $sub_heading_tab == '') ? 'no-heading' : '';

            $show_heading_line_class = $show_heading_line ? 'show_heading_line' : '';


        ?>
        <div class="shop-main <?php echo esc_attr($columns)  . ' ' . esc_attr($has_separated_border_class);?>">
            <div class="vc-tab-product-wrapper">
                
                <div class="vc-tab-product-header">

                    <?php if($heading_tab != '' || $sub_heading_tab != ''):?>
                        <div class="product-tab-header <?php echo esc_attr($show_heading_line_class);?>">
                            <?php if($sub_heading_tab != ''):?>
                                <p <?php echo $sub_heading_tab_css;?>><?php echo esc_html($sub_heading_tab);?></p>
                            <?php endif;?>

                            <?php if($heading_tab != ''):?>
                                <h2 <?php echo $heading_tab_css;?>><?php echo esc_html($heading_tab);?></h2>
                            <?php endif;?>
                        </div>
                    <?php endif;?>

                    <ul class="tab-label <?php echo esc_attr($tab_title_align_class);?> <?php echo esc_attr($tab_style_class);?> <?php echo esc_attr($tab_color_class);?> <?php echo esc_attr($no_header_class);?>">

                        <?php 
                            $div_content                = '';
                            $first_tab_label            = '';
                            $first_cat_img_align_class  = '';
                        ?>
                        <?php foreach ($vc_tab_product_lists as $tab_key => $tab_value):

                            $term                   = get_term_by( 'slug', $tab_value['vc_tab_product_cat'], 'product_cat' );
                            $cat_name               = is_object($term) ? $term->name : esc_html__('All categories');
                            $tab_label              = isset($tab_value['vc_tab_product_label']) ? $tab_value['vc_tab_product_label'] : $cat_name;
                            $cat_images             = isset($tab_value['cat_img']) ? $tab_value['cat_img'] : '';
                            $cat_img_align_class    = ! empty($tab_value['cat_img']) && ! empty($tab_value['cat_img_align']) ? 'img-align-' . $tab_value['cat_img_align'] : '';
                            $cat_img_align          = isset($tab_value['cat_img_align']) ? $tab_value['cat_img_align'] : 'left';
                            $cat_img_urls          = isset($tab_value['cat_img_url']) ? $tab_value['cat_img_url'] : '';

                            if($tab_key == 0) {
                                $first_tab_label = $tab_label;
                                $first_cat_img_align_class = $cat_img_align_class;
                            }
                            else {
                                $div_content .= '<div id="' . md5($product_tab_id.$tab_key.$tab_label).'" class="tab-panel ' . esc_attr($cat_img_align_class) . '" data-term_id="'.esc_attr($tab_value['vc_tab_product_cat']).'" data-limit="'.esc_attr($vc_tab_product_limit).'" data-product-type="'.esc_attr($product_type).'" data-cat-img="' . esc_attr($cat_images) . '" data-cat-img-align="' . esc_attr($cat_img_align) . '" data-cat-img-urls="' . esc_attr($cat_img_urls) . '"></div>';
                            }
                        ?>
                            <li <?php if($tab_key == 0) echo 'class="active"';?>>
                                <a href="#<?php echo md5($product_tab_id.$tab_key.$tab_label);?>"><?php echo esc_html($tab_label);?></a>
                            </li>
                        <?php endforeach;?>
                    </ul>
                </div>
                
                <div class="vc-tab-product-content <?php echo esc_attr($tab_color_class);?>">

                    <div id="<?php echo md5($product_tab_id.'0'.$first_tab_label);?>" class="tab-panel panel-active <?php echo esc_attr( $first_cat_img_align_class );?>" >
                        <?php

                            if ( ! empty( $vc_tab_product_lists[0]['cat_img'] ) ) {

                                echo '<div class="cat_img">';

                                $cat_images = explode(',', $vc_tab_product_lists[0]['cat_img']);

                                foreach($cat_images as $index => $cat_img)
                                {
                                    $img_data = wp_get_attachment_image_src( $cat_img, 'full' );

                                    $image_links = isset($vc_tab_product_lists[0]['cat_img_url']) ? explode(',', $vc_tab_product_lists[0]['cat_img_url']) : '';

                                    $image_link = isset($image_links[$index]) ? 'href="' . $image_links[$index] . '"' : '';

                                    echo '<a ' . $image_link . '><img src="' . esc_url( $img_data[0] ) . '" alt="' . esc_attr__( 'image-cat', 'nb-elements' ) . '" /><div class="buttons">'.$text_button.'</div></a>';
                                }

                                echo '</div>';
                            }

                            $product_cat = isset($vc_tab_product_lists[0]['vc_tab_product_cat']) ? $vc_tab_product_lists[0]['vc_tab_product_cat'] : '';

                            $tab_args = array(
                                'post_type' => 'product',
                                'post_status' => 'publish',
                                'product_cat' => $product_cat,
                                'posts_per_page' => $vc_tab_product_limit
                            );

                            $this->nb_filter_product_by_product_type($tab_args, $product_type);

                            $tab_product = new WP_Query( $tab_args );

                            if ( $tab_product->have_posts() ) :
                                echo '<div class="products row grid-type">';

                                while ( $tab_product->have_posts() ) : $tab_product->the_post();
                                    wc_get_template_part( 'content', 'product' );
                                endwhile;

                                echo '</div>';
                            endif;
                            wp_reset_postdata();
                        ?>
                   </div>
                   
                   <?php print $div_content; ?>
                </div>
            </div>
        </div>
         <?php

        endif;
         
         return ob_get_clean();
    }

    function product_tabs_ajax_content() {
        $product_cat    = $_POST['cat'];
        $limit          = absint($_POST['limit']);
        $cat_imgs       = $_POST['cat_img'];
        $cat_img_urls   = $_POST['cat_img_urls'];
        $product_type   = $_POST['product_type'];

        if ( ! empty( $cat_imgs ) ) {

            echo '<div class="cat_img">';

            $cat_images = explode(',', $cat_imgs);
            foreach($cat_images as $index => $cat_img)
            {
                $img_data = wp_get_attachment_image_src( $cat_img, 'full' );

                $image_links = isset($cat_img_urls) ? explode(',', $cat_img_urls) : '';

                $image_link = isset($image_links[$index]) ? 'href="' . $image_links[$index] . '"' : '';

                echo '<a ' . $image_link . '><img src="' . esc_url( $img_data[0] ) . '" alt="' . esc_attr__( 'image-cat', 'nb-elements' ) . '" /><div class="buttons"></div></a>';
            }

            echo '</div>';
        }
        

        $tab_args = array(
            'post_type' => 'product',
            'post_status' => 'publish',
            'product_cat' => $product_cat,
            'posts_per_page' => $limit
        );

        $this->nb_filter_product_by_product_type( $tab_args, $product_type );

        
        $tab_product = new WP_Query( $tab_args );


        if ( $tab_product->have_posts() ) :
            echo '<div class="products row grid-type">';
                while ( $tab_product->have_posts() ) : $tab_product->the_post();

                    wc_get_template_part( 'content', 'product' );

                endwhile;
            echo '</div>';
        endif;
        wp_reset_postdata();
        die();
        
    }

    function yith_compare_buttons() {
       global $product;

                    $button_text = get_option( 'yith_woocompare_button_text', __( 'Compare', 'nb-elements' ) );
                    do_action ( 'wpml_register_single_string', 'Plugins', 'plugin_yit_compare_button_text', $button_text );
                    $button_text = apply_filters( 'wpml_translate_single_string', $button_text, 'Plugins', 'plugin_yit_compare_button_text' );
                    
       printf( '<a href="%s" class="%s" data-product_id="%d" rel="nofollow">%s</a>', get_permalink($product->get_id()), 'compare button bt-4', $product->get_id(), $button_text );

    }

    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {

        for ( $i = $pos; $i < count( $array ); $i ++ ) {

            if ( $array[ $i ]->category_parent == $parent_id ) {
                $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                $value = $array[ $i ]->slug;
                $dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
                $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
            }
        }
    }

    protected function nb_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;
            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'top_rated':
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }
    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Product_Tabs(); 
}
