<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
  exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
  class NB_Element_Product_Online_Design extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */
    
    // Element Init
    function __construct() {
      add_action( 'init', array( $this, 'map' ), 12 );
      add_shortcode( 'netbase_product_online_design', array( $this, 'shortcode_product_online_design' ) );
    }


    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
      // Stop all if VC is not enabled
      if ( !defined( 'WPB_VC_VERSION' ) ) {
        return;
      }
      
      vc_map(array(
        'name' => esc_html__('Product Online Design', 'nb-elements'),
        'base' => 'netbase_product_online_design',
        'category' => esc_html__('PrintCart', 'nb-elements'),
        'description' => esc_html__('Display product online with button design.', 'nb-elements'),
        'icon' => 'icon-wpb-wp',
        'params' => array(
          array(
            "type" => "dropdown",
            "holder" => "",
            "class" => "printshop",
            "heading" => __("Select display template style", "nb-elements"),
            "param_name" => "accordionstyle",
            "value" => array(__("Default (no paddings)", "nb-elements") => 'nb-elements', __("Gap between the columns", "nb-elements") => "gap_col"),
            "description" => __("", "nb-elements"),
            'group' => __('Content Options', 'nb-elements'),
          ),

          array(
            'param_name'  => 'num_col_pro',
            'heading'     => esc_html__( 'Number of columns displayed', 'nb-elements' ),
            'type'        => 'dropdown',
            'value'       => array(
              __( '1 column', 'nb-elements' )  => '1',
              __( '2 columns', 'nb-elements' ) => '2',
              __( '3 columns', 'nb-elements' ) => '3',
              __( '4 columns', 'nb-elements' ) => '4',
              __( '5 columns', 'nb-elements' ) => '5',
              __( '6 columns', 'nb-elements' ) => '6',
            ),
            'std' => '5',
            "dependency" => Array('element' => "accordionstyle", 'value' => array('default')),
            'group' => __('Content Options', 'nb-elements'),
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Limit number product', 'nb-elements'),
            'param_name' => 'num_pro_design',
            'value' => '10',
          ),

          array(
            'param_name'  => 'fontsize_button',
            'heading'     => esc_html__( 'Font size button', 'nb-elements' ),
            'type'        => 'dropdown',
            'value'       => array(
              __( '14px', 'nb-elements' )  => '14',
              __( '16px', 'nb-elements' ) => '16',
            ),
            'std'         => '14',
          ),

          array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __( "Background color button", "nb-elements" ),
            "param_name" => "color_button_design",
            "value" => '#4285f4',
          ),

          array(
            "type" => "colorpicker",
            "class" => "",
            "heading" => __( "Color text button", "nb-elements" ),
            "param_name" => "color_text_button_design",
            "value" => '#fff',
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Round button', 'nb-elements'),
            'param_name' => 'round_button_design',
            'value' => '',
            "description" => __( "Border radius button ( Example: 5px )", "nb-elements" ),
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Margin bottom between products', 'nb-elements'),
            'param_name' => 'margin_pro_design',
            'value' => '',
            "description" => __( "Margin bottom ( Example: 15px or 15% )", "nb-elements" ),
          ),

          array(
            'type' => 'checkbox',
            'admin_label' => true,
            'heading' => esc_html__('Show button BROWSE DESIGNS', 'nb-elements'),
            'param_name' => 'enable_button',
            'std' => false,
          ),

          array(
            "type" => "textarea",
            "heading" => __( "Description", 'nb-elements' ),
            "param_name" => "description_online_design",
            "value" => __( "", 'nb-elements' ),
            "description" => __( "Enter description.", 'nb-elements'),
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Margin top from product to description', 'nb-elements'),
            'param_name' => 'margin_top_pro_design',
            'value' => '',
            "description" => __( "Margin top ( Example: 15px or 15% )", "nb-elements" ),
          ),

          array(
            "type" => "dropdown",
            "heading" => __("Order by", "nb-elements"),
            "param_name" => "direction",
            "value" => array(__("Ascendant", "nb-elements") => "ASC" ,__("Descendant", "nb-elements") => "DESC"), 
            "description" => __("", "nb-elements")
          ),

          array(
            'param_name'  => 'columns',
            'heading'     => esc_html__( 'Number of columns displayed', 'nb-elements' ),
            'type'        => 'dropdown',
            'group' => __('Content Options', 'nb-elements'),
            'value'       => array(
              __( '1 column', 'nb-elements' )  => '1',
              __( '2 columns', 'nb-elements' ) => '2',
              __( '3 columns', 'nb-elements' ) => '3',
              __( '4 columns', 'nb-elements' ) => '4',
              __( '6 columns', 'nb-elements' ) => '6',
            ),
            'std'         => '4',
            'edit_field_class' => 'vc_col-sm-6 vc_column',
            "dependency" => Array('element' => "accordionstyle", 'value' => array('gap_col')),
          ),

          array(
            'type' => 'checkbox',
            'admin_label' => true,
            'heading' => esc_html__('Enable Title', 'nb-elements'),
            'param_name' => 'enable_title',
            'std' => true,
            "value" => array('Show title product' => true )
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Font size title product', 'nb-elements'),
            'param_name' => 'font_size_title_pro_design',
            'value' => '18px',
          ),

          array(
            "type" => "dropdown",
            "holder" => "",
            "class" => "printshop",
            "heading" => __("Select size thumbnail product", "nb-elements"),
            "param_name" => "size_thumb_product",
            "value" => array(__("Default (Medium)", "nb-elements") => "medium", __("Custom", "nb-elements") => "custom"),
            "description" => __("", "nb-elements"),
            'group' => __('Thumbnail Options', 'nb-elements'),
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Width thumbnail product', 'nb-elements'),
            'param_name' => 'width_thumb_pro',
            'value' => '',
            "dependency" => Array('element' => "size_thumb_product", 'value' => array('custom')),
            'group' => __('Thumbnail Options', 'nb-elements'),
            'edit_field_class' => 'vc_col-sm-6 vc_column',
          ),

          array(
            'type' => 'textfield',
            'admin_label' => true,
            'heading' => esc_html__('Height thumbnail product', 'nb-elements'),
            'param_name' => 'height_thumb_pro',
            'value' => '',
            "dependency" => Array('element' => "size_thumb_product", 'value' => array('custom')),
            'group' => __('Thumbnail Options', 'nb-elements'),
            'edit_field_class' => 'vc_col-sm-6 vc_column',
          ),

        )
));
}

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_product_online_design($atts, $content = null)
    {
     global $post;

     $html = $attr_parent = '';
     extract(
      shortcode_atts(
        array(
          'num_col_pro' => 5,
          'num_pro_design' => 10,
          'margin_pro_design' => '0px',
          'round_button_design' => '0px',
          'margin_top_pro_design' => '0px',
          'color_button_design' => '#4285f4',
          'color_text_button_design' => '#fff',
          'accordionstyle' => 'default',
          'enable_button' => false,
          'enable_title' => true,
          'description_online_design' => '',
          'columns' => 4,
          'fontsize_button' => 14,
          'font_size_title_pro_design' => '18px',
          'size_thumb_product' => 'medium',
          'width_thumb_pro' => '',
          'height_thumb_pro' => '',
          'direction' => 'ASC',
        ),
        $atts
      )
    );

     $class_columns ='';
     switch ($columns) {
      case '1':
      $class_columns= 'col-md-12';
      break;
      case '2':
      $class_columns= 'col-md-6';
      break;
      case '3':
      $class_columns= 'col-md-4';
      break;
      case '4':
      $class_columns= 'col-md-3';
      break;
      case '6':
      $class_columns= 'col-md-2';
      break;
      default:
      $class_columns ='col-md-4';
    }

    $args = array(
      'posts_per_page'    => $num_pro_design,
      'post_type' => 'product',
      'order' => $direction,
      'meta_query' => array(
        array(
          'key'       => '_nbdesigner_enable',
          'value'     => true
        ),
      ),
    );

          // The Query
    $the_query = new WP_Query( $args );
    $html.= '<div class="product-online-desginer">';
    $html.= '<div class="row">';
    if($enable_button) {
      $html.='<div class="col-xs-12 col-md-12 col-lg-6 des">'.$description_online_design.'</div>';
      $html.='<div class="col-xs-12 col-md-12 col-lg-6 btn-browse">';
      $html.='<h5><a href="'.getUrlPageNBD('gallery').'">Browse designers</a></h5>';
    } else {
      $html.='<div class="col-xs-12 col-md-12">';
    }
    $html.='</div>';
    $html.='</div>';
    $html.= '<ul class="'.($accordionstyle!='default'?'rig':'default').'" style="margin-top: '.$margin_top_pro_design.';">';
    if ( $the_query->have_posts() ) {
      while ( $the_query->have_posts() ) {
        $the_query->the_post();
        if ( has_post_thumbnail() ) {
          if($accordionstyle=='default') {
            $html.= '<li class="col-nb-'.$num_col_pro.'" style="margin-bottom: '.$margin_pro_design.';">';
          } else {
            $html.='<li class="'.$class_columns.'" style="margin-bottom: '.$margin_pro_design.';">';
          }
          $html.= '<div class="pr">';
          $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'printcart-masonry' );
          if ( ! empty( $large_image_url[0] ) ) {
            // $html.= '<img src="'. esc_url($large_image_url[0]) .'" alt="'. esc_attr($post->post_title) .'"/>';
            if($size_thumb_product!='medium' && is_numeric($width_thumb_pro) && is_numeric($height_thumb_pro)) {
              $size = array($width_thumb_pro,$height_thumb_pro);
            } else {
              $size = 'printcart-masonry';
            }
            $html.= wp_get_attachment_image(get_post_thumbnail_id( $post->ID ), $size, false, ['alt'=>esc_attr($post->post_title)]);
          }
          $url = '';
          if ( is_plugin_active('web-to-print-online-designer/nbdesigner.php') ) {
            $url =  add_query_arg(array(
              'product_id'    =>  $post->ID
            ),  getUrlPageNBD('create'));
          };
          $html.= '<div class="product-online-desginer-detail">';
          $html.= '<div class="links-wrap">';
          $html.= '<a href="'.$url.'">';
          if($enable_title) {
            $html.= '<h4 style="font-size: '.$font_size_title_pro_design.';">'.$post->post_title.'</h4>';
          }
          $html.= '<h6 style="background-color: '.$color_button_design.'; color: '.$color_text_button_design.'; border-radius: '.$round_button_design.'; -webkit-border-radius: '.$round_button_design.'; font-size: '.$fontsize_button.'px;">' . esc_html__('Design Now', 'nb-elements') . '</h6>';
          $html.= '</a>';
          $html.= '</div>';
          $html.= '</div>';
          $html.= '</div>';
          $html.= '</li>';
        }
      }
      wp_reset_postdata();
    }
    $html.= '</ul>';
    $html.= '</div>';

    return apply_filters('netbase_shortcode_product_online_design', force_balance_tags($html));
  }

}
new NB_Element_Product_Online_Design(); 
}