<?php
/*
Plugin Name: Netbase Elements
Plugin URI: http://netbaseteam.com/
Description: Prodive all visual composer elements and widgets.
Version: 1.2.3
Author: NBTeam
Author URI: http://themeforest.net/user/netbaseteam
*/

define('NB_ELEMENTS_PATH', plugin_dir_path(__FILE__));
define('NB_ELEMENTS_NAME', plugin_basename(__FILE__));
define('NB_ELEMENTS_URL', plugin_dir_url( __FILE__ ));
define('PC_AJAX_SEARCH_PATH', NB_ELEMENTS_PATH . 'modules/ajax-search');
define('PC_AJAX_SEARCH_URL', NB_ELEMENTS_URL . 'modules/ajax-search');

function get_excerpt($content, $num, $short){        

    // filter_content
    $content = trim(strip_tags($content));
    $content = preg_replace('|[[\\/\\!]*?[^\\[\\]]*?]|si', '', $content);
    $content = preg_replace("/[\r\n]*/","",$content);
    mb_internal_encoding('utf-8');
    $content = str_replace('  ', '', $content);

    $limit = $num - 1 ;
    $str_tmp = '';
    $arrstr = explode(" ", $content);
    if ( count($arrstr) <= $num ) {
        if (strlen($content)>(9*$num))
            return substr($content,0,(9*$num)).$short;
        else
            return $content; 
    }
    if (!empty($arrstr))
    {
        for ( $j=0; $j< count($arrstr) ; $j++)
        {
            $str_tmp .= " " . $arrstr[$j];
            if ($j == $limit)
            {  break; }
        }
    }

    if (strlen($str_tmp)>9*$num)
    {
        return substr($str_tmp,0,9*$num).$short;
    }

    return trim($str_tmp.$short);
}

require_once(NB_ELEMENTS_PATH . 'modules/ajax-search/ajax-search.php');

class Netbase_Elements
{
    public static function init()
    {
        self::include_function_plugins();
        self::load_widget();

        // Localize our plugin
        add_action( 'init', array( __CLASS__, 'localization_setup' ) );

        add_action('vc_before_init', array(__CLASS__, 'load_vc_elements'));
        add_action('wp_enqueue_scripts', array(__CLASS__, 'nb_elements_enqueue_scripts'));
        add_filter('vc_google_fonts_get_fonts_filter', array(__CLASS__, 'nb_helper_vc_fonts'));

    }

    /**
     * Initialize plugin for localization
     *
     * @uses load_plugin_textdomain()
     */
    public static function localization_setup() {
        load_plugin_textdomain( 'nb-elements', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
    }

    public static function nb_elements_enqueue_scripts() {
        wp_enqueue_style( 'nb_elements', NB_ELEMENTS_URL . 'assets/css/main.css', array(), '20180324' );
        if(is_rtl()){
            wp_enqueue_style( 'nb_elements_rtl', NB_ELEMENTS_URL . 'assets/css/rtl.css', array(), '20180324' );
        }
        wp_enqueue_script( 'nb_elements', NB_ELEMENTS_URL . 'assets/js/main.js', array( 'jquery' ), '20180324', true );

        wp_enqueue_style( 'swiper', NB_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.css', array(), '4.2.0');
        wp_enqueue_script( 'swiper',  NB_ELEMENTS_URL . 'assets/vendors/swiper/swiper.min.js', array('jquery'), '4.2.0', true);

        wp_enqueue_style( 'magnific-popup', NB_ELEMENTS_URL . 'assets/vendors/magnific-popup/magnific-popup.css' );
        wp_enqueue_script( 'magnific-popup', NB_ELEMENTS_URL . 'assets/vendors/magnific-popup/jquery-magnific-popup.min.js', array(), '', false );
    }

    public static function nb_helper_vc_fonts( $fonts_list ) {
        $poppins->font_family = 'Poppins';
        $poppins->font_types = '300 light regular:300:normal,400 regular:400:normal,500 bold regular:500:normal,600 bold regular:600:normal,700 bold regular:700:normal';
        $poppins->font_styles = 'regular';
        $poppins->font_family_description = esc_html_e( 'Select font family', 'nb-elements' );
        $poppins->font_style_description = esc_html_e( 'Select font styling', 'nb-elements' );
        $fonts_list[] = $poppins;

        return $fonts_list;
    }

    public static function include_function_plugins() {
        if ( ! function_exists( 'is_plugin_active' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
    }

    public static function load_vc_elements() {
        require_once( NB_ELEMENTS_PATH . 'vc_elements/testimonials.php' );  
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-instagram.php' );  
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-wc-hotdeals.php' );  
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-video.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/brands-list.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-img-banner.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/heading.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/blog.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-step.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-element-step.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/product-online-design.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-icon-services.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/template-online-design.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/product-tabs.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/social-media.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-wc-list-products.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/product-sliders.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-intro-image.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-our-services.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/our-team.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-online-desginer.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-contact-info.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-map.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-get-to.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-feature-posts.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/vc-leadership.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/timeline-simple.php' );
        require_once( NB_ELEMENTS_PATH . 'vc_elements/image-slider.php' );
    }

    public static function load_widget() {    
        require_once( NB_ELEMENTS_PATH . 'widgets/contact-info.php' );
        require_once( NB_ELEMENTS_PATH . 'widgets/instagram-widget.php' );
        require_once( NB_ELEMENTS_PATH . 'widgets/recent-posts.widget.php' );
        require_once( NB_ELEMENTS_PATH . 'widgets/search.widget.php' );
        require_once( NB_ELEMENTS_PATH . 'widgets/social-links.php' );
        require_once( NB_ELEMENTS_PATH . 'widgets/title.widget.php' );
        if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
            require_once( NB_ELEMENTS_PATH . 'widgets/wc-price-slider.php' );
            require_once( NB_ELEMENTS_PATH . 'widgets/wc-product-categories.php' );
        }        
    }
}
Netbase_Elements::init();
