jQuery( function( $ ) {


	var pc_ajax_search = {

		/**
		 * Initialize variations actions
		 */
		init: function() {
        	$(window).load(function(){
				//setup before functions
				var typingTimer;                //timer identifier
				var doneTypingInterval = 1000;  //time in ms, 5 second for example
				var $input = $('.input-searchbox');

				//on keyup, start the countdown
				$input.on('keyup', function () {
					
					if( !$input.val() ){
						$('#searchbox_autocomplete').hide();
					}else{
						clearTimeout(typingTimer);
						typingTimer = setTimeout(doneTyping, doneTypingInterval);
					}
				});

				//on keydown, clear the countdown 
				$input.on('keydown', function () {
					if( !$input.val() ){
						$('#searchbox_autocomplete').hide();
					}else{
						clearTimeout(typingTimer);
					}
				});

				//user is "finished typing," do something
				function doneTyping () {
					pc_ajax_search.search_now(typingTimer);
				}
        	});
			
			$(document).mouseup(function(e) 
			{
				if($(".nbt-rs-lists").length){
				    var container = $("#nbt-ajax-search");
					var rs = $(".nbt-rs-lists");

				    if ( ! container.is(e.target) && container.has(e.target).length === 0 ) 
				    {
						rs.hide();
						$('.nbt-input-search').val('');
				    }
				}
			});
		},
		search_now: function(typingTimer){
			$('.btn-searchbox').html('<i class="pt-icon-spinner animate-spin"></i>');
			$('#searchbox_autocomplete').show().html('');


			$.ajax({
				url: nbt_solutions.ajax_url,
				data: {
					action:     'nbt_search_now',
					search: $('.input-searchbox').val(),
					cat: $('.searchbox-cat').val()
				},
				type: 'POST',
				datatype: 'json',
				success: function( response ) {
					var rs = JSON.parse(response);
					$('.btn-searchbox').html('<i class="pt-icon-search"></i>');
					if(rs.complete != undefined) {
						$('#searchbox_autocomplete').append(rs.result);
						$(".nbt-rs-lists").mCustomScrollbar({
						    theme:"dark"
						});
					}
					
					clearTimeout(typingTimer);

				}
			});
		}
	}


	pc_ajax_search.init();
	
});


