<?php
/**
 * wpnetbase functions and definitions
 *
 * @package Netbase
 */

/**
 * Define theme constants
 */
function printshop_boxed10_enqueue_styles() {
	
	wp_enqueue_style( 'wpnetbase-child-style', get_stylesheet_directory_uri() . '/style.css' );
 	if( is_front_page () ){
 		wp_enqueue_script( 'printshop-gift-customize', get_stylesheet_directory_uri() . '/js/customize.js', array(), '', true );
 	}
 
}
add_action( 'wp_enqueue_scripts', 'printshop_boxed10_enqueue_styles',99 );

function printshop_menu_shortcode($atts, $content = null) {
	extract(shortcode_atts(array( 'name' => null, ), $atts));
	return wp_nav_menu( array( 'menu' => $name, 'echo' => false ) );
}
add_shortcode('menu', 'printshop_menu_shortcode');
function megamenu_add_theme_print_boxed($themes) {
    $themes["print_boxed"] = array(
        'title' => 'Print Boxed',
        'container_background_from' => 'rgba(34, 34, 34, 0)',
        'container_background_to' => 'rgba(0, 0, 0, 0)',
        'menu_item_background_hover_from' => 'rgba(0, 0, 0, 0)',
        'menu_item_background_hover_to' => 'rgba(0, 0, 0, 0)',
        'menu_item_link_padding_left' => '20px',
        'menu_item_link_padding_right' => '20px',
        'menu_item_highlight_current' => 'off',
        'panel_background_from' => 'rgb(255, 255, 255)',
        'panel_background_to' => 'rgb(255, 255, 255)',
        'panel_header_border_color' => '#555',
        'panel_font_size' => '14px',
        'panel_font_color' => '#666',
        'panel_font_family' => 'inherit',
        'panel_second_level_font_color' => 'rgb(253, 91, 78)',
        'panel_second_level_font_color_hover' => 'rgb(253, 91, 78)',
        'panel_second_level_text_transform' => 'capitalize',
        'panel_second_level_font' => 'inherit',
        'panel_second_level_font_size' => '16px',
        'panel_second_level_font_weight' => 'normal',
        'panel_second_level_font_weight_hover' => 'normal',
        'panel_second_level_text_decoration' => 'none',
        'panel_second_level_text_decoration_hover' => 'none',
        'panel_second_level_padding_bottom' => '10px',
        'panel_second_level_margin_bottom' => '10px',
        'panel_second_level_border_color' => 'rgb(204, 204, 204)',
        'panel_second_level_border_bottom' => '1px',
        'panel_third_level_font_color' => '#666',
        'panel_third_level_font_color_hover' => 'rgb(253, 91, 78)',
        'panel_third_level_font' => 'inherit',
        'panel_third_level_font_size' => '14px',
        'flyout_menu_background_from' => 'rgb(255, 255, 255)',
        'flyout_menu_background_to' => 'rgb(255, 255, 255)',
        'flyout_link_padding_left' => '8px',
        'flyout_link_padding_right' => '8px',
        'flyout_background_from' => 'rgb(255, 255, 255)',
        'flyout_background_to' => 'rgb(255, 255, 255)',
        'flyout_background_hover_from' => 'rgb(255, 255, 255)',
        'flyout_background_hover_to' => 'rgb(255, 255, 255)',
        'flyout_link_size' => '14px',
        'flyout_link_color' => '#666',
        'flyout_link_color_hover' => 'rgb(253, 91, 78)',
        'flyout_link_family' => 'inherit',
        'responsive_breakpoint' => '768px',
        'resets' => 'on',
        'toggle_background_from' => '#222',
        'toggle_background_to' => '#222',
        'toggle_font_color' => '#ffffff',
        'mobile_background_from' => 'rgba(34, 34, 34, 0)',
        'mobile_background_to' => 'rgba(0, 0, 0, 0)',
        'mobile_menu_item_link_font_size' => '14px',
        'mobile_menu_item_link_color' => '#ffffff',
        'mobile_menu_item_link_text_align' => 'left',
        'mobile_menu_item_link_color_hover' => '#ffffff',
        'mobile_menu_item_background_hover_from' => 'rgba(0, 0, 0, 0)',
        'mobile_menu_item_background_hover_to' => 'rgba(0, 0, 0, 0)',
        'custom_css' => '#{$wrap} #{$menu} {
    /** Custom styles should be added below this line **/
}
#{$wrap} {
    clear: both;
}',
    );
    return $themes;
}
add_filter("megamenu_themes", "megamenu_add_theme_print_boxed");

function megamenu_add_theme_vertical_menu($themes) {
    $themes["vertical_menu"] = array(
        'title' => 'Vertical Menu',
        'container_background_from' => 'rgba(34, 34, 34, 0)',
        'container_background_to' => 'rgba(0, 0, 0, 0)',
        'menu_item_background_hover_from' => 'rgba(0, 0, 0, 0)',
        'menu_item_background_hover_to' => 'rgba(0, 0, 0, 0)',
        'menu_item_link_padding_left' => '8px',
        'menu_item_link_padding_right' => '8px',
        'menu_item_highlight_current' => 'off',
        'panel_background_from' => 'rgb(255, 255, 255)',
        'panel_background_to' => 'rgb(255, 255, 255)',
        'panel_header_border_color' => '#555',
        'panel_font_size' => '14px',
        'panel_font_color' => '#666',
        'panel_font_family' => 'inherit',
        'panel_second_level_font_color' => '#555',
        'panel_second_level_font_color_hover' => '#555',
        'panel_second_level_text_transform' => 'uppercase',
        'panel_second_level_font' => 'inherit',
        'panel_second_level_font_size' => '16px',
        'panel_second_level_font_weight' => 'bold',
        'panel_second_level_font_weight_hover' => 'bold',
        'panel_second_level_text_decoration' => 'none',
        'panel_second_level_text_decoration_hover' => 'none',
        'panel_second_level_border_color' => '#555',
        'panel_third_level_font_color' => '#666',
        'panel_third_level_font_color_hover' => '#666',
        'panel_third_level_font' => 'inherit',
        'panel_third_level_font_size' => '14px',
        'flyout_menu_background_from' => 'rgb(255, 255, 255)',
        'flyout_menu_background_to' => 'rgb(255, 255, 255)',
        'flyout_link_padding_left' => '8px',
        'flyout_link_padding_right' => '8px',
        'flyout_background_from' => 'rgb(255, 255, 255)',
        'flyout_background_to' => 'rgb(255, 255, 255)',
        'flyout_background_hover_from' => 'rgb(255, 255, 255)',
        'flyout_background_hover_to' => 'rgb(255, 255, 255)',
        'flyout_link_size' => '14px',
        'flyout_link_color' => '#666',
        'flyout_link_color_hover' => '#666',
        'flyout_link_family' => 'inherit',
        'responsive_breakpoint' => '768px',
        'resets' => 'on',
        'toggle_background_from' => '#222',
        'toggle_background_to' => '#222',
        'toggle_font_color' => '#ffffff',
        'mobile_background_from' => 'rgba(34, 34, 34, 0)',
        'mobile_background_to' => 'rgba(0, 0, 0, 0)',
        'mobile_menu_item_link_font_size' => '14px',
        'mobile_menu_item_link_color' => '#ffffff',
        'mobile_menu_item_link_text_align' => 'left',
        'mobile_menu_item_link_color_hover' => '#ffffff',
        'mobile_menu_item_background_hover_from' => 'rgba(0, 0, 0, 0)',
        'mobile_menu_item_background_hover_to' => 'rgba(0, 0, 0, 0)',
        'custom_css' => '#{$wrap} #{$menu} {
    /** Custom styles should be added below this line **/
}
#{$wrap} {
    clear: both;
}',
    );
    return $themes;
}
add_filter("megamenu_themes", "megamenu_add_theme_vertical_menu");







