<?php

if ( !class_exists('Netbase_User_Social') ) {
    class Netbase_User_Social
    {

        public function __construct()
        {
            add_action( 'show_user_profile', array( $this, 'user_profile_social' ) );
            add_action( 'edit_user_profile', array( $this, 'user_profile_social' ) );  

            add_action( 'personal_options_update', array( $this, 'process_user_social_update' ) );
            add_action( 'edit_user_profile_update', array( $this, 'process_user_social_update' ) );  
        }

        public function user_profile_social($user) {
            $user_info = array();
            $user_info['facebook_social'] = get_the_author_meta( 'facebook_social', $user->ID );
            $user_info['google_social'] = get_the_author_meta( 'google_social', $user->ID );
            $user_info['twitter_social'] = get_the_author_meta( 'twitter_social', $user->ID );
            $user_info['linkedin_social'] = get_the_author_meta( 'linkedin_social', $user->ID );
            $user_info['pinterest_social'] = get_the_author_meta( 'pinterest_social', $user->ID );
    
            $html = '<div class="user-social-settings nbd-user-settings">
                <h2 id="user-social-setting">'.esc_html('User Social','aidoo').'</h2>    
                <div class="nbd-section">
                    <label for="facebook_social">'.esc_html('Facebook','aidoo').'</label>
                    <input class="regular-text facebook_social" id="test_social" type="text" name="facebook_social"
                        value="'.esc_attr( $user_info['facebook_social'] ).'"/>
                </div>   
                <div class="nbd-section">
                    <label for="google_social">'.esc_html('Google Plus','aidoo').'</label>
                    <input class="regular-text google_social" type="text" name="google_social"
                        value="'.esc_attr( $user_info['google_social'] ).'"/>
                </div> 
                <div class="nbd-section">
                    <label for="twitter_social">'.esc_html('Twitter','aidoo').'</label>
                    <input class="regular-text twitter_social" type="text" name="twitter_social"
                        value="'.esc_attr( $user_info['twitter_social'] ).'"/>
                </div>   
                <div class="nbd-section">
                    <label for="linkedin_social">'.esc_html('Linkedin','aidoo').'</label>
                    <input class="regular-text linkedin_social" type="text" name="linkedin_social"
                        value="'.esc_attr( $user_info['linkedin_social'] ).'"/>
                </div>   
                <div class="nbd-section">
                    <label for="pinterest_social">'.esc_html('Pinterest','aidoo').'</label>
                    <input class="regular-text pinterest_social" type="text" name="pinterest_social"
                        value="'.esc_attr( $user_info['pinterest_social'] ).'"/>
                </div> 
            </div>';
            echo wp_kses($html, 
                array(
                    'div' => array(
                        'class' => array(),
                    ),
                    'h2' => array(
                        'id' => array(),
                    ),
                    'label' => array(
                        'for' => array(),
                    ),
                    'input' => array(
                        'class' => array(),
                        'type' => array(),
                        'name' => array(),
                        'value' => array(),
                    )
                )
            );
        }
    
        public function process_user_social_update( $user_id ) {
            update_user_meta( $user_id, 'facebook_social', $this->filter_input_post( 'facebook_social' ) );
            update_user_meta( $user_id, 'google_social', $this->filter_input_post( 'google_social' ) );
            update_user_meta( $user_id, 'twitter_social', $this->filter_input_post( 'twitter_social' ) );
            update_user_meta( $user_id, 'linkedin_social', $this->filter_input_post( 'linkedin_social' ) );
            update_user_meta( $user_id, 'pinterest_social', $this->filter_input_post( 'pinterest_social' ) );
        }  

        private function filter_input_post( $var_name ) {
            $val = filter_input( INPUT_POST, $var_name );
            if ( $val ) {
                return sanitize_text_field( $val );
            }
            return '';
        } 
    }
}

new Netbase_User_Social();