<?php
/**
 * Plugin Name: NB Multistore Extend
 * Plugin URI: https://cmsmart.net
 * Description: Plugin that contain a lot of feature in Printshop Solution Package.
 * Version: 1.1.0
 * Author: Netbase-Team
 * Author URI: https://woocommerce.com
 * Text Domain: nb-solution
 * Domain Path: /languages
 *
 * @package Solutions
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

define( 'NB_MULTISTORE_EXTEND_PATH', plugin_dir_path( __FILE__ ) );
define( 'NB_MULTISTORE_EXTEND_URL', plugin_dir_url( __FILE__ ) );
define( 'NB_SOLUTION_BASENAME', plugin_basename( __FILE__ ) );
define( 'NB_SOLUTION_DEV', true );

final class Multistore_Extend {
    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;

    public static $enable_modules;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NB_Solutions
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }
	
    /**
     * NB_Solutions constructor.
     *
     * @since 0.0.1
     */
    private function __construct() {
        self::$enable_modules = get_option('multistore_extend_settings');
        // Load the core class.
       require_once NB_MULTISTORE_EXTEND_PATH . 'core/core.php';
       require_once NB_MULTISTORE_EXTEND_PATH . 'core/modules.php';
       require_once NB_MULTISTORE_EXTEND_PATH . 'core/metabox.php';
        
		// require_once NB_MULTISTORE_EXTEND_PATH . 'api/api.php';
		// require_once NB_MULTISTORE_EXTEND_PATH . 'dashboard.php';

		// load_plugin_textdomain( 'nb-solution', false, NB_MULTISTORE_EXTEND_PATH . 'languages' );
	}

    public static function log( $data ) {
        if ( defined('WP_DEBUG') && true === WP_DEBUG) {
            if ( is_array( $data ) || is_object( $data ) ) {
                error_log( print_r( $data, true ) );
            } else {
                error_log( $data );
            }
        }
    }
}

/**
* Load plugin for Multistore_Extend
*
* @since 2.5.3
*
* @return void
**/
add_action( 'plugins_loaded', array( 'Multistore_Extend', 'instance' ) );