<?php
class NB_Ajax_Search_Settings {

	protected static $initialized = false;

	public static function initialize() {
		// Do nothing if pluggable functions already initialized.
		if ( self::$initialized ) {
			return;
		}


		// State that initialization completed.
		self::$initialized = true;
    }


    public static function get_settings() {
        global $wpdb;
        // Get all post_types

        $all_post_types = array();  
        foreach ( get_post_types(array('public'   => true))  as $post_type ) {
            $all_post_types[$post_type] = get_post_type_object($post_type)->label;
        }
        
        // Get all taxonomies
        $all_taxonomies = array();
        foreach( get_taxonomies(array('public' => true)) as $taxonomy => $value ) {
            $all_taxonomies[$taxonomy] = get_taxonomy($value)->label;
        }

        // Get all products
        $all_products = array();
        $query_product = $wpdb->get_results("SELECT p.ID, p.post_title FROM {$wpdb->posts} as p WHERE p.post_type = 'product' AND p.post_status = 'publish' ORDER BY p.post_title ASC");
        if( $query_product ) {
            foreach( $query_product as $product ) {
                $all_products[$product->ID] = $product->post_title;
            }
        }

        // Get terms
        $terms = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ) );

        $all_terms = array();
        foreach($terms as $k => $term) {
            $all_terms[$term->term_id] = $term->name;     
        }

        $settings = array(
            'layout' => array(
                'label' => __( 'Layout', 'nbt-solution' ),
                'desc' => __( 'Choose the layout for search form', 'nbt-solution'),
                'type' => 'select',
                'id'   => 'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_layout',
                'default' => 'advanced_search',
                'options' => array(
                    'single_search' => __('Single search', 'nbt-solution'),
                    'advanced_search' => __('Advanced search (with taxonomy)', 'nbt-solution'),
                    
                ),
                'placeholder' => __('Choose a layout'),
                'field_class' => array('abc', 'xyz'),
                'logic' => array(
                    'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_taxonomy',
                    'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_post_type',
                    'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_feature_product',
                    'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_feature_taxonomy'
                )
            ),
            'taxonomy' => array(
                'label' => __( 'Taxonomy', 'nbt-solution' ),
                'desc' => __( 'Choose the taxonomy you want to display', 'nbt-solution'),
                'type' => 'select',
                'id'   => 'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_taxonomy',
                'default' => 'product_cat',
                'options' => $all_taxonomies,
                'placeholder' => __('Available post types'),
                'field_class' => array('abc', 'xyz'),
                'logic' => array(
                    'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_feature_taxonomy'
                ),
                'wrapper_class' => array('show_if_advanced_search'),
            ),
            'post_type' => array(
                'label' => __( 'Search in custom post types', 'nbt-solution' ),
                'desc' => __( 'Choose the post types you want to use', 'nbt-solution'),
                'type' => 'select2',
                'id'   => 'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_post_type',
                'default' => array('product'),
                'options' => $all_post_types,
                'placeholder' => __('Available post types'),
                'field_class' => array('abc', 'xyz'),
                'attribute' => array(
                    'multiple' => 'multiple'
                ),
                'logic' => array(
                    'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_feature_product'
                ),
            ),
            'feature_product' => array(
                'label' => __( 'Feature of product', 'nbt-solution' ),
                'desc' => __( 'Choose the post types you want to use', 'nbt-solution'),
                'type' => 'select2',
                'id'   => 'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_feature_product',
                'default' => array(),
                'options' => $all_products,
                'placeholder' => __('Available product'),
                'field_class' => array('abc', 'xyz'),
                'attribute' => array(
                    'multiple' => 'multiple'
                ),
                'wrapper_class' => array('show_if_advanced_search', 'show_if_product'),
                'wrapper_attribute' => array(
                    'data-field' => 'nb_ajax-search_layout'
                )
            ),
            'feature_taxonomy' => array(
                'label' => __( 'Feature of category', 'nbt-solution' ),
                'desc' => __( 'Choose the post types you want to use', 'nbt-solution'),
                'type' => 'select2',
                'id'   => 'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_feature_taxonomy',
                'default' => array(),
                'options' => $all_terms,
                'placeholder' => __('Available product categories'),
                'field_class' => array('abc', 'xyz'),
                'attribute' => array(
                    'multiple' => 'multiple'
                ),
                'wrapper_class' => array('show_if_advanced_search', 'show_if_product_cat'),
                'wrapper_attribute' => array(
                    'data-field' => 'nb_ajax-search_layout'
                )
            ),
            'banner_ad' => array(
                'label' => __( 'Banner Ads', 'nbt-solution' ),
                'desc' => __( 'Change the invoice logo', 'nbt-solution' ),
                'type' => 'image',
                'id'   => 'nbt_'.NB_Solutions_Ajax_Search::$plugin_id.'_banner_ad',
                'default' => 'http://netbasejsc.com/images/logo.png'
            ),
            'placeholder' => array(
                'label' => __( 'Placeholder of search', 'nbt-solution' ),
                'type' => 'text',
                'id'   => 'nb_'.NB_Solutions_Ajax_Search::$plugin_id.'_color_icon',
                'default' => __('What are you looking for...'),
                'desc' => __('Search icon color', 'nbt-solution')
            )
        );
        return $settings;
    }

}
