<?php
class NB_Solutions_Ajax_Search_Query {
    public $phrase;
    public $terms;

    function __construct($params) {
        $this->phrase = isset($params['phrase']) ? $params['phrase'] : '';
        $this->terms = isset($params['term']) ? $params['term'] : '';
    }

    public function get_results() {
        global $wpdb;

        $term_include = false;

        $query = array();
        $query['select'] = "SELECT * FROM {$wpdb->posts} as p";
        if( ! empty($this->terms) && isset(NB_Solutions_Ajax_Search::$options['layout']) && NB_Solutions_Ajax_Search::$options['layout'] == 'advanced_search' ) {
            $term_include = true;
            $query['left_join'] = "LEFT JOIN {$wpdb->term_relationships} as tr ON (p.ID = tr.object_id)";
        }
        $query['where'] = "WHERE 1=1";

        if( $term_include ) {
            $query['where'] .= " AND (tr.term_taxonomy_id IN (". $this->terms ."))";
        }

        $esc_like = '%' . $wpdb->esc_like( $this->phrase ) . '%';
        $query['where'] .= $wpdb->prepare(" AND (((p.post_title LIKE %s) OR (p.post_excerpt LIKE %s) OR (p.post_content LIKE %s)))", $esc_like, $esc_like, $esc_like);


        if( isset(NB_Solutions_Ajax_Search::$options['post_type']) && ! empty(NB_Solutions_Ajax_Search::$options['post_type']) ) {
            $post_types = NB_Solutions_Ajax_Search::$options['post_type'];
            $query['where'] .= " AND p.post_type IN ( '" . implode( "','", $post_types ) . "')";
        }

        $query['where'] .= " AND p.post_status = 'publish'";
        $query['group_by'] = "GROUP BY p.ID";
        $query['orderby'] =  $wpdb->prepare("ORDER BY p.post_title LIKE %s DESC, p.post_date DESC", $esc_like);

        $sql = implode(' ', $query);

        return $wpdb->get_results($sql);
    }
}