<?php
class NB_Solutions_Ajax_Search_Frontend{
	public $data = array();

	protected $args;
	
	function __construct() {
		add_shortcode( 'nb_search', array($this, 'shortcode_nb_search'), 10, 1 );
		add_filter( 'nb_multistore_extend_localize', array($this, 'search_localize'), 10, 1 );
		add_action('wp_enqueue_scripts', array($this, 'wp_enqueue_scripts'));
		add_action('wp_footer', array($this, 'template_feature'));
	}

	public function template_feature() {
		?>
		<script id="tpl-nb-search-feature" type="text/template">
		<?php
		$html_category = $html_product = '';
		if( isset(NB_Solutions_Ajax_Search::$options['feature_taxonomy']) && ! empty(NB_Solutions_Ajax_Search::$options['feature_taxonomy']) ) {
			$html_category .= '<li class="nb-search-label nb-search-label-category">'. __('Feature Category') .'</li>';
			foreach( NB_Solutions_Ajax_Search::$options['feature_taxonomy'] as $k => $feature_term ) {
	
				$term = get_term_by('id', (int)$feature_term, NB_Solutions_Ajax_Search::$options['taxonomy']);

				$html_category .= '<li class="nb-search-history">';
				$html_category .= '<a href="'. get_term_link($term) .'" title="'. $term->name .'">'. $term->name .'</a>';
				$html_category .= '</li>';
			}
		}

		if( isset(NB_Solutions_Ajax_Search::$options['feature_product']) && ! empty(NB_Solutions_Ajax_Search::$options['feature_product']) ) {
			$html_product .= '<li class="nb-search-label nb-search-label-product">'. __('Feature Product') .'</li>';
			foreach( NB_Solutions_Ajax_Search::$options['feature_product'] as $k => $feature_product) {
				$feat_p = get_post($feature_product);

				$featured_image = wp_get_attachment_image_src( get_post_thumbnail_id($feat_p->ID));

				$html_product .= '<li class="nb-search-history"><a href="'. get_permalink($feat_p->ID) .'" title="'. $feat_p->post_title. '">' . $feat_p->post_title .'</a></li>';

			}
		}

		if( ! empty($html_category) || ! empty($html_product) ) {
			$banner_ad = wp_get_attachment_image_src( NB_Solutions_Ajax_Search::$options['banner_ad'], 'full' );
			$html = '';

			if( $banner_ad[0] ) {
				$html .= '<li class="nb-search-banner-ad"><img src="'. $banner_ad[0] .'" /></li>';
			}
			$html .= $html_category . $html_product;

			echo $html;
		}
		?>
		</script>
		<?php
	}

	public function search_localize( $array ) {
		$array['ajax_search'] = array(
			'input_element'		=> apply_filters('nb_ajax_search_input_element', '#s'),
			'button_element' 	=> apply_filters('nb_ajax_search_button_element', '#searchsubmit'),
			'type' => isset(NB_Solutions_Ajax_Search::$options['layout']) ? NB_Solutions_Ajax_Search::$options['layout'] : '',
			'label' => array(
				'clear' => __('Clear', 'nb-solution'),
				'history' => __('Search history', 'nb-solution')
			)
		);

		if( ! empty(NB_Solutions_Ajax_Search::$options['banner_ad']) ) {
			$banner_ad = wp_get_attachment_image_src( NB_Solutions_Ajax_Search::$options['banner_ad'], 'full' );

			if( $banner_ad[0] ) {
				$array['ajax_search']['banner_ad'] = $banner_ad[0];
			}
		}

		return $array;
	}

	public function shortcode_nb_search( $atts ) {
		$atts = shortcode_atts( array(
			'layout' => 'popup',
		), $atts, 'nbt_search' );

		$this->data = get_option( NB_Solutions_Ajax_Search::$plugin_id .'_settings' );

		if( empty($this->data) ) {
			$this->data = NB_Multistore_Modules::get_setting('ajax-search');
		}

		


		$type_search = isset($this->data['layout']) ? $this->data['layout'] : 'single-search';

		$file = NB_AJAX_SEARCH_PATH . 'tpl/' . str_replace('_', '-', $type_search) .'.php';

		if( file_exists($file) ) {
			$terms = get_terms( array(
				'taxonomy' => $this->data['taxonomy'],
				'hide_empty' => false,
			) );


			ob_start();
			$this->showCategories($terms);
			$dropdown_categories = ob_get_clean();

			include $file;
		}
	}


	public function showCategories($categories, $parent_id = 0, $char = '')
	{

		foreach ($categories as $key => $term)
		{
			// Nếu là chuyên mục con thì hiển thị
			if ($term->parent == $parent_id)
			{
				echo sprintf('<option value="%s">%s</option>', $term->term_id, $char . $term->name);
				
				// Xóa chuyên mục đã lặp
				unset($categories[$key]);
				
				// Tiếp tục đệ quy để tìm chuyên mục con của chuyên mục đang lặp
				$this->showCategories($categories, $term->term_id, $char.'|---');
			}
		}
	}

	public function nbt_search_now(){
		global $wpdb, $post;
		$json = array();
		$search = $_REQUEST['search'];

		if( $search ){
			$results = $wpdb->get_results($wpdb->prepare("SELECT * FROM $wpdb->posts WHERE post_status = 'publish' AND post_type = 'product' AND (post_title LIKE %s OR post_content LIKE %s OR post_excerpt LIKE %s)", '%'.$wpdb->esc_like($search).'%', '%'.$wpdb->esc_like($search).'%', '%'.$wpdb->esc_like($search).'%'), OBJECT );
			if( $results ){
				$json['result'] = '';
				foreach ($results as $key => $post) {
					$product = wc_get_product($post->ID);
					ob_start();
					?>
					<div class="nas-items">
						<div class="nas-item-thumb">
							<a href="<?php echo get_permalink($post->ID );?>" class="nas-item-link" title="<?php echo $post->post_title;?>">
							<?php echo $product->get_image( array( 50, 50 ) );?>
							</a>
						</div>
						<div class="nas-item-title">
							<h3 class="nas-item-title-heading"><a href="<?php echo get_permalink($post->ID );?>" title="<?php echo $post->post_title;?>"><?php echo $post->post_title;?></a></h3>
							<?php
								if ( 'no' === get_option( 'woocommerce_enable_review_rating' ) ) {
									return;
								}

								$rating_count = $product->get_rating_count();
								$review_count = $product->get_review_count();
								$average      = $product->get_average_rating();

								if ( $rating_count > 0 ) : ?>
									<div class="woocommerce-product-rating">
										<?php echo wc_get_rating_html( $average, $rating_count ); ?>
									</div>
								<?php else: ?>
									<div class="woocommerce-product-rating">
										<div class="star-rating" title="<?php _e('Rated 0.00 out of 5', 'nbt-solution');?>"><span style="width:0"><strong class="rating">0.00</strong> <?php _e('out of', 'nbt-solution');?> 5</span></div>
									</div>
							<?php endif; ?>
						</div>
						<div class="nas-item-price">
							<div class="product-price">
								<?php
								if( $product->get_price_html() !='' ):
									echo $product->get_price_html();
								endif;
								?>
							</div>
						</div>
					</div>

					<?php
					$json['result'] .= ob_get_clean();
				}
				$json['result'] .= '</ul>';
			}else{
				$json['result'] = '<p class="nas-empty-result">'.__('No results.', 'nbt-solution').'</p>';
			}
			$json['complete'] = true;
		}
		wp_send_json($json);
	}


	public function wp_enqueue_scripts() {
		wp_enqueue_style( 'jquery.mCustomScrollbar', NB_AJAX_SEARCH_URL . 'assets/css/jquery.mCustomScrollbar.min.css',false,'1.1','all');
		wp_enqueue_script( 'jquery.mCustomScrollbar', NB_AJAX_SEARCH_URL . 'assets/js/jquery.mCustomScrollbar.min.js', null, null, true );

		if ( defined('NB_SOLUTION_DEV') && NB_SOLUTION_DEV === true) {
			wp_enqueue_style( 'ajax-search', NB_AJAX_SEARCH_URL . 'assets/css/style.css',false,'1.1','all');
			
			wp_enqueue_script( 'ajax-search', NB_AJAX_SEARCH_URL . 'assets/js/frontend.js', null, null, true );

		}

		$layout = NB_Multistore_Modules::get_setting('ajax-search');

		if( isset($layout['wc_ajax-search_color_icon']) ) {
			$style = '.nbt-icon-search:before { color: '. esc_attr($layout['wc_ajax-search_color_icon']) .';}';
			wp_add_inline_style('frontend-solutions', $style);
		}
	}
}

new NB_Solutions_Ajax_Search_Frontend();