<?php
class NB_Solutions_Ajax_Search_Ajax {
    function __construct() {
        add_action( 'wp_ajax_nopriv_nb_ajax_search', array($this, 'postSearch') );
        add_action( 'wp_ajax_nb_ajax_search', array($this, 'postSearch') );
    }

	public function postSearch() {
        $html = $html_cache = '';
        $json = array();

        if( $s = sanitize_text_field($_POST['s']) ) {

            $term = isset($_POST['term']) ? absint($_POST['term']) : false;

            $search = new NB_Solutions_Ajax_Search_Query(array(
                'phrase' => trim($s),
                'term' => $term,
            ));

            $results = $search->get_results();


            if( $results ) {
                
                foreach( $results as $index => $post ) {
                    $featured_image = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID));

                    $html .= sprintf('<li class="%s">', 'nb-search-post-type-'.$post->post_type);
                    $html .= '<div class="nb-search-left">';
                    if( $featured_image ) {
                        $img_src = $featured_image[0];
                    }else {
                        $img_src = NB_MULTISTORE_EXTEND_URL . 'assets/frontend/images/placeholder.png';
                    }
                    $html .= '<a href="'. get_permalink($post->ID) .'" title="'. $post->post_title. '"><img src="'. $img_src .'" /></a>';
                    $html .= '</div>';

                    $html .= '<div class="nb-search-right">';                    
                    $html .= '<h4><a href="'. get_permalink($post->ID) .'" title="'. $post->post_title. '">' . $post->post_title .'</a></h4>';
                    
                    if( function_exists( 'WC' ) && $post->post_type == 'product' ) {
                        $product = wc_get_product($post->ID);

                        if ( get_option( 'woocommerce_enable_review_rating' ) != 'no' ) {
                            $rating_count = $product->get_rating_count();
                            $review_count = $product->get_review_count();
                            $average      = $product->get_average_rating();

                            $html .= '<div class="woocommerce-product-rating">';
                            $html .= '<div class="star-rating">';
                            $html .= wc_get_star_rating_html( $average, $rating_count );
                            $html .= '</div>';
                            $html .= '</div>';
                        }
                        $html .= '<div class="nb-search-price"><span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol">$</span>9.00</span></div>';
                    }
                    $html .= '</div>';
                    $html .= '</li>';

                    $html_cache .= '<li class="nb-search-history"><a href="'. get_permalink($post->ID) .'" title="'. $post->post_title. '">' . $post->post_title .'</a></li>';
                }

                $json['complete'] = true;
                $json['results'] = $html;
                $json['results_cache'] = $html_cache;
            }
        }
        
  
		wp_send_json($json);
	}
}

new NB_Solutions_Ajax_Search_Ajax();