var gulp = require('gulp');
var sass = require('gulp-sass');
var autoprefixer = require('autoprefixer');
var postcss = require('gulp-postcss');
//var rtlcss = require('gulp-rtlcss');
var rename = require('gulp-rename');
var plumber = require('gulp-plumber');
var gutil = require('gulp-util');
var cssnano = require('gulp-cssnano');
var gcmq = require('gulp-group-css-media-queries');
var jshint = require('gulp-jshint');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var sourcemaps = require('gulp-sourcemaps');
var browserSync = require('browser-sync').create();
var reload = browserSync.reload;
var onError = function (err) {
    console.log('An error occurred:', gutil.colors.magenta(err.message));
    gutil.beep();
    this.emit('end');
};

gulp.task('frontcss', function() {
    return gulp.src('./*.scss')
        .pipe(plumber({ errorHandler: onError }))
        // .pipe(sourcemaps.init())
        .pipe(sass())
        .pipe(postcss([ autoprefixer() ]))
        // .pipe(autoprefixer())
        .pipe(gcmq())
        // .pipe(sourcemaps.write())
        .pipe(gulp.dest('./assets/css'))
        .pipe(cssnano({zindex:false}))
        .pipe(rename({ suffix: '.min' }))
        .pipe(gulp.dest('./assets/css'));
});

gulp.task('themecss', function() {
    return gulp.src('./*.scss')
        .pipe(plumber({ errorHandler: onError }))
        // .pipe(sourcemaps.init())
        .pipe(sass())
        .pipe(postcss([ autoprefixer() ]))
        // .pipe(autoprefixer())
        .pipe(gcmq())
        // .pipe(sourcemaps.write())
        .pipe(gulp.dest('./'))
        .pipe(cssnano({zindex:false}))
        .pipe(rename({ suffix: '.min' }))
        .pipe(gulp.dest('./'));
});

gulp.task('watch', function() {
    gulp.watch('*.scss', ['frontcss']);
});

