<?php
/*
    Plugin Name: NBT Ajax Search
    Plugin URI: http://netbaseteam.com
    Description: This is package of solutions core.
    Version: 1.5
    Author: Netbaseteam
    Author URI: ttps://netbaseteam.com/
 */

define('NB_AJAX_SEARCH_PATH', plugin_dir_path( __FILE__ ));
define('NB_AJAX_SEARCH_URL', plugin_dir_url( __FILE__ ));

class NB_Solutions_Ajax_Search {

    public static $plugin_id = 'ajax-search';

    public static $options;

    /**
     * @var null
     *
     * @since 1.0.0
     */
    private static $instance = null;
    

    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NB_Solutions_Ajax_Search
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * NB_Solutions_Ajax_Search constructor.
     *
     * @since 1.0.0
     */
    private function __construct() {

        self::$options = get_option(NB_Solutions_Ajax_Search::$plugin_id .'_settings');

        include_once NB_AJAX_SEARCH_PATH . 'inc/search.class.php';
        include_once NB_AJAX_SEARCH_PATH . 'inc/ajax.php';

        if( ! is_admin() ) {
            include_once NB_AJAX_SEARCH_PATH . 'inc/frontend.php';
        }else {
            include_once NB_AJAX_SEARCH_PATH . 'inc/admin.php';
        }
    }
}

NB_Solutions_Ajax_Search::instance();