<?php
class NB_Multistore_Modules
{
    /**
     * Variable to hold the initialization state.
     *
     * @var  boolean
     */
    protected static $initialized = false;

    public static $settings = array();

    public static $module_lists = array();
    public static $module_settings = array();
    protected static $package = '';

    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NB_Solutions
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }


    public static function register_modules()
    {
        self::$module_lists = array(
            'ajax-search' => array(
                'label' => 'Ajax Search',
                'class' => 'Ajax_Search',
                'description' => __('Allow customers easy enter price for variation product.', 'nbt-solution')
            ),
        );

        return self::$module_lists;
    }

    private function __construct() {	
        self::register_modules();
        add_action( 'admin_init', array(__CLASS__, 'load_modules') );
        self::$package = wp_get_theme(get_template())->get('Tags');

        add_action( 'admin_notices', array(__CLASS__, 'admin_notice_compile_modules') );
        add_filter( 'nb_solution_modules', array( __CLASS__, 'disable_ajax_search') );
    }

    public static function load_modules()
    {
        if( ! empty(self::$module_lists) && is_array(self::$module_lists) ) {
            foreach( self::$module_lists as $module_name => $module ) {
                $path_modules = NB_MULTISTORE_MODULES_PATH . $module_name .'/';

                // Only load module if enable settings
                if( isset(self::$module_lists[$module_name]) ) {
                    require_once($path_modules . $module_name . '.php');

                    // Get settings form
                    $path_settings = $path_modules . 'inc/settings.php';

                    if( file_exists($path_settings) ) {
                        include_once($path_settings);
                        self::$module_settings[$module_name] = call_user_func( 'NB_' . $module['class'] . '_Settings::get_settings' );

                        // Load value from DB
                        if( $data_settings = get_option($module_name.'_settings') ) {
                            foreach($data_settings as $key => $value) {
                                if( isset(self::$module_settings[$module_name][$key]) ) {
                                    self::$module_settings[$module_name][$key]['default'] = $value;
                                }
                            }
                        }

                    }
                }
            }
        }
    }

    
    public static function get_setting($module_name, $name = null) {
        $settings = get_option($module_name . '_settings');
        
        if( ! $settings ) {
            $settings = array();
            if( ! empty(self::$module_lists[$module_name]) && is_array(self::$module_lists[$module_name]) ) {
                $path_modules = NB_MULTISTORE_MODULES_PATH . $module_name .'/';
                $path_settings = $path_modules . 'inc/settings.php';
                if( file_exists($path_settings) && isset(self::$module_lists[$module_name]['class']) ) {
                    include_once($path_settings);
                    $get_settings = call_user_func( 'NB_' . self::$module_lists[$module_name]['class'] . '_Settings::get_settings' );

                    foreach( $get_settings as $k => $set) {
                        $settings[$k] = $set['default'];
                    }
                }
            }
        }

        return $settings;
    }

    public static function save_modules() {
        if( isset($_POST['nb-setting-submit']) ) {
            unset($_POST['nb-setting-submit']);
            
            foreach( self::$module_settings as $module_name => $settings ) {
                $data = array();
                foreach( $settings as $key => $field )  {
                    if( isset($_POST[$module_name][$key]) ) {
                        self::$module_settings[$module_name][$key]['default'] = $_POST[$module_name][$key];
                        $data[$key] = $_POST[$module_name][$key];
                    }
                }

                update_option($module_name.'_settings', $data);

            }
        }
    }


    public static function solutions_settings_page() {

        if ( ! empty(self::$module_settings) ) {
            self::save_modules();
            ?>
            <style>
            .nb-solution-head {
                padding: 15px;
                background-color: #3E4960;
                font-weight: 700;
                font-size: 16px;
                color: #fff;

            }

            .nb-solution-head h4 {
                margin: 0;
            }


            .nb-solution-body table {
                border: 0;
                width: 100%;
                max-width: 100%;
                border-spacing: 0;
                border-collapse: collapse;
            }

            .nb-solution-body td {
                padding: 10px 15px;
            }

            .nb-solution-body td.col-left {
                background: #333C4E;
                border-right-width: 1px;
                border-right-style: solid;
                border-bottom-width: 1px;
                border-bottom-style: solid;
                border-bottom-color: #28303E;
                border-right-color: #28303E;
                width: 25%;
            }

            .nb-solution-body td.col-right {
                position: relative;
                background: #E9F0FA;
                border-bottom-width: 1px;
                border-bottom-style: solid;
                border-bottom-color: #D4E2F5;
            }

            .nb-solution-body td.col-left label {
                display: block;
                width: 100%;
                text-align: left;
                color: #fff;
                padding-top: 5px;
                margin-bottom: 0;
                vertical-align: middle;
                font-weight: 600;
            }

            .nb-solution-body td.col-left .sub-text {
                color: #8795AC;
                padding-top: 2px;
                font-size: 12px;
                font-weight: normal;
                margin-bottom: 5px;
            }

            .nb-solution-body tr:hover td.col-left {
                background: #28303E;
            }
            .nb-solution-body tr:hover td.col-right {
                background: #D4E2F5;
            }

            .nb-form-control {
                min-width: 50%;
            }

            .nb-metabox-image-wrapper {
                display: flex;
            }

            .nb-metabox-image-thumbnail {
                display: flex;
                margin-right: 10px;
            }

            .nb-metabox-image-action {
                flex-wrap: wrap;
            }

            .nb-metabox-image-action .nb-metabox-image-remove {
                display: block !important;
                margin-top: 4px !important;
                width: 100%;
            }

            .nb-button {
                display: inline-block;
                padding: 6px 12px;
                margin-bottom: 0;
                font-size: 14px;
                font-weight: 400;
                line-height: 1.42857143;
                text-align: center;
                white-space: nowrap;
                vertical-align: middle;
                -ms-touch-action: manipulation;
                touch-action: manipulation;
                cursor: pointer;
                -webkit-user-select: none;
                -moz-user-select: none;
                -ms-user-select: none;
                user-select: none;
                background-image: none;
                border: 1px solid transparent;
            }

            .nb-button-primary {
                margin-top: 20px;
                color: #fff;
                padding: 15px;
                border: 0;
                background: #15A4FA;
            }
            [class^="show_if"] {
                display: none;
            }
            </style>
            <div class="wrap" id="panels-settings-page">
                <h1><?php _e('Settings', 'nbt-solution-core') ?></h1>
                
                <form action="" method="POST" id="frm-nb-settings">
                    <?php
                    $index = 0;
                    $enable_modules = get_option('multistore_extend_settings');
                    if( isset($enable_modules) && ! empty($enable_modules) ) {
                        foreach ( $enable_modules as $k => $module_name) {
        
                            if( isset(self::$module_settings[$module_name]) ) {
                                $module_field = self::$module_settings[$module_name];
                                $moduleInfo = self::$module_lists[$module_name];         
                                ?>
                                <section class="nb-solution-section">
                                    <div class="nb-solution-head">
                                        <h4><?php echo $moduleInfo['label'];?></h4>
                                    </div>

                                    <div class="nb-solution-body">
                                        <table class="nb-solution-table">
                                            <tbody>
                                                <?php
                                                    foreach( $module_field as $field_name => $field ) {
                                                        echo NB_Multistore_Metabox::render($module_name . '[' . $field_name .']', $field);
                                                    }
                                                ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </section>
                                <?php
                                $index++;
                            }
                        }
                    }
                    
                    if( $index ) {?>
                    <button type="submit" name="nb-setting-submit" class="nb-button nb-button-primary"><?php _e('Save Changes');?></button>
                    <?php }else {
                        echo 'Please enable a <a href="'. admin_url() .'admin.php?page=multistore-extend">Modules</a>';
                    }?>
                </form>
            </div>
            <?php
        }
    }

    public static function disable_ajax_search($modules) {
        unset($modules['ajax-search']);
        return $modules;
    }

    public static function admin_notice_compile_modules() {
        if( is_multisite() ) {
            $upload_dir   = wp_upload_dir();
            $link_css = $upload_dir['basedir'] . '/frontend.css';
            $link_js = $upload_dir['basedir'] . '/frontend.js';
        }else {
            $link_css = NB_MULTISTORE_EXTEND_PATH . 'assets/frontend/css/frontend.css';
            $link_js = NB_MULTISTORE_EXTEND_PATH . 'assets/frontend/js/frontend.js';
        }

        $isVaild = true;
        if( ! file_exists($link_js) || ! file_exists($link_css) ) {
            $isVaild = false;
        }else {
            $filesize_js = filesize($link_js);
            $filesize_css = filesize($link_css);

            if( empty($filesize_js) || empty($filesize_css) ) {
                $isVaild = false;
            }
        }

        if( empty($isVaild) ) {
            $class = 'notice notice-error';
            $message = '<p><strong>NETBASE MULTISTORE EXTEND NOTICE</strong></p><p>Not find JS, CSS file of plugin NB Multistore Extend, please visit <a href="'. admin_url() .'admin.php?page=solution-dashboard">here</a> or click on right admin menu <strong>NB Multistore Extend</strong> > <strong>Solution Dashboard</strong> and save to compile.</p>';
            printf( '<div class="%1$s">%2$s</div>', esc_attr( $class ), $message ); 
        }
    }
}

NB_Multistore_Modules::instance();