(function( $ ) {
 
    // Add Color Picker to all inputs that have 'color-field' class
    $(function() {
        $('.nb-control-colorpicker').wpColorPicker();
    });
	
	var nb_metabox_image = {
		init: function() {
			$(document).on('click', '.nb-metabox-image-upload', this.upload_image);
			$(document).on( 'click', '.nb-metabox-image-remove', this.remove_upload_image);
		},
		
		upload_image: function(e) {
			e.preventDefault();
			
			var $button = $( this ).closest('.nb-metabox-image-wrapper');
			
			// Create the media frame.
			var frame = wp.media.frames.downloadable_file = wp.media( {
				title   : nbt_solutions.i18n.mediaTitle,
				button  : {
					text: nbt_solutions.i18n.mediaButton
				},
				multiple: false
			} );
			
			// When an image is selected, run a callback.
			frame.on( 'select', function () {
				var attachment = frame.state().get( 'selection' ).first().toJSON();

					$button.addClass('class_name' + attachment.id);
					$button.find( 'input.nb-metabox-image-input' ).val( attachment.id );
					$button.find( '.nb-metabox-image-remove' ).css('opacity', '1');
					$button.find( 'img' ).attr( 'src', attachment.url );
			} );

			// Finally, open the modal.
			frame.open();
		},
		
		remove_upload_image: function(){
			var $button = $( this );

			$button.siblings( 'input.nb-metabox-image-input' ).val( '' );
			$button.siblings( '.nb-metabox-image-remove' ).show();
			$button.parent().prev( '.nb-metabox-image-thumbnail' ).find( 'img' ).attr( 'src', $button.attr('data-placeholder') );

			return false;
		},
	}
	
	var nb_metabox_select2 = {
		init: function() {
			console.log(222);
			if( $('.nb-form-select2').length > 0 && jQuery().select2 ) {
				$('.nb-form-select2').each(function( index ) {
					var placeholder = $(this).attr('data-placeholder');
					$(this).select2({
						placeholder: placeholder,
						width: '50%'
					});
				});
			}
		}
	}
	
	nb_metabox_image.init();
	nb_metabox_select2.init();
     
})( jQuery );