<?php
class NB_Multistore_Metabox {
    /**
     * @var null
     *
     * @since 0.0.1
     */
    private static $instance = null;
	
    /**
     * Get instance.
     *
     * @since 0.0.1
     *
     * @return null|NB_Solutions
     */
    public static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    private function __construct() {	
        
    }

    public static function render( $name, $field ) {
        $field_type = $field['type'];

        $variations_attr = '';
        if( isset($field['logic']) ) {
            $variations_json = wp_json_encode( $field['logic'] );
            $variations_attr = function_exists( 'wc_esc_json' ) ? wc_esc_json( $variations_json ) : _wp_specialchars( $variations_json, ENT_QUOTES, 'UTF-8', true );
            $field['wrapper_class'][] = 'nb-metabox-has-logic';
        }

        $field['wrapper_class'][] = 'nb-metabox-row';

        $wrapper_field = '';
        if( isset($field['wrapper_attribute']) ) {
            $field['wrapper_class'][] = 'nb-metabox-logic-hidden';
            foreach( $field['wrapper_attribute'] as $k_attribute => $wrapper_attribute) {
                $wrapper_field .= ' ' . $k_attribute .'="'. $wrapper_attribute . '"';
            }
        }
        ?>
        <tr id="<?php echo esc_attr($field['id']);?>" class="<?php echo isset($field['wrapper_class']) ? implode(' ', $field['wrapper_class']) : '';?>" data-logic="<?php echo $variations_attr;?>"<?php echo $wrapper_field;?>>
            <td class="col-left col-md-3">
                <label for="<?php echo esc_attr($name);?>" class="control-label"><?php echo esc_attr($field['label']);?></label>
                <?php if( isset($field['desc']) ) { ?><div class="sub-text"><?php echo esc_attr($field['desc']);?></div><?php }?>
            </td>
        
            <td class="col-right">
                <?php
                switch($field_type) {
                    case 'select':
                        self::metabox_select($name, $field, false, false);
                        break;
                    case 'select2':
                        self::metabox_select2($name, $field, false);
                        break;
                    case 'text':
                        self::metabox_text($name, $field, false, false);
                        break;
                    case 'color':
                        self::metabox_color($name, $field, false, false);
                        break;
                    case 'image':
                        self::metabox_image($name, $field, false);
                        break;
                    default:
                        break;
                }?>
            </td>
        </tr>
        <?php
    }

    public static function metabox_select2($name, $field, $return = false ) {
        $field['field_class'][] = 'nb-form-control nb-control-dropdown nb-form-select2';

        $extra_attribute = '';


        if( isset($field['placeholder']) ) {
            $field['attribute']['data-placeholder'] = $field['placeholder'];
        }
        
        if( isset($field['attribute']) ) {
            if( isset($field['attribute']['multiple']) && $field['attribute']['multiple'] == 'multiple') {
                $name = $name . '[]';

            }
           
            
            foreach( $field['attribute'] as $k_attr => $v_attr) {
                $extra_attribute .= $k_attr .'="' . $v_attr .'" ';
            }

            $extra_attribute = ltrim($extra_attribute, ' ');
        }

        $html = sprintf('<select name="%s" class="%s"%s>', $name, implode(' ', $field['field_class']), $extra_attribute);
            if( isset($field['placeholder']) ) {
                $html .= '<option value="">'. $field['placeholder'] .'</option>';
            }

            foreach( $field['options'] as $option_name => $option_value ) {
                $selected = '';
                if( ! is_array($field['default']) && isset($field['default']) && in_array($option_name, $field['default']) ) {
                    $selected = ' selected';
                }

                if( is_array($field['default']) ) {
                    foreach( $field['default'] as $k => $v_default ) {
                        if( $v_default == $option_name ) {
                            $selected = ' selected';
                        }
                    }
                }
                $html .= '<option value="'.$option_name.'"'.$selected.'>'. $option_value .'</option>';
            }
            
        $html .= '</select>';

        if( $return ) {
            return $html;
        }else {
            echo $html;
        }
    }

    public static function metabox_select($name, $field, $value, $return = false ) {
        $field['field_class'][] = 'nb-form-control nb-control-dropdown';

        $html = '<select name="'. $name .'" class="'. implode(' ', $field['field_class']) .'">';
            if( isset($field['placeholder']) ) {
                $html .= '<option value="">'. $field['placeholder'] .'</option>';
            }

            foreach( $field['options'] as $option_name => $option_value ) {
                $selected = '';
                if( isset($field['default']) && $option_name == $field['default']) {
                    $selected = ' selected';
                }
                $html .= '<option value="'.$option_name.'"'.$selected.'>'. $option_value .'</option>';
            }
            
        $html .= '</select>';

        if( $return ) {
            return $html;
        }else {
            echo $html;
        }
    }

    public static function metabox_text($name, $field, $value, $return = false ) {
        $field['field_class'][] = 'nb-form-control nb-control-input';

        $html = '<input type="text" name="'. $name .'" class="'. implode(' ', $field['field_class']) .'"';
            if( isset($field['placeholder']) ) {
                $html .= ' placeholder="'. $field['placeholder'] .'"';
            }

            if( isset($field['default']) ) {
                $html .= ' value="' . $field['default'] .'"';
            }
            
        $html .= '>';

        if( $return ) {
            return $html;
        }else {
            echo $html;
        }
    }


    public static function metabox_color($name, $field, $value, $return = false ) {
        $field['field_class'][] = 'nb-form-control nb-control-colorpicker';

        $html = '<input type="text" name="'. $name .'" class="'. implode(' ', $field['field_class']) .'"';
            if( isset($field['placeholder']) ) {
                $html .= ' placeholder="'. $field['placeholder'] .'"';
            }

            if( isset($field['default']) ) {
                $html .= ' value="' . $field['default'] .'"';
            }
            
        $html .= '>';

        if( $return ) {
            return $html;
        }else {
            echo $html;
        }
    }

    public static function metabox_image($name, $field, $return = false ) {
        $field['field_class'][] = 'nb-form-control nb-control-colorpicker';
        
        
        $image = $field['default'] ? wp_get_attachment_image_src($field['default']) : '';
        $image = $image ? $image[0] : plugins_url( 'metabox//img/placeholder.png', __FILE__ );

        $hidden = ' style="opacity: 0;"';
        if( $field['default'] ) {
            $hidden = '';
        }

        $html = '<div class="nb-metabox-image-wrapper">
                    <div class="nb-metabox-image-thumbnail">
                        <img src="'. esc_url($image). '" width="60px" height="60px" />
                    </div>

                    <div class="nb-metabox-image-action">
                        <input type="hidden" class="nb-metabox-image-input" name="'. $name .'" value="s" />
                        <button type="button" class="nb-metabox-image-upload button">'. esc_html__('Upload/Add image', 'wcvs') .'</button>
                        <button type="button" class="nb-metabox-image-remove button"'. $hidden .' data-placeholder="'. plugins_url( 'metabox//img/placeholder.png', __FILE__ ) .'">'. esc_html__('Remove image', 'wcvs') .'</button>
                    </div>
                </div>';

        if( $return ) {
            return $html;
        }else {
            echo $html;
        }
    }
}