jQuery( function( $ ) {
	var wp = window.wp;
	/**
	 * Variations Price Matrix actions
	 */
	var nbt_solutions_admin = {

		/**
		 * Initialize variations actions
		 */
		init: function() {
			this.call();
			this.metabox_logic();

			$(document).on('submit', '#frm-multistore-extend-settings', this.save_settings)
		},

		call: function() {
			if( jQuery().wpColorPicker ) {
				$('.nbt-colorpicker' ).wpColorPicker();
			}
		},

		save_settings: function(event) {
			event.preventDefault();

			$.ajax({
				url: multistore_extend.save_settings,
				data: $(this).serialize(),
				type: 'POST',
				datatype: 'json',
				success: function( response ) {
					alert(response.message);
				},
				error:function(){
					alert('There was an error when processing data, please try again !');
				}
			});

		},
		
		metabox_logic: function() {
			$( ".nb-metabox-has-logic" ).each(function( index ) {
				var $logic			= $(this).attr('data-logic'),
					$form_control	= $(this).find('.nb-form-control');
				
				if( $form_control.hasClass('nb-control-dropdown') ) {
					var $val = $form_control.val();
					nbt_solutions_admin.logic_switch($logic, $val);


					$form_control.on('change', function() {
						var $val = $(this).val();
						nbt_solutions_admin.logic_switch($logic, $val);
					});


				}
				
			});
			
			
			$( ".nb-metabox-logic-hidden" ).each(function( index ) {
				var $this			= $(this),
					$field			= $this.attr('data-field'),
					$val			= $('#' + $field).find('.nb-form-control').val();
					
				$this.hide();
				
				if( typeof $val == 'object') {
					$.each($val, function(k, ell) {
						if( $this.hasClass('show_if_' + $val) ) {
							$this.show();
						}
					});
				}else {
					if( $this.hasClass('show_if_' + $val) ) {
						$this.show();
					}
				}
			});
			
			
		},

		logic_switch: function($logic, $val) {
			$.each(JSON.parse($logic), function(k, el) {
				$('#' + el + '[class^="show_if"]').hide();

				if( typeof $val == 'object') {
					$.each($val, function(k, ell) {
						$('#' + el + '.show_if_' + ell).show();
					});
				}else {
					$('#' + el + '.show_if_' + $val).show();
				}
			});
		}
	}
	
	nbt_solutions_admin.init();

});