<?php

define( 'NBT_COUNTDOWN_URL', trailingslashit( plugins_url( 'multistore-elements' ) ) );

if ( ! class_exists( 'NBT_Countdown' ) ):

final class NBT_Countdown extends WP_Widget
{

	function __construct() {		

		$options = array(
			'classname' 	=> 'nbt-countdown',
			'description' 	=> esc_html__( 'Display countdown block', 'nb-fw' )
			);

		parent::__construct( 'countdown_id', 'NBT Countdown', $options );

		add_action( 'wp_enqueue_scripts', array( $this, 'nbt_countdown_enqueue_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'nbt_countdown_admin_enqueue_scripts' ) );

	}

	function nbt_countdown_enqueue_scripts() {

/*		wp_enqueue_style( 'countdown', NBT_COUNTDOWN_URL . 'widgets/assets/css/style.css', array(), '20171103' );*/

		wp_enqueue_script( 'countdown', NBT_COUNTDOWN_URL . 'widgets/assets/js/jquery.mb-comingsoon.min.js', array( 'jquery' ), '20171103' );
	}

	function nbt_countdown_admin_enqueue_scripts() {

		wp_enqueue_script('countdown', NBT_COUNTDOWN_URL . 'widgets/assets/js/admin.js', array( 'jquery' ), '20171103' );
	}

	function form( $instance )
	{
		$default_value 		= array(
			'info' 					=> '',
			'title' 				=> '',
			'text_days' 			=> 'days',
			'text_hours' 			=> 'hours',
			'text_minutes' 			=> 'minutes',
			'text_seconds' 			=> 'seconds',
			'time_year'				=> '',
			'time_month'			=> '',
			'time_day'				=> '',
			'time_hour'				=> '',
			'style'					=> '',
			'background_img'		=> '',
			);
		$instance 				= wp_parse_args( (array) $instance, $default_value );
		$info 					= esc_attr( $instance[ 'info' ] );
		$title 					= esc_attr( $instance[ 'title' ] );
		$text_days 				= esc_attr( $instance[ 'text_days' ] );
		$text_hours 			= esc_attr( $instance[ 'text_hours' ] );
		$text_minutes			= esc_attr( $instance[ 'text_minutes' ] );
		$text_seconds			= esc_attr( $instance[ 'text_seconds' ] );
		$time_year				= esc_attr( $instance[ 'time_year' ] );
		$time_month				= esc_attr( $instance[ 'time_month' ] );
		$time_day				= esc_attr( $instance[ 'time_day' ] );
		$time_hour				= esc_attr( $instance[ 'time_hour' ] );
		$style					= esc_attr( $instance[ 'style' ] );
		$background_img			= esc_attr( $instance[ 'background_img' ] );

		// Create form
		// Info
		$html 	= '';
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Info', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'info' ) . '" value="' . $info . '"/>';
		$html  .= '</p>';

		// Title
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Title', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'title' ) . '" value="' . $title . '"/>';
		$html  .= '</p>';

		// Text Days
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Text Days', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'text_days' ) . '" value="' . $text_days . '"/>';
		$html  .= '</p>';

		// Text Hours
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Text Hours', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'text_hours' ) . '" value="' . $text_hours . '"/>';
		$html  .= '</p>';

		// Text Minutes
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Text Minutes', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'text_minutes' ) . '" value="' . $text_minutes . '"/>';
		$html  .= '</p>';

		// Text Seconds
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Text Seconds', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'text_seconds' ) . '" value="' . $text_seconds . '"/>';
		$html  .= '</p>';

		// Year
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Year', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'time_year' ) . '" value="' . $time_year . '"/>';
		$html  .= '</p>';

		// Month
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Month', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'time_month' ) . '" value="' . $time_month . '"/>';
		$html  .= '</p>';

		// Day
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Day', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'time_day' ) . '" value="' . $time_day . '"/>';
		$html  .= '</p>';

		// Hour
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Hour', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat" type="text" name="' . $this->get_field_name( 'time_hour' ) . '" value="' . $time_hour . '"/>';
		$html  .= '</p>';


		// Style
		$black_style 					= $style == 'black' ? 'selected="selected"' : '';

		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Style', 'nb-fw' ) . ': </label>';
		$html  .= '<select name="' . $this->get_field_name( 'style' ) . '">
						<option value="">' . esc_html__( 'White', 'nb-fw' ) . '</option>
						<option value="black"' . $black_style . '>' . esc_html__( 'Black', 'nb-fw' ) . '</option>
				   </select>
					';
		$html  .= '</p>';

		// Background Image
		$html  .= '<p>';
		$html  .= '<label>' . esc_html__( 'Background Image', 'nb-fw' ) . ': </label>';
		$html  .= '<input class="widefat nbt-countdown-bg-img" type="text" name="' . $this->get_field_name( 'background_img' ) . '" value="' . $background_img . '"/>';
		$html  .= '</p><p>';
		$html  .= '<input id="nbt-upload-image-button" type="button" name="nbt-upload-image-button" value="' . esc_html__( 'Select Image' ) . '"/>';
		$html  .= '</p><p>';
		$html  .= '<img class="nbt-countdown-bg-img-preview" style="width: 100%;" src="' . $background_img . '" alt=""/>';
		$html  .= '</p>';

		echo $html;
	}

	function update($new_instance, $old_instance)
	{
		$instance 							= $old_instance;
		$instance['info'] 					= strip_tags( $new_instance[ 'info' ] );
		$instance['title'] 					= strip_tags( $new_instance[ 'title' ] );
		$instance['text_days'] 				= strip_tags( $new_instance[ 'text_days' ] );
		$instance['text_hours'] 			= strip_tags( $new_instance[ 'text_hours' ] );
		$instance['text_minutes'] 			= strip_tags( $new_instance[ 'text_minutes' ] );
		$instance['text_seconds'] 			= strip_tags( $new_instance[ 'text_seconds' ] );
		$instance['time_year'] 				= strip_tags( $new_instance[ 'time_year' ] );
		$instance['time_month'] 			= strip_tags( $new_instance[ 'time_month' ] );
		$instance['time_day'] 				= strip_tags( $new_instance[ 'time_day' ] );
		$instance['time_hour'] 				= strip_tags( $new_instance[ 'time_hour' ] );
		$instance['style'] 					= strip_tags( $new_instance[ 'style' ] );
		$instance['background_img'] 		= strip_tags( $new_instance[ 'background_img' ] );

		return $instance;
	}

	function widget($args, $instance)
	{
		//extract  this array to use variable below
		extract($args);

		$info    = ( isset( $instance['info'] ) && '' != $instance['info'] ) ? $instance['info'] : '';

		$title    = ( isset( $instance['title'] ) && '' != $instance['title'] ) ? $instance['title'] : '';

		$text_days    = ( isset( $instance['text_days'] ) && '' != $instance['text_days'] ) ? $instance['text_days'] : 'days';
		$text_hours   = ( isset( $instance['text_hours'] ) && '' != $instance['text_hours'] ) ? $instance['text_hours'] : 'hours';
		$text_minutes = ( isset( $instance['text_minutes'] ) && '' != $instance['text_minutes'] ) ? $instance['text_minutes'] : 'minutes';
		$text_seconds = ( isset( $instance['text_seconds'] ) && '' != $instance['text_seconds'] ) ? $instance['text_seconds'] : 'seconds';

		$year = ( (int) ( $instance['time_year'] ) != '' ) ? (int) ( $instance['time_year'] ) : date( "Y", time() );

		$month = ( (int) ( $instance['time_month'] ) != '' ) ? (int) ( $instance['time_month'] ) : date( "m", time() );

		$day = ( (int) ( $instance['time_day'] ) != '' ) ? (int) ( $instance['time_day'] ) : date( "d", time() );

		$hour = ( (int) ( $instance['time_hour'] ) != '' ) ? (int) ( $instance['time_hour'] ) : date( "G", time() );

		$color_style = ( isset( $instance['style'] ) && '' != $instance['style'] ) ? ' color-' . $instance['style'] : '';

		$bg_style = '';

		if ( $instance['background_img'] != '' ) {
			$bg_style = "background-image: url('" . $instance['background_img'] . "');";
			$bg_style .= "background-size: cover;";
			$bg_style .= "background-position: center;";
		}
		
		$id = uniqid();

		echo $before_widget;

		$html = '';

		$html = '<div class="nbt-countdown-wrapper' . $color_style . '" style="' . $bg_style . '">';

		$html .= '<p class="nbt-countdown-info">' . $info . '</p>';

		$html .= '<p class="nbt-countdown-title">' . $title . '</p>';

		$html .= '<div id="nbt-countdown' . $id . '"></div>';

		$html .= '</div>';

		echo $html;

		?>
		
		<!-- Setup countdown -->
		<script type="text/javascript">
		jQuery(function () {
			jQuery(document).ready(function () {
				jQuery("#nbt-countdown<?php echo esc_js($id); ?>").mbComingsoon({
					expiryDate  : new Date(<?php echo ent2ncr($year. ','. ( $month - 1 ) .',' . $day . ',' . $hour ); ?>),
					localization: {
						days   : "<?php echo esc_js($text_days); ?>",
						hours  : "<?php echo esc_js($text_hours); ?>",
						minutes: "<?php echo esc_js($text_minutes); ?>",
						seconds: "<?php echo esc_js($text_seconds); ?>"
					},
					speed       : 100
				});
				setTimeout(function () {
					jQuery(window).resize();
				}, 200);
			});
		});
		</script>

		<?php

		echo $after_widget;

	}
}


function register_nbtcountdown_widget() {
    register_widget( 'NBT_Countdown' );
}
add_action( 'widgets_init', 'register_nbtcountdown_widget' );

endif;