<?php
if( ! class_exists('NB_Brands_Category')) {
	class NB_Brands_Category extends WP_Widget {
		public function __construct() {
			parent::__construct(
				'nb-brands-category',
				__( 'NB - Lists of Brands ', 'nbt-brands-thumbnail' ),
				array(
					'classname' => 'nbt-brands-thumbnail',
					'description' => __( 'Show all brands lists', 'nbt-brands-thumbnail' )
				)
			);
		}


		public function form( $instance ) {
			$title = esc_attr( $instance['title'] );;?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?>: 
					<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>">
				</label>
			</p>
		}
	}
}