<?php

if( !class_exists('NB_Blogs_Promotion_Widget') ){
	class NB_Blogs_Promotion_Widget extends WP_Widget {

		function __construct() {
			$widgetOps = array('classname' => 'nb_blogs_promotion', 'description' => esc_html__('Display blogs on site', 'nb-fw'));
			parent::__construct('nb_blogs_promotion', esc_html__('NB - Blogs Promotion', 'nb-fw'), $widgetOps);
		}

		function widget( $args, $instance ) {
			
			extract($args);
			$title 				= apply_filters('widget_title', $instance['title']);
			$limit 				= ($instance['limit'] != 0)?absint($instance['limit']):4;
			$columns 			= ($instance['columns'] != 0)?absint($instance['columns']):3;
			$columnstablet 			= ($instance['columnstablet'] != 0)?absint($instance['columnstablet']):3;
			$order 				= $instance['order'];
			$orderby 			= $instance['orderby'];
			$categories 		= isset($instance['categories'])?(array)$instance['categories']:array();
			
			
			echo $before_widget;
			
			if( $title ){
				echo $before_title . $title . $after_title;
			}
			
			$args = array(
					'post_type'				=> 'post'
					,'ignore_sticky_posts'	=> 1
					,'post_status'			=> 'publish'
					,'posts_per_page'		=> $limit
					,'order'				=> $order
					,'orderby'				=> $orderby
			);
			
			if( is_array($categories) && count($categories) > 0 ){
				$args['category__in'] = $categories;
			}

			$attr = array();
			if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
            }
            $attr[] = '"margin": "10"';
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }   
			
			global $post;
			$posts = new WP_Query($args);
			if( $posts->have_posts() ):
			?>
				<div class="blogs-widget-wrapper owl-carousel owl-loaded owl-drag" <?php echo $data_owlcarousel; ?>>
						
					<?php while( $posts->have_posts() ): 
						$posts->the_post(); 
						
					?>
					<div class="lst-blogs-promotion">
						<a href="<?php the_permalink() ?>" class="post-title">
							<?php the_title(); ?>
						</a>
					</div>
					<?php  endwhile; ?>
					
				</div>
				
				<?php
			endif;
			
			echo $after_widget;
			wp_reset_postdata();
		}

		function update( $new_instance, $old_instance ) {
			$instance = $old_instance;		
			$instance['title'] 				= strip_tags($new_instance['title']);		
			$instance['limit'] 				= absint($new_instance['limit']);
			$instance['columns'] 			= absint($new_instance['columns']);
			$instance['columnstablet'] 		= absint($new_instance['columnstablet']);
			$instance['order'] 				= $new_instance['order'];
			$instance['orderby'] 			= $new_instance['orderby'];
			$instance['categories'] 		= $new_instance['categories'];		
			
			return $instance;
		}

		function form( $instance ) {
			
			$defaults = array(
				'title' 				=> ''
				,'limit'				=> 4
				,'columns'				=> 3
				,'columnstablet'		=> 2
				,'order'				=> 'desc'
				,'orderby'				=> 'date'
				,'categories'			=> array()
				
			);
		
			$instance = wp_parse_args( (array) $instance, $defaults );	
			
			$categories = $this->get_list_categories(0);
			if( !is_array($instance['categories']) ){
				$instance['categories'] = array();
			}
			
		?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Enter your title', 'nb-fw'); ?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($instance['title']); ?>" />
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id('limit'); ?>"><?php esc_html_e('Number of posts to show', 'nb-fw'); ?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id('limit'); ?>" name="<?php echo $this->get_field_name('limit'); ?>" type="number" min="0" value="<?php echo esc_attr($instance['limit']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('columns'); ?>"><?php esc_html_e('Columns', 'nb-fw'); ?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id('columns'); ?>" name="<?php echo $this->get_field_name('columns'); ?>" type="number" min="0" value="<?php echo esc_attr($instance['columns']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('columnstablet'); ?>"><?php esc_html_e('Columns tablet', 'nb-fw'); ?> </label>
				<input class="widefat" id="<?php echo $this->get_field_id('columnstablet'); ?>" name="<?php echo $this->get_field_name('columnstablet'); ?>" type="number" min="0" value="<?php echo esc_attr($instance['columnstablet']); ?>" />
			</p>
			<p>
				<label for="<?php echo $this->get_field_id('orderby'); ?>"><?php esc_html_e('Order by', 'nb-fw'); ?> </label>
				<select class="widefat" id="<?php echo $this->get_field_id('orderby'); ?>" name="<?php echo $this->get_field_name('orderby'); ?>">
					<option value="none" <?php selected('none', $instance['orderby']) ?>><?php esc_html_e('None', 'nb-fw') ?></option>
					<option value="ID" <?php selected('ID', $instance['orderby']) ?>><?php esc_html_e('ID', 'nb-fw') ?></option>
					<option value="title" <?php selected('title', $instance['orderby']) ?>><?php esc_html_e('Title', 'nb-fw') ?></option>
					<option value="date" <?php selected('date', $instance['orderby']) ?>><?php esc_html_e('Date', 'nb-fw') ?></option>
					<option value="comment_count" <?php selected('comment_count', $instance['orderby']) ?>><?php esc_html_e('Comment count', 'nb-fw') ?></option>
					<option value="rand" <?php selected('rand', $instance['orderby']) ?>><?php esc_html_e('Random', 'nb-fw') ?></option>
				</select>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id('order'); ?>"><?php esc_html_e('Order', 'nb-fw'); ?> </label>
				<select class="widefat" id="<?php echo $this->get_field_id('order'); ?>" name="<?php echo $this->get_field_name('order'); ?>">
					<option value="asc" <?php selected('asc', $instance['order']) ?>><?php esc_html_e('Ascending', 'nb-fw') ?></option>
					<option value="desc" <?php selected('desc', $instance['order']) ?>><?php esc_html_e('Descending', 'nb-fw') ?></option>
				</select>
			</p>
			
			<p>
				<label><?php esc_html_e('Select categories', 'nb-fw'); ?></label>
				<div class="categorydiv">
					<div class="tabs-panel">
						<ul class="categorychecklist">
							<?php foreach($categories as $cat){ ?>
							<li>
								<label>
									<input type="checkbox" name="<?php echo $this->get_field_name('categories'); ?>[<?php esc_attr($cat->term_id); ?>]" value="<?php echo esc_attr($cat->term_id); ?>" <?php echo (in_array($cat->term_id,$instance['categories']))?'checked':''; ?> />
									<?php echo esc_html($cat->name); ?>
								</label>
								<?php $this->get_list_sub_categories($cat->term_id, $instance); ?>
							</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			</p>
			
			
			
			<?php 
		}
		
		function get_list_categories( $cat_parent_id ){
			$args = array(
					'hierarchical'		=> 1
					,'parent'			=> $cat_parent_id
					,'title_li'			=> ''
					,'child_of'			=> 0
				);
			$cats = get_categories($args);
			return $cats;
		}
		
		function get_list_sub_categories( $cat_parent_id, $instance ){
			$sub_categories = $this->get_list_categories($cat_parent_id); 
			if( count($sub_categories) > 0){
			?>
				<ul class="children">
					<?php foreach( $sub_categories as $sub_cat ){ ?>
						<li>
							<label>
								<input type="checkbox" name="<?php echo $this->get_field_name('categories'); ?>[<?php esc_attr($sub_cat->term_id); ?>]" value="<?php echo esc_attr($sub_cat->term_id); ?>" <?php echo (in_array($sub_cat->term_id,$instance['categories']))?'checked':''; ?> />
								<?php echo esc_html($sub_cat->name); ?>
							</label>
							<?php $this->get_list_sub_categories($sub_cat->term_id, $instance); ?>
						</li>
					<?php } ?>
				</ul>
			<?php }
		}
		
	}
}

