(function ($, window, document, undefined) {
    'use strict';
    $(function () {
    
        $(document).ready(function () {
            
            /*tungpk countdown*/
            function zeroise( str, max ){
                str = str.toString();
                return str.length < max ? zeroise('0' + str, max) : str;
            }
            function nb_counter( elements ){
                if( elements.length > 0 ){
                var interval = setInterval(function(){
                    elements.each(function(index, element){
                        var day = 0;
                        var hour = 0;
                        var minute = 0;
                        var second = 0;
                        
                        var delta = 0;
                        var time_day = 60 * 60 * 24;
                        var time_hour = 60 * 60;
                        var time_minute = 60;
                        
                        var wrapper = $(element);
                        
                        day = parseInt( wrapper.find('.days .number-wrapper .number').text() );
                        hour = parseInt( wrapper.find('.hours .number-wrapper .number').text() );
                        minute = parseInt( wrapper.find('.minutes .number-wrapper .number').text() );
                        second = parseInt( wrapper.find('.seconds .number-wrapper .number').text() );
                        
                        if( day != 0 || hour != 0  || minute != 0 || second != 0 ){
                            delta = (day * time_day) + (hour * time_hour) + (minute * time_minute) + second;
                            delta--;
                            
                            day = Math.floor(delta / time_day);
                            delta -= day * time_day;
                            
                            hour = Math.floor(delta / time_hour);
                            delta -= hour * time_hour;
                            
                            minute = Math.floor(delta / time_minute);
                            delta -= minute * time_minute;
                            
                            if( delta > 0 ){
                                second = delta;
                            }
                            else{
                                second = '0';
                            }
                            
                            day = ( day < 10 )? zeroise(day, 2) : day.toString();
                            hour = ( hour < 10 )? zeroise(hour, 2) : hour.toString();
                            minute = ( minute < 10 )? zeroise(minute, 2) : minute.toString();
                            second = ( second < 10 )? zeroise(second, 2) : second.toString();
                            
                            wrapper.find('.days .number-wrapper .number').text(day);
                            wrapper.find('.hours .number-wrapper .number').text(hour);
                            wrapper.find('.minutes .number-wrapper .number').text(minute);
                            wrapper.find('.seconds .number-wrapper .number').text(second);
                        }
                    
                        });
                    }, 1000);
                }
            }
            $('.counter-wrapper').each(function(){
                nb_counter( $(this) );
            }) ;
            
            /*tungpk end countdown*/
			var $rtl = false;
			if ($('html').attr('dir') == 'rtl'){
				$rtl = true;
			}
            
            $('.hotdeal-content-wrapper').each(function(){
                $(this).vcOwlCarousel({
                    rtl: $rtl,
                    loop: false,
                    navText: ['',''],
                    margin: 30,
                    responsive:{
                        0:{
                            items:1,
                        },
                        576:{
                            items: 2,
                        },
                        768:{
                            items: 2,
                        },
                        992:{
                            items: 2,
                        },
                        1200:{
                            items: 2,
                        },
                    }
                });
            });

            $('[data-slide="owl-carousel"]').each(function () {
                $(this).vcOwlCarousel({
					rtl: $rtl,
					loop: true,
					navText: ['',''],
					margin: parseInt($(this).attr('data-margin')),
					stagePadding: 15,
					dots: $.parseJSON($(this).attr('data-dots')),
					nav: $.parseJSON($(this).attr('data-nav')),
					autoplay: $.parseJSON($(this).attr('data-autoplay')),
					autoplayspeed: parseInt($(this).attr('data-autoplayspeed')),
					autoplayHoverPause: $.parseJSON($(this).attr('data-autoplayHoverPause')),
					responsive:{
						0:{
							items:1,
						},
						576:{
							items: $(this).attr('data-cols-sm'),
						},
						768:{
							items: $(this).attr('data-cols-md'),
						},
						992:{
							items: $(this).attr('data-cols-lg'),
						},
						1200:{
							items: $(this).attr('data-cols-xl'),
						},
					}
				});
            });
            if ($('[data-layout="isotope"]').length) {
                var $originLeft = false;
                if ($rtl) {
                    $originLeft = true;
                }
                $('[data-layout="isotope"]').each( function() {
                    var $isotope = $(this).imagesLoaded(function () {
                        $isotope.isotope({
                            itemSelector: '.isotope-item',
                            percentPosition: true,
                            layoutMode: 'masonry',
                            originLeft: $originLeft,
                        });
                    });
                    $(this).prev('.filters-button-group').on('click', '.filter-btn', function () {
                        var filterValue = $(this).attr('data-filter');
                        $isotope.isotope({filter: filterValue});
                        if(($(this).not('.is-checked'))){
                            $(this).parents('.filters-button-group').eq(0).find('.is-checked').removeClass('is-checked');
                            $(this).addClass('is-checked');
                        }
                    });
                });
            }
            $(window).on('resize', function () {
                
            });
        });
    });

})(jQuery, window, document);
