<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Define core class.
 */
if (class_exists("WPBakeryShortCode")) {
class NB_Element_Services extends WPBakeryShortCode {

    function __construct() {
        add_action( 'init', array( $this, 'map' ), 12 );
        add_shortcode( 'netbase_services', array( $this, 'shortcode_services' ) );
    }


    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
        vc_map(array(
            'name' => esc_html__('NB - Services Icon', 'nb-fw'),
            'base' => 'netbase_services',
            'category' => esc_html__('Netbase Elements', 'nb-fw'),
            'description' => esc_html__('Display Services Icon.', 'nb-fw'),
            'icon' => 'nbedu-widget-icon nbedu-widget-icon-our-team',
            'params' => array(
                array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Title', 'nb-fw'),
                    'param_name' => 'title_text',
                    'value' => '',
                ),

               array(
                        'param_name'       => 'style',
                        'heading'          => esc_html__( 'Style', 'nb-fw' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6 mgt15',                        
                        'value'            => array(                            
                            __( 'Icon', 'nb-fw' )      => 'icon',
                            __( 'Image', 'nb-fw' )     => 'image',
                        ),
                ),
                    array(
                        'param_name'       => 'align',
                        'heading'          => esc_html__( 'Box Alignment', 'nb-fw' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6',                        
                        'value'            => array(
                            __( 'Left', 'nb-fw' )   => 'left',
                            __( 'Center', 'nb-fw' ) => 'center',
                            __( 'Right', 'nb-fw' )  => 'right',
                        ),
                    ),
                    array(
                        'param_name' => 'content_box',
                        'heading'    => esc_html__( 'Content', 'nb-fw' ),
                        'type'       => 'textarea',                        
                        'holder'     => 'p'
                    ),
                    array(
                        'param_name' => 'text_color',
                        'heading'    => esc_html__( 'Title Color', 'nb-fw' ),
                        'type'       => 'colorpicker',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    array(
                        'param_name' => 'txtcontent_color',
                        'heading'    => esc_html__( 'Text Color', 'nb-fw' ),
                        'type'       => 'colorpicker',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),

                    array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Icon Width', 'nb-fw'),
                    'param_name' => 'icon_width',
                    'value' => '',
                    'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    array(
                    'type' => 'textfield',
                    'admin_label' => true,
                    'heading' => esc_html__('Icon Height', 'nb-fw'),
                    'param_name' => 'icon_height',
                    'value' => '',
                    'edit_field_class' => 'vc_col-sm-6', 
                    ),

                    array(
                        'param_name'       => 'style_border',
                        'heading'          => esc_html__( 'Style Border Icon', 'nb-fw' ),
                        'type'             => 'dropdown',
                        'edit_field_class' => 'vc_col-sm-6',                        
                        'value'            => array(
                            __( 'None', 'nb-fw' )   => 'none',
                            __( 'Solid', 'nb-fw' ) => 'solid',
                            __( 'Dotted', 'nb-fw' )  => 'dotted',
                            __( 'Dashed', 'nb-fw' )  => 'dashed',
                        ),
                    ),
                    
                    array(
                        'param_name' => 'title_font_primary',
                        'heading'    => esc_html__( 'Title Font Primary', 'nb-fw' ),
                        'type'       => 'checkbox',
                        'edit_field_class' => 'vc_col-sm-6', 
                    ),
                    array(
                        'param_name' => 'read_more',
                        'heading'    => esc_html__( 'Enable Read More?', 'nb-fw' ),
                        'type'       => 'checkbox',
                        
                    ),
                    array(
                        'param_name' => 'read_more_link',
                        'heading'    => esc_html__( 'Read more link', 'nb-fw' ),
                        'type'       => 'textfield',                        
                        'dependency' => array(
                            'element' => 'read_more',
                            'value'   => 'true',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_position',
                        'heading'    => esc_html__( 'Icon Position', 'nb-fw' ),
                        'type'       => 'dropdown',                        
                        'value'      => array(
                            __( 'Top', 'nb-fw' )   => 'top',
                            __( 'Left', 'nb-fw' )  => 'left',                            
                        ),
                        
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                    ),
                   
                    array(
                        'param_name'  => 'icon_fontawesome',
                        'heading'     => esc_html__( 'Icon', 'nb-fw' ),
                        'description' => esc_html__( 'Select icon from library.', 'nb-fw' ),
                        'type'        => 'iconpicker',
                        'group'       => esc_html__( 'Icon Settings', 'nb-fw' ),
                        'value'       => 'fa fa-adjust',
                        'settings'    => array(
                            'emptyIcon'    => false,
                            'iconsPerPage' => 4000,
                        ),
                        'dependency'  => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_color',
                        'heading'    => esc_html__( 'Icon color', 'nb-fw' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'nb-fw' ),
                        'value'      => '#ff4064',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'bgicon_color',
                        'heading'    => esc_html__( 'Background Icon color', 'nb-fw' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'nb-fw' ),
                        'value'      => '#fff',
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),

                    array(
                        'param_name' => 'icon_style',
                        'heading'    => esc_html__( 'Icon Box Style', 'nb-fw' ),
                        'type'       => 'dropdown',
                        'group'      => esc_html__( 'Icon Settings', 'nb-fw' ),
                        'value'      => array(
                            esc_html__('Select', 'nb-fw') => '',                        
                            esc_html__('Circle', 'nb-fw') => 'circle',
                            esc_html__('Square', 'nb-fw') => 'square',
                        
                        ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                        'edit_field_class' => 'vc_col-sm-4 vc_column',
                    ),
                    array(
                        'param_name' => 'icon_hover_color',
                        'heading'    => esc_html__( 'Icon Hover Color', 'nb-fw' ),
                        'type'       => 'colorpicker',
                        'group'      => esc_html__( 'Icon Settings', 'nb-fw' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'icon_size',
                        'heading'    => esc_html__( 'Icon Size (px)', 'nb-fw' ),
                        'type'       => 'textfield',
                        'group'      => esc_html__( 'Icon Settings', 'nb-fw' ),
                        'value'      => 24,
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'icon',
                        ),
                    ),
                    array(
                        'param_name' => 'graphic',
                        'heading'    => esc_html__( 'Upload Image', 'nb-fw' ),
                        'type'       => 'attach_image',
                        'group'      => esc_html__( 'Image Settings', 'nb-fw' ),
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),
                    array(
                        'param_name' => 'image_radius',
                        'heading'    => esc_html__( 'Border Radius (px)', 'nb-fw' ),
                        'type'       => 'textfield',
                        'group'      => esc_html__( 'Image Settings', 'nb-fw' ),
                        'value'      => 0,
                        'dependency' => array(
                            'element' => 'style',
                            'value'   => 'image',
                        ),
                    ),

                
                array(
                    'heading'    => __( 'Extra class name', 'nb-fw' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-fw' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                )
            )
        ));
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public function shortcode_services($atts, $content = null)
    {
        $html = $txtcolor = $class = $classtitle = $css_custom= $txtcontentcolor = $customcolumn ='';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title_text' => '',
                    'style'                   => 'icon',
                    'align'                   => 'left',
                    'style_border'            => 'none',
                    'content_box'             => '',
                    'icon_position'           => 'top',
                    'text_color'              => '#333333',
                    'txtcontent_color'        => '',
                    'bgicon_color' => '#fff',
                    'icon_style' => 'square',
                    'read_more'               => '',
                    'title_font_primary'      => '',
                    'read_more_link'          => '',
                    'icon_fontawesome'        => 'fa fa-adjust',
                    'icon_color'              => '#d6aa74',
                    'icon_hover_color'        => '',
                    'icon_size'               => 24,
                    'graphic'                 => '',
                    'image_radius'            => 0,
                    'icon_width' => '',
                    'icon_height' => '',
                    'css' => ''
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('nb_fw_services_');     
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_services', $atts );   
        
        if($align == 'center'){
            $class .='text-center';
        }elseif($align == 'left'){
            $class .='text-left';
        }else{
            $class .='text-right';
        }

        if($icon_position == 'left'){
            $class .=' icon-position-left';
        }else{
            $class .=' icon-position-top';
        }
        
        if($icon_style == 'circle'){
            $class .=' svicon-circle';
        }

        if(isset($style_border) && $style_border !='none'){
            $class .=' border-'.$style_border;
        }

        if($icon_width !=''){
            $css_custom .= 'width:' . ( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).';' ;
            if($icon_position == 'left'){
                $customcolumn .=' width: calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');';
                $customcolumn .=' width: -webkit-calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');';
                $customcolumn .=' width: -moz-calc(100% - '.( is_numeric( trim( $icon_width ) ) ? trim( $icon_width ) . 'px' : trim( $icon_width ) ).');' ;
            }
        }else{
            if($icon_position == 'left'){
                $customcolumn .=' width: calc(100% - 50px); width: -webkit-calc(100% - 50px); width: -moz-calc(100% - 50px);';
                
            }
        }
        if($icon_height !=''){
            $css_custom .= 'height:' . ( is_numeric( trim( $icon_height ) ) ? trim( $icon_height ) . 'px' : trim( $icon_height ) ).';' ;
        }

        if ( $icon_size != '' ) {
            $css_custom .= 'font-size:' . ( is_numeric( trim( $icon_size ) ) ? trim( $icon_size ) . 'px' : trim( $icon_size ) ).';' ;
        }
        if($icon_color){
            $css_custom .='color: ' . esc_attr( $icon_color ).';' ;
        }
        if($bgicon_color){
            $css_custom .='background-color: ' . esc_attr( $bgicon_color ).';' ;
        }

        if ( $css_custom ) {
            $css_custom = ' style="' . $css_custom . '"';
        }
        if($customcolumn){
            $customcolumn =' style="' . $customcolumn . '"';
        }

        if($text_color){
            $txtcolor .='color:'. esc_attr($text_color ).';';
        }
        if($txtcolor){
            $txtcolor =' style="' . $txtcolor . '"';
        }

        if($title_font_primary){
            $classtitle .=' font-h1';
        }
        if($txtcontent_color){
             $txtcontentcolor .='color:'. esc_attr($txtcontent_color ).';';
        }
        if($txtcontentcolor){
            $txtcontentcolor =' style="' . $txtcontentcolor . '"';
        }
        
        // Generate HTML code.

        $html .= '<div id="' . esc_attr($id) . '" class="'.esc_attr( $css_class ).' nb-fw services '. esc_html($class) .'"  >';
        
        if ( 'icon' == $style ) {            
            $html .= '<div class="svicon-font" '.$css_custom.'><span class="' . esc_attr( $icon_fontawesome ) .'" ></span></div>';
        }else{
            if ( ! empty( $graphic ) ) {
                // Get image link and image data
                $image = wpb_getImageBySize( array( 'attach_id' => preg_replace( '/[^\d]/', '', $graphic ) ) );

                $html .= '<div class="image-icon"><img src="' . esc_url( $image['p_img_large'][0] ) . '" alt="' . esc_attr__( 'Separator', 'nb-fw' ) . '" width="' . esc_attr( $image['p_img_large'][1] ) . '" height="' . esc_attr( $image['p_img_large'][2] ) . '" /></div>';
            }
        }
        $html .= '<div class="content" '.$customcolumn.'>';
        $html .= '<h4 class="service-title '. esc_html($classtitle) .'" '. $txtcolor .'>' . wp_kses_post( $title_text ) . '</h4>';
        if($content_box){
            $html .= '<p class="sv-content-box" '. $txtcontentcolor .'>' . wp_kses_post( $content_box ) . '</p>';
        }
        
        if ( 'true' == $read_more ) {
                $html .= '<a class="more" href="' . esc_url( $read_more_link ) . '">' . __( 'Read more', 'nb-fw' ) . '</a>';
        }
        $html .= '</div>';
        $html .= '</div>';

        wp_reset_postdata();

        return apply_filters('netbase_shortcode_services', force_balance_tags($html));
    }

}
new NB_Element_Services(); 
}