<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_List_Store_Dokan extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {

        if(function_exists('dokan_get_sellers')) {
            add_action( 'init', array( $this, 'vc_mapping' ), 12 );
            add_shortcode( 'netbase_list_store_dokan', array( $this, 'shortcode_list_store_dokan' ) );            
        }
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - List Store Dokan', 'nb-fw' ),
            'base'        => 'netbase_list_store_dokan',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display heading.', 'nb-fw' ),

            'params'      => array(
                array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Block title', 'nb-fw' ),
                        'param_name'    => 'title',
                        'admin_label'   => true,
                        'value'         => '',
                        'description'   => ''
                    ),
                array(
                        'type' => 'textfield',
                        'heading' => __( 'Per page', 'nb-fw' ),
                        'value' => 12,
                        'save_always' => true,
                        'param_name' => 'per_page',
                        'description' => __( 'The "per_page" shortcode determines how many store to show on the page', 'nb-fw' ),
                    ),

                
                array(
                        'type'          => 'dropdown',
                        'heading'       => esc_html__( 'Store type', 'nb-fw' ),
                        'param_name'    => 'store_type',
                        'admin_label'   => true,
                        'value'         => array(
                                esc_html__('Recent', 'nb-fw')       => 'recent',
                                esc_html__('Featured', 'nb-fw') => 'featured',
                                ),
                        'description'   => esc_html__( 'Select type', 'nb-fw' )
                    ),
                array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Store IDs', 'nb-fw' ),
                        'param_name'    => 'store_ids',
                        'admin_label'   => true,
                        'value'         => '',
                        'description'   => esc_html__( 'List of store IDs to query, separated by a comma.', 'nb-fw' )
                    ),
                array(
                        'type' => 'dropdown',
                        'heading' => __( 'Column', 'nb-fw' ),
                        'value' => array(
                            '1' => '1',
                            '2' => '2',
                            '3' => '3',
                            '4' => '4',
                            '5' => '5',
                            '6' => '6',
                        ),
                        'std' => '4',
                        'param_name' => 'per_row',
                        'save_always' => true,                                              
                        
                    ),
                array(
                        'type' => 'dropdown',
                        'heading' => __( 'Avatar Position', 'nb-fw' ),
                        'value'         => array(
                                esc_html__('Top', 'nb-fw')       => 'top',
                                esc_html__('Left', 'nb-fw') => 'left',
                                ),
                        'std' => 'top',
                        'param_name' => 'avatar_position',
                        'save_always' => true,                                              
                        
                    ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-fw'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),

                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 

                array(
                    'param_name' => 'rtl',
                    'heading'    => esc_html__( 'Enable RTL', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ),

                array(
                        'param_name'  => 'margin',
                        'heading'     => esc_html__( 'Margin Element', 'nb-fw' ),
                        'description' => esc_html__( 'Margin Element', 'nb-fw' ),
                        'type'        => 'textfield',
                        'value'       => 30,
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),  
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Background color', 'nb-fw' ),
                    'param_name'  => 'bgcolor_custom',
                    'value'       => '',
                    'description' => esc_html__( 'Select the background box color.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),  
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Border box color', 'nb-fw' ),
                    'param_name'  => 'bordercolor_box',
                    'value'       => '',
                    'description' => esc_html__( 'Select the background box color.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),  
                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-fw' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'nb-fw' )  => '',
                            __( '1 column', 'nb-fw' )  => '1',
                            __( '2 columns', 'nb-fw' ) => '2',
                            __( '3 columns', 'nb-fw' ) => '3',
                            __( '4 columns', 'nb-fw' ) => '4',
                            __( '5 columns', 'nb-fw' ) => '5',
                            __( '6 columns', 'nb-fw' ) => '6',
                            __( '7 columns', 'nb-fw' ) => '7',
                            __( '8 columns', 'nb-fw' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),            
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_list_store_dokan($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'             => '',
                    'store_type'        => 'recent',
                    'store_ids'          => '',
                    'per_page'          => '',
                    'per_row'           => 4,
                    'slider'            => true,
                    'margin'            => 30,
                    'avatar_position'   => 'top',
                    'bgcolor_custom'    => '',
                    'bordercolor_box'   => '',
                    'columnstablet'     =>'2',
                    'pagination'        => '',
                    'autoplay'          => '',
                    'rtl'               => ''
                ),
                $atts
            )
        );

        $id = uniqid('netbase_custom_css_');
        $classes = $attr = $classeswp = array();
        $nbcss_custom = $class_avatar='';
        $data_owlcarousel = '';
        if ( ! empty( $slider ) ) {
            if($margin){
                $attr[] = '"margin": "' . ( int ) $margin . '"';
            }
            if ( ! empty( $per_row ) ) {
                $attr[] = '"items": "' . ( int ) $per_row . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
            }

            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }

            if($autoplay){
                $attr[] = '"autoplay": "true"';
            }

            if($rtl){
                $attr[] = '"rtl": "true"';
            }

            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }
            $classeswp[] = 'nb-fw-vccarousel owl-carousel owl-loaded owl-drag';
        }

        if ( $bgcolor_custom ) {
            $nbcss_custom .= 'background:' . $bgcolor_custom . ';';
        }   
        if($bordercolor_box){
            $nbcss_custom .= ' border-color:' . $bordercolor_box . ';';
        }            
             
                
        if ( $nbcss_custom ) {
            $nbcss_custom = ' style="' . $nbcss_custom . '"';
        }

        if($avatar_position){
            $class_avatar = 'avatar-'.$avatar_position;
        }

        $per_page = absint($per_page);
        
        $paged   = max( 1, get_query_var( 'paged' ) );
        $limit   = $per_page;
        $offset  = ( $paged - 1 ) * $limit;
        
        $seller_args = array(
        'number' => $limit,
        'offset' => $offset
        );

        if ( $store_type == 'featured' ) {
        $seller_args['meta_query'][] = array(
                                        'key'     => 'dokan_feature_seller',
                                        'value'   => 'yes',
                                        'compare' => '='
                                    );
        }

        if ( trim( $store_ids ) ) {
            $seller_args['include'] = explode(',', $store_ids);
            $seller_args['orderby'] = 'include';
        }

        $sellers = dokan_get_sellers( $seller_args );
        
        ob_start();
        
        global $post;
        /*$pagination_base = str_replace( $post->ID, '%#%', esc_url( get_pagenum_link( $post->ID ) ) );*/
        $image_size = 'full';
        $search_query=  null;
        /*$template_args = array(
                'sellers'         => $sellers,
                'limit'           => $limit,
                'offset'          => $offset,
                'paged'           => $paged,
                'search_query'    => null,
                'pagination_base' => $pagination_base,
                'per_row'         => $per_row,
                'search_enabled'  => 'no',
                'image_size'      => 'full',
            );*/            
        if ( $sellers['users'] ) : ?>
                        <div class="dokan-seller-wrap <?php echo esc_attr( implode( ' ', $classeswp )); ?>" <?php echo $data_owlcarousel; ?> >
                            <?php
                            foreach ( $sellers['users'] as $seller ) {
                                $store_info = dokan_get_store_info( $seller->ID );
                                $banner_id  = isset( $store_info['banner'] ) ? $store_info['banner'] : 0;
                                $store_name = isset( $store_info['store_name'] ) ? esc_html( $store_info['store_name'] ) : __( 'N/A', 'dokan-lite' );
                                $store_url  = dokan_get_store_url( $seller->ID );
                                //$store_address  = dokan_get_seller_short_address( $seller->ID );

                                $store_address = dokan_get_seller_address( $seller->ID , true );
                                
                                $short_address = array();
                                $formatted_address = '';

                                if ( ! empty( $store_address['street_1'] ) && empty( $store_address['street_2'] ) ) {
                                    $short_address[] = $store_address['street_1'];
                                } else if ( empty( $store_address['street_1'] ) && ! empty( $store_address['street_2'] ) ) {
                                    $short_address[] = $store_address['street_2'];
                                } else if ( ! empty( $store_address['street_1'] ) && ! empty( $store_address['street_2'] ) ) {
                                    $short_address[] = $store_address['street_1'];
                                }

                                if ( ! empty( $store_address['city'] ) && ! empty( $store_address['city'] ) ) {
                                    $short_address[] = $store_address['city'];
                                }

                                if ( ! empty( $store_address['state'] ) && ! empty( $store_address['country'] ) ) {
                                    $short_address[] = $store_address['state'] . ', ' . $store_address['country'];
                                } else if ( ! empty( $store_address['country'] ) ) {
                                    $short_address[] = $store_address['country'];
                                }
                                if ( count( $short_address ) > 1 ) {
                                    $formatted_address = implode( ', ', $short_address );
                                } else {
                                    $formatted_address = implode( ' ', $short_address );
                                }

                                $seller_rating  = dokan_get_seller_rating( $seller->ID );
                                $banner_url = ( $banner_id ) ? wp_get_attachment_image_src( $banner_id, $image_size ) : DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
                                $featured_seller = get_user_meta( $seller->ID, 'dokan_feature_seller', true );
                                ?>
                                <div class="dokan-single-seller woocommerce coloum-<?php echo $per_row; ?> <?php echo ( ! $banner_id ) ? 'no-banner-img' : ''; ?>">
                                    
                                        <div class="store-content" <?php echo $nbcss_custom; ?> >
                                            <div class="seller-avatar">
                                                <?php echo get_avatar( $seller->ID, 91 ); ?>
                                            </div>
                                            <div class="store-data-container">
                                                    <div class="featured-favourite">
                                                        <?php if ( ! empty( $featured_seller ) && 'yes' == $featured_seller ): ?>
                                                            <div class="featured-label"><span><?php _e( 'Featured', 'dokan-lite' ); ?></span></div>
                                                        <?php endif ?>

                                                        <?php do_action( 'dokan_seller_listing_after_featured', $seller, $store_info ); ?>
                                                    </div>

                                                    <div class="store-data">
                                                        <div class="store-name"><a href="<?php echo $store_url; ?>"><?php echo $store_name; ?></a></div>

                                                        <?php if ( !empty( $seller_rating['count'] ) ): ?>
                                                            <div class="star-rating dokan-seller-rating" title="<?php echo sprintf( __( 'Rated %s out of 5', 'dokan-lite' ), $seller_rating['rating'] ) ?>">
                                                                <span style="width: <?php echo ( ( $seller_rating['rating']/5 ) * 100 - 1 ); ?>%">
                                                                    <strong class="rating"><?php echo $seller_rating['rating']; ?></strong> out of 5
                                                                </span>
                                                            </div>
                                                        <?php 
                                                        else:
                                                            ?>
                                                            <div class="start-rating star-o-rating" >
                                                                <i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i><i class="fa fa-star-o"></i>
                                                            </div>
                                                            <?php
                                                        endif ?>

                                                        <?php if ( $formatted_address ): ?>
                                                            <p class="store-address"><?php echo $formatted_address; ?></p>
                                                        <?php endif ?>

                                                        <?php if ( !empty( $store_info['phone'] ) ) { ?>
                                                            <p class="store-phone">
                                                                <?php echo esc_html( $store_info['phone'] ); ?>
                                                            </p>
                                                        <?php } ?>

                                                        <?php do_action( 'dokan_seller_listing_after_store_data', $seller, $store_info ); ?>

                                                    </div>
                                                    <div class="nb-fw-btn">
                                                        <a href="<?php echo $store_url; ?>" class="dokan-btn dokan-btn-theme"><?php _e( 'Visit Store', 'dokan-lite' ); ?></a>
                                                    </div>
                                                </div>
                                            
                                        </div>
                                        <?php do_action( 'dokan_seller_listing_footer_content', $seller, $store_info ); ?>                                        
                                    
                                </div>
                            <?php } ?>                            
                        </div> <!-- .dokan-seller-wrap -->                        

                    <?php else:  ?>
                        <p class="dokan-error"><?php _e( 'No vendor found!', 'dokan-lite' ); ?></p>
                    <?php endif; ?>
        <?php    

        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw list-store-dokan '.esc_attr($class_avatar).' '. esc_attr( implode( ' ', $classes ) ) .'">' . ob_get_clean() . '</div>';
        
        // End HTML code.
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_list_store_dokan', force_balance_tags($html));
    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_List_Store_Dokan(); 
}
