<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/*
Element Description: VC Heading
*/
if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Heading extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'netbase_vc_heading', array( $this, 'shortcode_heading' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - Heading', 'nb-fw' ),
            'base'        => 'netbase_vc_heading',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display heading.', 'nb-fw' ),

            'params'      => array(
                //Title
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading', 'nb-fw' ),
                    'param_name'  => 'title',
                    'value'       => '',
                    'description' => esc_html__( 'Write the title for the heading.', 'nb-fw' )
                ),               

                array(
                    'heading'    => __( 'Text Heading Center', 'nb-fw' ),
                    'param_name' => 'title_e1',
                    'type'       => 'textfield',                    
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Text Heading After', 'nb-fw' ),
                    'param_name' => 'title_e2',
                    'type'       => 'textfield',
                    
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show line before/after heading', 'nb-fw' ),
                        'param_name' => 'line_before_after',                                          
                ),
                //Title color
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading color ', 'nb-fw' ),
                    'param_name'  => 'textcolor',
                    'value'       => '',
                    'description' => esc_html__( 'Select the title color.', 'nb-fw' ),
                    'group' => esc_html__( 'Heading Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Heading tag', 'nb-fw' ),
                    'param_name'  => 'heading_size',
                    'std' =>'h4',
                    'value'       => array(
                        'h2' => 'h2',
                        'h3' => 'h3',
                        'h4' => 'h4',
                        'h5' => 'h5',
                        'h6' => 'h6',
                    ),
                    'description' => esc_html__( 'Choose heading element.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'nb-fw' ),
                ),

                //Use custom or default title?
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Use custom or default title?', 'nb-fw' ),
                    'param_name'  => 'title_custom',
                    'value'       => array(
                        __( 'Default', 'nb-fw' ) => '',
                        __( 'Custom', 'nb-fw' )  => 'custom',
                    ),
                    'description' => esc_html__( 'If you select default you will use default title which customized in typography.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Font size ', 'nb-fw' ),
                    'param_name'  => 'font_size',
                    'min'         => 0,
                    'value'       => '',
                    'suffix'      => 'px',
                    'description' => esc_html__( 'Custom title font size px.', 'nb-fw' ),
                    'std'         => '14',
                    'dependency'  => array(
                        'element' => 'title_custom',
                        'value'   => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'nb-fw' ),
                ),
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Font Weight ', 'nb-fw' ),
                    'param_name'  => 'font_weight',
                    'value'       => array(
                        __( 'Custom font weight', 'nb-fw' ) => '',
                        __( 'Normal', 'nb-fw' )             => 'normal',
                        __( 'Bold', 'nb-fw' )               => 'bold',
                        __( '100', 'nb-fw' )                => '100',
                        __( '200', 'nb-fw' )                => '200',
                        __( '300', 'nb-fw' )                => '300',
                        __( '400', 'nb-fw' )                => '400',
                        __( '500', 'nb-fw' )                => '500',
                        __( '600', 'nb-fw' )                => '600',
                        __( '700', 'nb-fw' )                => '700',
                        __( '800', 'nb-fw' )                => '800',
                        __( '900', 'nb-fw' )                => '900',
                    ),
                    'description' => esc_html__( 'Custom title font weight.', 'nb-fw' ),
                    'dependency'  => array(
                        'element' => 'title_custom',
                        'value'   => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Font style ', 'nb-fw' ),
                    'param_name'  => 'font_style',
                    'value'       => array(
                        __( 'Choose the title font style', 'nb-fw' ) => '',
                        __( 'Italic', 'nb-fw' )                      => 'italic',
                        __( 'Oblique', 'nb-fw' )                     => 'oblique',
                        __( 'Initial', 'nb-fw' )                     => 'initial',
                        __( 'Inherit', 'nb-fw' )                     => 'inherit',
                        __( 'Normal', 'nb-fw' )                      => 'normal',
                    ),
                    'description' => esc_html__( 'Custom title font style.', 'nb-fw' ),
                    'dependency'  => array(
                        'element' => 'title_custom',
                        'value'   => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Heading Settings', 'nb-fw' ),
                ),

                // Description
                array(
                    'type'        => 'textarea',
                    'heading'     => esc_html__( 'Sub heading', 'nb-fw' ),
                    'param_name'  => 'sub_heading',
                    'value'       => '',
                    'description' => esc_html__( 'Enter sub heading.', 'nb-fw' ),
                ),
                //Description color
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Sub heading color ', 'nb-fw' ),
                    'param_name'  => 'sub_heading_color',
                    'value'       => '',
                    'description' => esc_html__( 'Select the sub heading color.', 'nb-fw' ),
                ),

                //Show separator?
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Show Separator?', 'nb-fw' ),
                    'param_name'  => 'separator',
                    'value'       => array(
                            __( 'None', 'nb-fw' )     => 'none',
                            __( 'Short Line', 'nb-fw' )    => 'line',
                            __( 'Image', 'nb-fw' )    => 'image',
                        ),
                    
                    'description' => esc_html__( 'Tick it to show the separator between title and description.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    
                ),

                array(
                        'heading'     => __( 'Image Separator', 'nb-fw' ),
                        'param_name'  => 'separator_img',
                        'type'        => 'attach_image',
                        'admin_label' => true,
                        'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                        
                        'dependency'  => array(
                            'element' => 'separator',
                            'value'   => 'image'
                        ),
                    ),

                
                //Separator color
                array(
                    'type'        => 'colorpicker',
                    'heading'     => esc_html__( 'Separator color', 'nb-fw' ),
                    'param_name'  => 'separator_line_color',
                    'value'       => '',
                    'description' => esc_html__( 'Choose the separator color.', 'nb-fw' ),
                    'dependency'  => array(
                        'element' => 'separator',
                        'value'   => 'line',
                    ),
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Separator line width', 'nb-fw' ),
                    'param_name'  => 'separator_line_width',
                    'value'       => array(
                            __( '10%', 'nb-fw' )     => '10',
                            __( '20%', 'nb-fw' )    => '20',
                            __( '30%', 'nb-fw' )     => '30',
                            __( '40%', 'nb-fw' )    => '40',
                            __( '50%', 'nb-fw' )     => '50',
                            __( '60%', 'nb-fw' )    => '60',
                            __( '70%', 'nb-fw' )     => '70',
                            __( '80%', 'nb-fw' )    => '80',
                            __( '90%', 'nb-fw' )     => '90',
                            __( '100%', 'nb-fw' )    => '100',
                            
                        ),
                    'dependency'  => array(
                        'element' => 'separator',
                        'value'   => 'line',
                    ),
                    'description' => esc_html__( 'Separator line width.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    
                ),

                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Position', 'nb-fw' ),
                    'param_name'  => 'separator_position',
                    'value'       => array(
                            __( 'Top', 'nb-fw' )     => 'top',
                            __( 'Bottom', 'nb-fw' )    => 'bottom',
                            
                        ),
                    "dependency" => Array('element' => "separator", 'value' => array('image','line')),
                    'description' => esc_html__( 'Position.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    
                ),
                
                //Alignment
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text alignment', 'nb-fw' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Text at left', 'nb-fw' )   => 'text-left',
                        __( 'Text at center', 'nb-fw' ) => 'text-center',
                        __( 'Text at right', 'nb-fw' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),
                //Animation
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Animation', 'nb-fw' ),
                    'param_name'  => 'css_animation',
                    'admin_label' => true,
                    'value'       => array(
                        __( 'No', 'nb-fw' )                 => '',
                        __( 'Top to bottom', 'nb-fw' )      => 'top-to-bottom',
                        __( 'Bottom to top', 'nb-fw' )      => 'bottom-to-top',
                        __( 'Left to right', 'nb-fw' )      => 'left-to-right',
                        __( 'Right to left', 'nb-fw' )      => 'right-to-left',
                        __( 'Appear from center', 'nb-fw' ) => 'appear'
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'nb-fw' )
                ),

                array(
                    'heading'    => __( 'Extra class name', 'nb-fw' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-fw' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                )
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_heading($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'             => '',
                    'line_before_after' => '',
                    'title_e1' => '',
                    'title_e2' => '',
                    'heading_size'              => 'h4',
                    'textcolor'         => '',
                    'font_size'         => '',
                    'font_weight'       => '',
                    'font_style'        => '',
                    'title_custom'      => '',
                    'sub_heading'       => '',
                    'sub_heading_color' => '',
                    'line'              => '',
                    'bg_line'           => '',
                    'css_animation'     => '',
                    'text_align'        => '',
                    'separator' => 'none',
                    'separator_position' =>'bottom',
                    'separator_img' => '',
                    'separator_line_color' =>'#e1e1e1',
                    'css' => '',
                    'separator_line_width' =>'60'
                ),
                $atts
            )
        );
        
        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        $css_class = $edusite_animation = $sub_heading_css = $html = $css_a = $line = $line_css = '';
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_vc_heading', $atts );   
        
        
        $classes = array();
        if($line_before_after){
            $classes[] = 'line_before_after';
        }
        
        if ( $textcolor ) {
            $css_a .= 'color:' . $textcolor . ';';
        }
                
        if ( $title_custom == 'custom' ) {
            if ( $font_size != '' ) {
                $css_a .= 'font-size:' . $font_size . 'px;';
            }
            if ( $font_weight != '' ) {
                $css_a .= 'font-weight:' . $font_weight . ';';
            }
            if ( $font_style != '' ) {
                $css_a .= 'font-style:' . $font_style . ';';
            }
        }        
                
        if ( $css_a ) {
            $css_a = ' style="' . $css_a . '"';
        }        

        if($sub_heading_color) {
            $sub_heading_css = 'color:' . $sub_heading_color . ';';
        }

        if($separator_line_color){
            $edusiteseparator_line_color = ' style="border-color:' .$separator_line_color.'"';
        }
        
        if($line && $line <> ''){
            if ( $bg_line ) {
                $line_css = ' style="background-color:' . $bg_line . '"';
            }
            $line = '<span' . $line_css . ' class="line"></span>';
        }
        $src = wp_get_attachment_image_src($separator_img);       
       
        if($text_align && $text_align <> ''){
            $text_align = $text_align;
        }else{
             $text_align = '';
        }

        // Generate HTML code.
        $html .= '<div id="' . esc_attr($id) . '" class="'.esc_attr( $css_class ).' nb-fw heading '. esc_attr( implode( ' ', $classes ) ) .'">';
        $html .= '<div class="nbfw_heading headline-container '.$text_align.'" >';
        $html .= '<' . $heading_size . $css_a . ' class="title">' . $title ;
        if($title_e1){
            $html .='<span class="color-green"> '.$title_e1.'</span>';
        }
        if($title_e2){
            $html .=' '.$title_e2;
        }
        $html .='</' . $heading_size . '>';
        if($sub_heading ){
        $html .= '<p class="sub-heading" style="'.$sub_heading_css.'">'.$sub_heading.'</p>';
        }
        $html .= $line;
        if($separator=='image'){
            $html .= '<img src="' . esc_url( $src[0] ) . '" alt="Separator" />';
        }
        elseif($separator=='line'){
            $html .='<div class="headline-separator vc_sep_width_'.$separator_line_width.'" '.$edusiteseparator_line_color.'></div>';
        }
        $html .= '</div>';
        $html .= '</div>';
        // End HTML code.

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_heading', force_balance_tags($html));
    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Heading(); 
}
