<?php
/**
 * @version    1.0.0
 * @package    Netbase_Toolkit
 * @author     NetbaseTeam
 * @copyright  Copyright (C) 2017 netbaseteam.com. All Rights Reserved.
 * @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Websites: http://www.netbaseteam.com
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
class NB_Element_Countdown extends WPBakeryShortCode {
    /**
     * Initialize.
     *
     * @return  void
     */

    // Element Init
    function __construct() {
        if (class_exists('Vc_Manager')) {
            add_action('init', array( $this,  'map'), 12);
        }
        // Add shortcode
        add_shortcode('netbase_countdown', array( $this,  'shortcode_countdown'));
    } 

    

    /**
     * Map new parameters and elements.
     *
     * @since  1.0
     * @see    https://wpbakery.atlassian.net/wiki/pages/viewpage.action?pageId=524332
     */
    public function map()
    {
        vc_map( array(
            'name'        => esc_html__( 'NB - Countdown Box', 'nb-fw' ),
            'base'        => 'netbase_countdown',
            'category'    => esc_html__( 'Netbase Elements', 'nb-fw' ),
            'description' => esc_html__( 'Display Countdown Box.', 'nb-fw' ),
            'icon' => 'edoo-widget-icon',
            'params'      => array(               
                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Days', 'nb-fw' ),
                    'param_name'  => 'text_days',
                    'std'         => esc_html__( 'days', 'nb-fw' ),
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Hours', 'nb-fw' ),
                    'param_name'  => 'text_hours',
                    'std'         => esc_html__( 'hours', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Minutes', 'nb-fw' ),
                    'param_name'  => 'text_minutes',
                    'std'         => esc_html__( 'minutes', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text Seconds', 'nb-fw' ),
                    'param_name'  => 'text_seconds',
                    'std'         => esc_html__( 'seconds', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Year', 'nb-fw' ),
                    'param_name'  => 'time_year',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Month', 'nb-fw' ),
                    'param_name'  => 'time_month',
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Day', 'nb-fw' ),
                    'param_name'  => 'time_day',
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Hour', 'nb-fw' ),
                    'param_name'  => 'time_hour',
                    'edit_field_class' => 'vc_col-xs-4 mgt20 vc_column',
                ),

                array(
                    'type' => 'dropdown',
                    'heading' => __( 'Style color', 'nb-fw' ),
                    'param_name' => 'style_color',
                    'value' => array_merge( getVcShared( 'colors' ) ),
                    'description' => __( 'Select style color.', 'nb-fw' ),
                    'param_holder_class' => 'vc_colored-dropdown',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),
                /*array(
                    'type' => 'colorpicker',
                    'heading' => __( 'Custom color', 'nb-fw' ),
                    'param_name' => 'custom_color',
                    'description' => __( 'Select custom icon color.', 'nb-fw' ),
                    'dependency' => array(
                        'element' => 'style_color',
                        'value' => 'custom',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),*/
                array(
                    'type'        => 'dropdown',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text alignment', 'nb-fw' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        esc_html__( 'Select', 'nb-fw' )         => '',
                        esc_html__( 'Text at left', 'nb-fw' )   => 'text-left',
                        esc_html__( 'Text at center', 'nb-fw' ) => 'text-center',
                        esc_html__( 'Text at right', 'nb-fw' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'group' => esc_html__( 'Text Settings', 'nb-fw' ),
                ),

                array(
                    'heading'    => __( 'Extra class name', 'nb-fw' ),
                    'param_name' => 'extra_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom id name', 'nb-fw' ),
                    'param_name' => 'custom_id',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a id name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                ),
                
            )
        ) );
    }

    /**
     * Add shortcode toolkit.
     *
     * @since  1.0
     */
    public static function shortcode_countdown($atts, $content = null)
    {
        $html = $attr_parent = $css_class = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'text_days'    => esc_html__( 'days', 'nb-fw' ),
                    'text_hours'   => esc_html__( 'hours', 'nb-fw' ),
                    'text_minutes' => esc_html__( 'minutes', 'nb-fw' ),
                    'text_seconds' => esc_html__( 'seconds', 'nb-fw' ),
                    'time_year'    => '',
                    'time_month'   => '',
                    'time_day'     => '',
                    'time_hour'    => '',
                    'style_color'  => '',
                    'text_align'   => '',     
                    'css' => '',               
                ),
                $atts
            )
        );

        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_countdown', $atts );   

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        $classes = array();
        if($style_color){
            $classes[] =' countdown-'.$style_color.' ';
        }

        $text_days    = ( isset( $text_days ) && '' != $text_days ) ? $text_days : 'days';
        $text_hours   = ( isset( $text_hours ) && '' != $text_hours ) ? $text_hours : 'hours';
        $text_minutes = ( isset( $text_minutes ) && '' != $text_minutes ) ? $text_minutes : 'minutes';
        $text_seconds = ( isset( $text_seconds ) && '' != $text_seconds ) ? $text_seconds : 'seconds';
  
        $year = ( (int) ( $time_year ) != '' ) ? (int) ( $time_year ) : date( "Y", time() );
        $month = ( (int) ( $time_month ) != '' ) ? (int) ( $time_month ) : date( "m", time() );
        $day = ( (int) ( $time_day ) != '' ) ? (int) ( $time_day ) : date( "d", time() );
        
        /*if ( $time_hour != '' ) {*/
        $hour = ( (int) ( $time_hour ) != '' ) ? (int) ( $time_hour ) : date( "G", time() );
        /*}*/
        ob_start();
        // Generate HTML code.
        $datetime = date( ent2ncr($year. '/'. $month  .'/' . $day  ));

        echo '<div id="nbfw-countdown' . $id . '"></div>';
        ?>
        
        <!-- Setup countdown -->
        <script type="text/javascript">
        jQuery(function () {
            jQuery(document).ready(function () {
                jQuery("#nbfw-countdown<?php echo esc_js($id); ?>").mbComingsoon({
                    expiryDate  : new Date(<?php echo ent2ncr($year. ','. ( $month - 1 ) .',' . $day . ',' . $hour ); ?>),
                    localization: {
                        days   : "<?php echo esc_js($text_days); ?>",
                        hours  : "<?php echo esc_js($text_hours); ?>",
                        minutes: "<?php echo esc_js($text_minutes); ?>",
                        seconds: "<?php echo esc_js($text_seconds); ?>"
                    },
                    speed       : 100
                });
                setTimeout(function () {
                    jQuery(window).resize();
                }, 200);
            });
        });
        </script>

        <?php
        
        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw countdown-box '.esc_attr( $css_class ).' '. esc_attr( implode( ' ', $classes ) ) .'">' . ob_get_clean() . '</div>';
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_countdown', force_balance_tags($html));
    }
    
}

new NB_Element_Countdown(); 
}