<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Category_Images extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'netbase_category_image', array( $this, 'shortcode_category_image' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }


        if ( class_exists( 'WooCommerce' ) ) {
            $args = array(
                    'type' => 'post',
                    'child_of' => 0,
                    'parent' => '',
                    'orderby' => 'parent',
                    'order' => 'ASC',
                    'hide_empty' => false,
                    'hierarchical' => 1,
                    'exclude' => '',
                    'include' => '',
                    'number' => '',
                    'taxonomy' => 'product_cat',
                    'pad_counts' => false,
            );
            $categories = get_categories( $args );
            $product_categories_dropdown[] = array(
                    'label' => 'All categories',
                    'value' => '',
            );
            $this->getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
                
            $attributes_tax = wc_get_attribute_taxonomies();
            $attributes = array();
            foreach ( $attributes_tax as $attribute ) {
                $attributes[ $attribute->attribute_label ] = $attribute->attribute_name;
            }
        }

         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - Product Category Image', 'nb-fw' ),
            'base'        => 'netbase_category_image',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display Category Image.', 'nb-fw' ),

            'params'      => array(
                array(
                    'heading'     => __( 'Image', 'nb-fw' ),
                    'param_name'  => 'category_img',
                    'type'        => 'attach_image',
                ),

                array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Category', 'nb-fw' ),
                'value' => $product_categories_dropdown,
                'param_name' => 'category_id',
                'admin_label'   => true,
                'save_always' => true,
                'description' => esc_html__( 'Choose category when click to image', 'nb-fw' ),

                ),

                array(
                        'type' => 'dropdown',
                        'heading' => __( 'Custom text and link', 'nb-fw' ),
                        'param_name' => 'custom_text_n_link',
                        'value'       => array(
                            __( 'No', 'nb-fw' )   => 0,
                            __( 'Yes', 'nb-fw' ) => 1
                        ),
                ),

                array(
                    'heading'    => __( 'Custom Text', 'nb-fw' ),
                    'param_name' => 'custom_title',
                    'type'       => 'textfield',
                    'description'=> 'Enter text to display on category image',
                    // 'dependency' => array(
                    //     'element' => 'custom_text_n_link',
                    //     'value'   => 1,
                    // ), 
                ),

                array(
                    'heading'    => __( 'Custom Link', 'nb-fw' ),
                    'param_name' => 'custom_link',
                    'type'       => 'textfield',
                    'description'=> 'Enter link when click to category image. Ignore this field if you want to use category link',
                    // 'dependency' => array(
                    //     'element' => 'custom_text_n_link',
                    //     'value'   => 1,
                    // ), 
                ),
                array(
                    'heading'    => __( 'Custom Class', 'nb-fw' ),
                    'param_name' => 'custom_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',                    
                ),
            )
        ) );                               
        
    }

    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {
        for ( $i = $pos; $i < count( $array ); $i ++ ) {
            if ( $array[ $i ]->category_parent == $parent_id ) {
                $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                $value = $array[ $i ]->slug;
                $dropdown[] = array(
                    'label' => $name,
                    'value' => $value,
                );
                $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
            }
        }
    }      
     
    // Element HTML
    public function shortcode_category_image($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'category_img'      => '',
                    'category_id'       => '',
                    'custom_text_n_link'=> 0,
                    'custom_title'      => '',
                    'custom_link'       => '',
                    'custom_class'      => '',
                ),
                $atts
            )
        );

        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        
        $html = $cat_name = $link = '';
        
        
        $src = wp_get_attachment_image_src($category_img,'full');

        if( ! $custom_text_n_link ) {

            if($category_id != '') {

                $term = get_term_by( 'slug', $category_id, 'product_cat' );

                $link = is_object($term) ? get_term_link( $term ) : '';

                $cat_name =  is_object($term) ? $term->name : '';
            }
            else {

                $link = site_url( '/shop');

                $cat_name = esc_html__('All collections', 'nb-fw');
            }
        }
        else {

            $cat_name   =  $custom_title;

            if($custom_link == '') {
                if($category_id != '') {

                    $term = get_term_by( 'slug', $category_id, 'product_cat' );

                    $link = is_object($term) ? get_term_link( $term ) : '';

                }
                else {

                    $link = site_url( '/shop');
                }
            }
            else {
                $link =  $custom_link;
            }
        }


        // Generate HTML code.
        $html .= '  <div id="' . esc_attr($id) . '" class="nbfw_category-img-container '.$custom_class.'">
                        <div class="category-img-item">
                            <a href="' . esc_url($link) . '">
                                <img src="' . esc_url( $src[0] ) . '" alt="' . $cat_name . '" />
                                <span class="cat-text">' . $cat_name . '</span>
                            </a>
                        </div>
                    </div>';
        // End HTML code.
        
        
        // End HTML code.
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_category_image', force_balance_tags($html));
    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Category_Images(); 
}
