<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Category_Icon extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'netbase_category_icon', array( $this, 'shortcode_category_icon' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
        if ( class_exists( 'WooCommerce' ) ) {
            $args = array(
                    'type' => 'post',
                    'child_of' => 0,
                    'parent' => '',
                    'orderby' => 'parent',
                    'order' => 'ASC',
                    'hide_empty' => false,
                    'hierarchical' => 1,
                    'exclude' => '',
                    'include' => '',
                    'number' => '',
                    'taxonomy' => 'product_cat',
                    'pad_counts' => false,
            );
            $categories = get_categories( $args );
            $product_categories_dropdown[] = array(
                    'label' => 'All categories',
                    'value' => '',
            );
            $this->getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
                
            $attributes_tax = wc_get_attribute_taxonomies();
            $attributes = array();
            foreach ( $attributes_tax as $attribute ) {
                $attributes[ $attribute->attribute_label ] = $attribute->attribute_name;
            }
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - List Category Icon', 'nb-fw' ),
            'base'        => 'netbase_category_icon',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display heading.', 'nb-fw' ),
            'params'      => array(
                array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Block title', 'nb-fw' ),
                        'param_name'    => 'title',
                        'admin_label'   => true,
                        'value'         => '',
                        'description'   => ''
                    ),

                array(
                        'heading'    => esc_html__( 'Category Product', 'nb-fw' ),
                        'type'       => 'param_group',
                        'param_name' => 'category_product',
                        'params'     => array(
                            array(
                            'type' => 'dropdown',
                            'heading' => esc_html__( 'Category', 'nb-fw' ),
                            'value' => $product_categories_dropdown,
                            'param_name' => 'category',
                            'admin_label'   => true,
                            'save_always' => true,
                            'description' => esc_html__( 'Product category list', 'nb-fw' ),

                            ),
                            array(
                                'param_name' => 'custom_name_cat',
                                'heading'    => esc_html__( 'Custom Name Category', 'nb-fw' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                    'param_name'       => 'style',
                                    'heading'          => esc_html__( 'Style', 'nb-fw' ),
                                    'type'             => 'dropdown',
                                    'edit_field_class' => 'vc_col-sm-6 mgt15',                        
                                    'value'            => array(                            
                                        __( 'None', 'nb-fw' )      => 'none',
                                        __( 'Icon', 'nb-fw' )      => 'icon',
                                        __( 'Image', 'nb-fw' )     => 'image',
                                    ),
                            ),
                            array(
                                'param_name'  => 'icon_fontawesome',
                                'heading'     => esc_html__( 'Icon', 'nb-fw' ),
                                'description' => esc_html__( 'Select icon from library.', 'nb-fw' ),
                                'type'        => 'iconpicker',
                                'group'       => esc_html__( 'Icon Settings', 'nb-fw' ),
                                'value'       => 'fa fa-adjust',
                                'settings'    => array(
                                    'emptyIcon'    => false,
                                    'iconsPerPage' => 4000,
                                ),
                                'dependency'  => array(
                                    'element' => 'style',
                                    'value'   => 'icon',
                                ),
                            ),
                            array(
                                'param_name' => 'graphic',
                                'heading'    => esc_html__( 'Image Icon', 'nb-fw' ),
                                'type'       => 'attach_image',
                                'dependency'  => array(
                                    'element' => 'style',
                                    'value'   => 'image',
                                ),
                            ),
                        ),
                    ),
                
                array(
                        'type' => 'dropdown',
                        'heading' => __('Item Align', 'nb-fw'),
                        'param_name' => 'item_align',                        
                        'value' => array(
                                'Center' => 'text-center',
                                'Right' => 'text-right',
                                'Left' => 'text-left',
                                
                        ),
                        'std' => 'text-center',
                        'save_always' => true,                            
                ),      

                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-fw'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),        
                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'edoo' ),
                        'type'       => 'checkbox',                                                
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),
                array(
                    'param_name' => 'rtl',
                    'heading'    => esc_html__( 'Enable RTL', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ),
                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'nb-fw' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'nb-fw' )  => '1',
                            __( '2 columns', 'nb-fw' ) => '2',
                            __( '3 columns', 'nb-fw' ) => '3',
                            __( '4 columns', 'nb-fw' ) => '4',
                            __( '5 columns', 'nb-fw' ) => '5',
                            __( '6 columns', 'nb-fw' ) => '6',
                            __( '7 columns', 'nb-fw' ) => '7',
                            __( '8 columns', 'nb-fw' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-fw' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'nb-fw' )  => '',
                            __( '1 column', 'nb-fw' )  => '1',
                            __( '2 columns', 'nb-fw' ) => '2',
                            __( '3 columns', 'nb-fw' ) => '3',
                            __( '4 columns', 'nb-fw' ) => '4',
                            __( '5 columns', 'nb-fw' ) => '5',
                            __( '6 columns', 'nb-fw' ) => '6',
                            __( '7 columns', 'nb-fw' ) => '7',
                            __( '8 columns', 'nb-fw' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),       
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                )   
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_category_icon($atts, $content = null)
    {
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'         => '',                    
                    'category' => '',
                    'custom_name_cat' => '',
                    'item_align' => 'text-center',
                    'category_product'  => '',
                    'category'          => '',
                    'style'             => '',
                    'icon_fontawesome'  => '',
                    'graphic'           => '',
                    /*'enable_multi_row'  => false,*/
                    'slider'            => true,
                    'navigation'   => '',
                    'pagination'   => '',
                    'columns' => '3',                  
                    'columnstablet' =>'', 
                    'css' => '',
                    'rtl'               => ''
                ),
                $atts
            )
        );

        $id = uniqid('netbase_custom_css_');
        $classes = array();
        $catvalues = ( array ) vc_param_group_parse_atts( $category_product );
        
        $data_owlcarousel = $css_class = '';
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_category_icon', $atts ); 
        $classesc  = $attr = array();

        if ( ! empty( $slider ) ) {
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }
            
            if ( $navigation ) {
                $attr[] = '"nav": "true"';
            }

            if($rtl){
                $attr[] = '"rtl": "true"';
            }
            
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }            

            $classesc[] = 'nb-fw-vccarousel owl-carousel owl-loaded owl-drag';
        }                
        
        if($item_align){
             $classes[] = $item_align;
        }               

        ob_start(); 
        
        foreach ( $catvalues as $key => $catvalue ) {
        ?>
                    <div class="cat-item <?php echo esc_attr( implode( ' ', $classes ) ) ; ?>">                        
                            <?php
                            $idObj1= get_term_by('slug', $catvalue[ 'category' ], 'product_cat'); 
                            
                            if ( $idObj1 instanceof WP_Term ) {
                                $catid=$idObj1->term_id;
                                $category_link = get_term_link( $catid);                                
                                echo '<a href="'.$category_link.'">';
                                    echo '<div class="cat-item-icon">';
                                        if ( 'icon' == $catvalue['style'] ) {            
                                            echo '<i class="' . esc_attr( $catvalue['icon_fontawesome'] ) .'" ></i>';
                                        }
                                        else if ( 'image' == $catvalue['style'] )
                                        {
                                            if ( ! empty( $catvalue['graphic'] ) ) {
                                                    // Get image link and image data
                                                $image = wpb_getImageBySize( array( 'attach_id' => preg_replace( '/[^\d]/', '', $catvalue['graphic'] ) ) );

                                                echo '<div class="image-icon"><img src="' . esc_url( $image['p_img_large'][0] ) . '" alt="' . esc_attr__( 'image-icon', 'nb-fw' ) . '" width="' . esc_attr( $image['p_img_large'][1] ) . '" height="' . esc_attr( $image['p_img_large'][2] ) . '" /></div>';
                                            }
                                        }
                                    echo '</div>';
                                    
                                    if( isset($catvalue[ 'custom_name_cat']) && $catvalue[ 'custom_name_cat'] !=''){
                                        echo $catvalue[ 'custom_name_cat'];
                                    }else{
                                        echo $idObj1->name;    
                                    }
                                    
                                echo '</a>';
                            }else{
                                echo esc_html__( 'All Products', 'nb-fw' );
                            }
                        ?>
                    </div><?php
                }       

        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw cat-icon '. esc_attr( implode( ' ', $classesc ) ) .' '.esc_attr( $css_class ).'" '.$data_owlcarousel.'>' . ob_get_clean() . '</div>';
        
        // End HTML code.
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_category_icon', force_balance_tags($html));
    }
    
    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {
            for ( $i = $pos; $i < count( $array ); $i ++ ) {
                if ( $array[ $i ]->category_parent == $parent_id ) {
                    $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                    $value = $array[ $i ]->slug;
                    $dropdown[] = array(
                        'label' => $name,
                        'value' => $value,
                    );
                    $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
                }
            }
        }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Category_Icon(); 
}
