<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Brands_List extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'netbase_brands_list', array( $this, 'shortcode_brands_list' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }        
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - List Brands', 'nb-fw' ),
            'base'        => 'netbase_brands_list',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display List Brands.', 'nb-fw' ),

            'params'      => array(
                array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Block title', 'nb-fw' ),
                        'param_name'    => 'title',
                        'admin_label'   => true,
                        'value'         => '',
                        'description'   => ''
                    ),

               
                array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Show Per page', 'nb-fw' ),
                        'value' => 12,
                        'save_always' => true,
                        'admin_label'   => true,
                        'param_name' => 'per_page',
                        'description' => esc_html__( 'How many brand to show on the page', 'nb-fw' ),
                    ),                
                
                array(
                        'type' => 'dropdown',
                        'heading' => __('Item Align', 'nb-fw'),
                        'param_name' => 'item_align',                        
                        'value' => array(
                                'Center' => 'text-center',
                                'Right' => 'text-right',
                                'Left' => 'text-left',
                                
                        ),
                        'std' => 'text-center',
                        'save_always' => true,                            
                ), 

                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-fw'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ),        
                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'edoo' ),
                        'type'       => 'checkbox',                                                
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                
                array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                        'param_name' => 'loop',
                        'heading'    => esc_html__( 'Enable Loop', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),
                array(
                    'param_name' => 'rtl',
                    'heading'    => esc_html__( 'Enable RTL', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ),         

                array(
                        'param_name'  => 'columns',
                        'heading'     => esc_html__( 'Number of columns displayed', 'nb-fw' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( '1 column', 'nb-fw' )  => '1',
                            __( '2 columns', 'nb-fw' ) => '2',
                            __( '3 columns', 'nb-fw' ) => '3',
                            __( '4 columns', 'nb-fw' ) => '4',
                            __( '5 columns', 'nb-fw' ) => '5',
                            __( '6 columns', 'nb-fw' ) => '6',
                            __( '7 columns', 'nb-fw' ) => '7',
                            __( '8 columns', 'nb-fw' ) => '8',
                        ),
                        'std'         => '3',
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),

                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-fw' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'nb-fw' )  => '',
                            __( '1 column', 'nb-fw' )  => '1',
                            __( '2 columns', 'nb-fw' ) => '2',
                            __( '3 columns', 'nb-fw' ) => '3',
                            __( '4 columns', 'nb-fw' ) => '4',
                            __( '5 columns', 'nb-fw' ) => '5',
                            __( '6 columns', 'nb-fw' ) => '6',
                            __( '7 columns', 'nb-fw' ) => '7',
                            __( '8 columns', 'nb-fw' ) => '8',
                        ),                     
                        'std'         => '',   
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Border image brand', 'nb-fw'),
                    'param_name' => 'border_img',
                    'std' => true,                    
                ),  
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                ),
               
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_brands_list($atts, $content = null)
    {
        global $woocommerce;
        $html = $attr_parent = '';

        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'title'         => '',                    
                    'per_page'  => '',
                    'item_align' => 'text-center',
                    'navigation'   => '',
                    'slider'                => true,
                    'pagination'   => '',
                    'autoplay'     => '',
                    'loop'         => '',                     
                    'columns' => '3',                  
                    'columnstablet' =>'', 
                    'border_img' => true,
                    'css' => '',
                    'rtl'               => ''
                ),
                $atts
            )
        );

        $id = uniqid('netbase_custom_css_');
        $classes = array();
        $css_class = '';
        $classesc  = $attr = array();

        if ( ! empty( $slider ) ) {
            if ( ! empty( $columns ) ) {
                $attr[] = '"items": "' . ( int ) $columns . '"';
            }
            if ( ! empty( $columnstablet ) ) {
                $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
            }
            if ( $pagination ) {
                $attr[] = '"dots": "true"';
            }
            if($autoplay){
                $attr[] = '"autoplay": "true"';
            }
            if($loop){
                $attr[] = '"loop": "true"';
            }
            if ( $navigation ) {
                $attr[] = '"nav": "true"';
            }
            if($rtl){
                $attr[] = '"rtl": "true"';
            }
            if ( ! empty( $attr ) ) {
                $data_owlcarousel = 'data-owl-options=\'{' . esc_attr( implode( ', ', $attr ) ) . '}\'';
            }            

            $classesc[] = 'nb-fw-vccarousel owl-carousel owl-loaded owl-drag';
        }
        if ( ! empty( $border_img ) ) {
            $classesc[] = ' border-img';
        }
        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_brands_list', $atts ); 

        $per_page = absint($per_page);        
        $ipage=0;                 

        $terms = get_terms( array(
                'taxonomy' => 'nbproduct_brand',
                'hide_empty' => false,
            ) );  
        ob_start();
        if($terms){           

            foreach ($terms as $key => $term) {

                $brands_thumbnail = get_term_meta( $term->term_id, 'brands_thumbnail', true );
                    $brands_thumbnail = wp_get_attachment_image_src($brands_thumbnail);

                    $brands_target = get_term_meta( $term->term_id, 'brands_target', true );
                    $brands_type = get_term_meta( $term->term_id, 'brands_type', true );
                    $brands_link  = get_term_link($term, 'nbproduct_brand');
                    if($brands_type == 'url'){
                        $brands_link = get_term_meta( $term->term_id, 'brands_url', true );
                    }   
                ?>
                        <div class="brand-item">
                            <a href="<?php echo $brands_link;?>" target="<?php echo $brands_target;?>"><img src="<?php echo $brands_thumbnail[0];?>" class="img1" alt="<?php echo $term->name;?>" width="200" height="154"></a>                            
                        </div>
                <?php
            }
        }                   

        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw brands-list '. esc_attr( implode( ' ', $classesc ) ) .' '.esc_attr( $css_class ).'"  '.$data_owlcarousel.'>' . ob_get_clean() . '</div>';
        
        // End HTML code.
        wp_reset_postdata();
        return apply_filters('netbase_shortcode_brands_list', force_balance_tags($html));
    }
   
    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {
            for ( $i = $pos; $i < count( $array ); $i ++ ) {
                if ( $array[ $i ]->category_parent == $parent_id ) {
                    $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                    $value = $array[ $i ]->slug;
                    $dropdown[] = array(
                        'label' => $name,
                        'value' => $value,
                    );
                    $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
                }
            }
        }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Brands_List(); 
}
