<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Banner extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'netbase_vc_banner', array( $this, 'shortcode_banner' ) );
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - Banner', 'nb-fw' ),
            'base'        => 'netbase_vc_banner',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display Banner.', 'nb-fw' ),

            'params'      => array(
                //Title
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Primary Text', 'nb-fw' ),
                    'param_name'  => 'txt_primary',
                    'value'       => '',
                    'description' => esc_html__( 'Write the title.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ), 

                array(
                    'heading'    => __( 'Text Primary Color Custom', 'nb-fw' ),
                    'param_name' => 'title_e1',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text color custom ', 'nb-fw' ),
                    'param_name'  => 'textcolor_custom',
                    'value'       => '',
                    'description' => esc_html__( 'Select the title color.', 'nb-fw' ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    
                ),  
                array(
                    'heading'    => __( 'Text Primary After', 'nb-fw' ),
                    'param_name' => 'title_e2',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                        'heading'     => __( 'Image', 'nb-fw' ),
                        'param_name'  => 'banner_img',
                        'type'        => 'attach_image',
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show Image as background', 'nb-fw' ),
                        'param_name' => 'show_img_as_background',                                          
                ),

                array(
                    'heading'    => __( 'Caption text', 'nb-fw' ),
                    'param_name' => 'txt_caption',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Show divider', 'nb-fw' ),
                        'param_name' => 'show_caption_divider',                                          
                ),
                array(
                    'type'        => 'textarea',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Description', 'nb-fw' ),
                    'param_name'  => 'description',
                    'value'       => '',
                    'description' => esc_html__( 'Write the title for the heading.', 'nb-fw' )
                ), 
                array(
                    'heading'    => __( 'Button Text', 'nb-fw' ),
                    'param_name' => 'txt_button',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Url', 'nb-fw' ),
                    'param_name' => 'button_url',
                    'type'       => 'textfield',                    
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Alt text', 'nb-fw' ),
                    'param_name' => 'txt_alt',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                
                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Add link to Title', 'nb-fw' ),
                        'param_name' => 'link_to_title',                                          
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Background', 'nb-fw' ),
                        'param_name' => 'text_info_bg',                                          
                ),

                array(
                        'type' => 'checkbox',
                        'heading' => __( 'Text info Box Circle', 'nb-fw' ),
                        'param_name' => 'text_info_circle',                                          
                ),

                //Alignment
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Text alignment', 'nb-fw' ),
                    'param_name'  => 'text_align',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Text at left', 'nb-fw' )   => 'text-left',
                        __( 'Text at center', 'nb-fw' ) => 'text-center',
                        __( 'Text at right', 'nb-fw' )  => 'text-right',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),

                //Alignment
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Text alignment', 'nb-fw' ),
                    'param_name'  => 'text_position',
                    'value'       => array(
                        'Choose the text alignment'     => '',
                        __( 'Top left', 'nb-fw' )   => 'top-left',
                        __( 'Top Right', 'nb-fw' )   => 'top-right',
                        __( 'Center Center', 'nb-fw' ) => 'center-center',
                        __( 'Center Left', 'nb-fw' )  => 'center-left',
                        __( 'Center Right', 'nb-fw' )  => 'center-right',
                        __( 'Bottom Center', 'nb-fw' )  => 'bottom-center',
                    ),
                    'edit_field_class' => 'vc_col-xs-12 mgt20 vc_column',
                ),
                array(
                    'type'        => 'dropdown',                    
                    'heading'     => esc_html__( 'Effect Image', 'nb-fw' ),
                    'param_name'  => 'effect_img',
                    'value'       => array(
                        'Choose the effect'     => '',
                        __( 'Effect Zoom', 'nb-fw' )   => 'effect-zoom',
                        __( 'Effect 1', 'nb-fw' ) => 'effect-1',
                        __( 'Effect 3', 'nb-fw' ) => 'effect-3',
                        __( 'Effect 5', 'nb-fw' ) => 'effect-5',
                        
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                ),
                array(
                    'heading'    => __( 'Custom Class', 'nb-fw' ),
                    'param_name' => 'custom_class',
                    'type'       => 'textfield',
                    'description'=> 'Style particular content element differently - add a class name and refer to it in custom CSS.',  
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                  
                ),

                //Animation
                array(
                    'type'        => 'dropdown',
                    'heading'     => esc_html__( 'Animation', 'nb-fw' ),
                    'param_name'  => 'css_animation',                    
                    'value'       => array(
                        __( 'No', 'nb-fw' )                 => '',
                        __( 'Top to bottom', 'nb-fw' )      => 'top-to-bottom',
                        __( 'Bottom to top', 'nb-fw' )      => 'bottom-to-top',
                        __( 'Left to right', 'nb-fw' )      => 'left-to-right',
                        __( 'Right to left', 'nb-fw' )      => 'right-to-left',
                        __( 'Appear from center', 'nb-fw' ) => 'appear'
                    ),
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',
                    'description' => esc_html__( 'Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.', 'nb-fw' )
                ),                
                
                array(
                    'type' => 'css_editor',
                    'heading' => __( 'Css', 'nb-fw' ),
                    'param_name' => 'css',
                    'group' => __( 'Design options', 'nb-fw' ),
                )
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_banner($atts, $content = null)
    {
        $html = $attr_parent = '';
        $custom_class ='';
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'txt_primary' => '',
                    'txt_caption' => '',
                    'description' => '',
                    'txt_button' => '',
                    'button_url' => '',
                    'txt_alt' => '',
                    'link_to_title' => '',
                    'show_caption_divider' => '',
                    'show_img_as_background' => '',
                    'text_info_bg' =>'',
                    'text_info_circle' => '',
                    'text_align' => 'text-left',
                    'text_position'=>'',
                    'css_animation' => '',
                    'title_e1' => '',
                    'title_e2' => '',
                    'textcolor_custom'         => '',
                    'custom_class' => '',
                    'effect_img' => '',
                    'css' => '',    
                    'banner_img' => '',                   
                    
                ),
                $atts
            )
        );
        
        // Generate custom ID
        $id = uniqid('netbase_custom_css_');
        
        $css_class = $edusite_animation = $sub_heading_css = $html = $nbcss_custom = $line = $line_css = '';
        $classes = array();

        $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'netbase_vc_banner', $atts ); 
        
        if ( $textcolor_custom ) {
            $nbcss_custom .= 'color:' . $textcolor_custom . ';';
        }               
             
                
        if ( $nbcss_custom ) {
            $nbcss_custom = ' style="' . $nbcss_custom . '"';
        }
        if(isset($text_info_bg)){
            if($text_info_bg){
                $classes[] ='bg-white';
            }  
        }
        if($text_info_circle){
            $classes[] ='box-circle';
        }
        
        $src = wp_get_attachment_image_src($banner_img,'full');       
       
        if($text_align && $text_align <> ''){
            $text_align = $text_align;
        }else{
             $text_align = '';
        }

        if($text_position){
            $text_position = 'p-'.$text_position;
        }else{
            $text_position='';
        }


        $bg_image_style =  $show_img_as_background ? "style='background: url(" . esc_url( $src[0] ) . ")  center/cover no-repeat'" : '';

        $has_divider_class = $show_caption_divider ? ' has-divider' : '';

        // Generate HTML code.
        $html .= '<div id="' . esc_attr($id) . '" class="nb-fw banner '.$custom_class.' '.$effect_img.' '.esc_attr( $css_class ).'">';

        $html .= '<div class="nbfw_banner-container" ' . $bg_image_style . ' >';

        if( ! $show_img_as_background )
            $html .= '<img src="' . esc_url( $src[0] ) . '" alt="banner" />';
        
        if($txt_caption || $txt_primary || $description || $txt_button){
            $html .= '<div class="nbfw-txt-info '.$text_align.' '.$text_position.' '. esc_attr( implode( ' ', $classes ) ) .'" >';
            if($txt_caption){
                $html .='<div class="txt-caption' . $has_divider_class . '"> ' . $txt_caption;
                if($show_caption_divider) $html .= '<span class="txt-caption-divider"></span>';
                $html .= '</div>';
            }
            if($txt_primary){

                $html .='<h4 class="txt-primary">';
                if($link_to_title && $button_url){
                $html .='<a href="'. esc_url($button_url).'">';
                }
                $html .=' '.$txt_primary ;
                if($title_e1){
                $html .='<span '. $nbcss_custom .'> '.$title_e1.'</span>';
                }
                if($title_e2){
                    $html .=' '.$title_e2;
                }
                if($link_to_title && $button_url){
                    $html .='</a>';
                }

                $html .='</h4>';
            }

            if($description){
                $html .='<p class="txt-des"> '.$description.'</p>';
            }
            if($txt_button){
                $html .='<a href="'. esc_url($button_url).'" class="banner-more">'.$txt_button.' <i class="fa fa-angle-double-right " aria-hidden="true"></i> </a>';
            }

            $html .= '</div>';
        }
        
        
        $html .= '</div>';
        $html .= '</div>';
        // End HTML code.

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_banner', force_balance_tags($html));
    }
     
} // End Element Class
 
 
// Element Class Init
new NB_Element_Banner(); 
}
