<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

if (class_exists("WPBakeryShortCode")) {
// Element Class 
class NB_Element_Ajax_Tab_Products extends WPBakeryShortCode {
     
    // Element Init
    function __construct() {
        add_action( 'init', array( $this, 'vc_mapping' ), 12 );
        add_shortcode( 'netbase_vc_ajax_tab_products', array( $this, 'shortcode_ajax_tab_products' ) );

        add_action('wp_ajax_product_tabs', array($this, 'product_tabs_ajax_content'));
        add_action('wp_ajax_nopriv_product_tabs', array($this, 'product_tabs_ajax_content'));
        
    }
     
    // Element Mapping
    public function vc_mapping() {
         
        // Stop all if VC is not enabled
        if ( !defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
        if ( class_exists( 'WooCommerce' ) ) {
            $args = array(
                    'type' => 'post',
                    'child_of' => 0,
                    'parent' => '',
                    'orderby' => 'parent',
                    'order' => 'ASC',
                    'hide_empty' => false,
                    'hierarchical' => 1,
                    'exclude' => '',
                    'include' => '',
                    'number' => '',
                    'taxonomy' => 'product_cat',
                    'pad_counts' => false,
            );
            $categories = get_categories( $args );
            $product_categories_dropdown[] = array(
                    'label' => 'All categories',
                    'value' => '',
            );
            $this->getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
                
            $attributes_tax = wc_get_attribute_taxonomies();
            $attributes = array();
            foreach ( $attributes_tax as $attribute ) {
                $attributes[ $attribute->attribute_label ] = $attribute->attribute_name;
            }
        }
         
        // Map the block with vc_map()
        vc_map( array(
            'name'        => esc_html__( 'NB - Tab Product', 'nb-fw' ),
            'base'        => 'netbase_vc_ajax_tab_products',
            'icon' => 'icon-wpb-wp',
            'category' => __('Netbase Elements', 'nb-fw'),
            'description' => esc_html__( 'Display heading.', 'nb-fw' ),

            'params'      => array(
                //Title
                array(
                    'type'        => 'textfield',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Title', 'nb-fw' ),
                    'param_name'  => 'tab_title',
                    'value'       => '',
                    'description' => esc_html__( 'Write the title for the tab.', 'nb-fw' )
                ),
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Text title Color', 'nb-fw' ),
                    'param_name'  => 'txtcolor_title',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),  
                array(
                    'type'        => 'colorpicker',
                    'admin_label' => true,
                    'heading'     => esc_html__( 'Background title color', 'nb-fw' ),
                    'param_name'  => 'bgcolor_title',
                    'value'       => '',
                    'edit_field_class' => 'vc_col-xs-6 mgt20 vc_column',                    
                ),  

                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'Style', 'nb-fw' ),
                    'value' => array(
                        esc_html__('Classic', 'nb-fw') => 'classic',
                        esc_html__('Modern', 'nb-fw') => 'modern',
                    ),
                    'std' => '1',
                    'param_name' => 'p_tab_style',
                    'admin_label'   => true,
                    'save_always' => true,
                ),

                array(
                    'type'          => 'dropdown',
                    'heading'       => esc_html__( 'Product type', 'nb-fw' ),
                    'param_name'    => 'product_type',
                    'admin_label'   => true,
                    'value'         => array(
                            esc_html__('Recent', 'nb-fw')       => 'recent',
                            esc_html__('Featured', 'nb-fw') => 'featured',
                            esc_html__('Best Selling', 'nb-fw') => 'best_selling',
                            esc_html__('Top Rated', 'nb-fw')    => 'top_rated',
                            esc_html__('Mixed Order', 'nb-fw')  => 'mixed_order'
                            ),
                    'description'   => esc_html__( 'Select type of product', 'nb-fw' )
                ),

                array(
                        'heading'    => esc_html__( 'Category Product', 'nb-fw' ),
                        'type'       => 'param_group',
                        'param_name' => 'category_product',
                        'params'     => array(
                            array(
                            'type' => 'dropdown',
                            'heading' => esc_html__( 'Category', 'nb-fw' ),
                            'value' => $product_categories_dropdown,
                            'param_name' => 'category',
                            'admin_label'   => true,
                            'save_always' => true,
                            'description' => esc_html__( 'Product category list', 'nb-fw' ),

                            ),
                            array(
                                'param_name' => 'name',
                                'heading'    => esc_html__( 'Name', 'nb-fw' ),
                                'type'       => 'textfield',
                            ),
                            array(
                                    'param_name'       => 'style',
                                    'heading'          => esc_html__( 'Style', 'nb-fw' ),
                                    'type'             => 'dropdown',
                                    'edit_field_class' => 'vc_col-sm-6 mgt15',                        
                                    'value'            => array(                            
                                        __( 'None', 'nb-fw' )      => 'none',
                                        __( 'Icon', 'nb-fw' )      => 'icon',
                                        __( 'Image', 'nb-fw' )     => 'image',
                                    ),
                            ),
                            array(
                                'param_name'  => 'icon_fontawesome',
                                'heading'     => esc_html__( 'Icon', 'nb-fw' ),
                                'description' => esc_html__( 'Select icon from library.', 'nb-fw' ),
                                'type'        => 'iconpicker',
                                'settings'    => array(
                                    'emptyIcon'    => true,
                                    'iconsPerPage' => 200,
                                ),
                                'dependency'  => array(
                                    'element' => 'style',
                                    'value'   => 'icon',
                                ),
                            ),
                            array(
                                'param_name' => 'graphic',
                                'heading'    => esc_html__( 'Image Icon', 'nb-fw' ),
                                'type'       => 'attach_image',
                                'dependency'  => array(
                                    'element' => 'style',
                                    'value'   => 'image',
                                ),
                            ),

                            array(
                                'param_name' => 'cat_img',
                                'heading'    => esc_html__( 'Category Images', 'nb-fw' ),
                                'type'       => 'attach_images',
                            ),
                            array(
                                'param_name'    => 'cat_img_url',
                                'heading'       => esc_html__( 'Category Image URLs', 'printshop' ),
                                'type'          => 'exploded_textarea',
                                'description'   => esc_html__( 'Each URL is a new line', 'printshop' )
                            ),
                            array(
                                'type' => 'dropdown',
                                'heading' => esc_html__( 'Category Images Align', 'nb-fw' ),
                                'value' => array(
                                    esc_html__('Left', 'nb-fw') => 'left',
                                    esc_html__('Right', 'nb-fw') => 'right',
                                    esc_html__('Top', 'nb-fw') => 'top',
                                    esc_html__('Bottom', 'nb-fw') => 'bottom',
                                ),
                                'std' => 'left',
                                'param_name' => 'cat_img_align',                                
                                'save_always' => true,
                            ),

                            array(
                                'type' => 'checkbox',
                                'admin_label' => true,
                                'heading' => esc_html__('Display products in two rows', 'nb-fw'),
                                'param_name' => 'enable_multi_row',
                                'std' => false,               
                            ), 
                            
                        ),
                    ),
                array(
                        'type' => 'textfield',
                        'heading' => esc_html__( 'Show Per page', 'nb-fw' ),
                        'value' => 8,
                        'save_always' => true,
                        'admin_label'   => true,
                        'param_name' => 'per_page',
                        'description' => esc_html__( 'How many product to show on the page', 'nb-fw' ),
                    ),
                array(
                        'type' => 'dropdown',
                        'heading' => esc_html__( 'Columns', 'nb-fw' ),
                        'value' => array(
                            '1' => '1',
                            '2' => '2',
                            '3' => '3',
                            '4' => '4',                            
                            '6' => '6',
                        ),
                        'std' => '4',
                        'param_name' => 'column',
                        'admin_label'   => true,
                        'save_always' => true,                       
                        
                ),       
                array(
                    'type' => 'checkbox',
                    'admin_label' => true,
                    'heading' => esc_html__('Enable carousel', 'nb-fw'),
                    'param_name' => 'slider',
                    'std' => true,                    
                ), 
                array(
                        'param_name' => 'navigation',
                        'heading'    => esc_html__( 'Enable Navigation', 'nb-fw' ),
                        'type'       => 'checkbox',                                                
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                    ),
                array(
                        'param_name' => 'pagination',
                        'heading'    => esc_html__( 'Enable Pagination', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ), 
                array(
                        'param_name' => 'autoplay',
                        'heading'    => esc_html__( 'Enable Auto Play', 'nb-fw' ),
                        'type'       => 'checkbox',                        
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),
                array(
                    'param_name' => 'rtl',
                    'heading'    => esc_html__( 'Enable RTL', 'nb-fw' ),
                    'type'       => 'checkbox',                        
                    'dependency' => array(
                        'element' => 'slider',
                        'value'   => 'true',
                    ),
                ),
                array(
                        'param_name'  => 'columnstablet',
                        'heading'     => esc_html__( 'Number of columns displayed Tablet', 'nb-fw' ),
                        'type'        => 'dropdown',
                        'value'       => array(
                            __( 'Select columns', 'nb-fw' )  => '',
                            __( '1 column', 'nb-fw' )  => '1',
                            __( '2 columns', 'nb-fw' ) => '2',
                            __( '3 columns', 'nb-fw' ) => '3',
                            __( '4 columns', 'nb-fw' ) => '4',
                            __( '5 columns', 'nb-fw' ) => '5',
                            __( '6 columns', 'nb-fw' ) => '6',
                            __( '7 columns', 'nb-fw' ) => '7',
                            __( '8 columns', 'nb-fw' ) => '8',
                        ),                     
                        'std'         => '',   
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                        'edit_field_class' => 'vc_col-sm-6 vc_column',
                ),
                
                array(
                        'param_name'  => 'margin',
                        'heading'     => esc_html__( 'Margin Element', 'nb-fw' ),
                        'description' => esc_html__( 'Margin Element', 'nb-fw' ),
                        'type'        => 'textfield',
                        'value'       => '',
                        'dependency' => array(
                            'element' => 'slider',
                            'value'   => 'true',
                        ),
                ),         
                
            )
        ) );                               
        
    }     
     
    // Element HTML
    public function shortcode_ajax_tab_products($atts, $content = null)
    {
        $html = '';
        $data_owlcarousel = '';
        $classesowl = $attr = $classes = $available_tabs = $datajoson = $cat_images = $enable_multi_row_arr = array();
         
        // Extract shortcode parameters.
        extract(
            shortcode_atts(
                array(
                    'tab_title'         => '',
                    'per_page'          => '',
                    'column'            => 6,
                    'category_product'  => '',
                    'category'          => '',
                    'graphic'           => '',
                    'style'             => '',
                    'product_type'      => 'recent',
                    'icon_fontawesome'  => '',
                    'slider'            => false,
                    'navigation'        => '',
                    'pagination'        => '',
                    'autoplay'          => '',
                    'columnstablet'     =>'',   
                    'nav_position'      => 'bottom',
                    'margin'            => '',
                    'p_tab_style'       => 1,
                    'cat_img'           => '',
                    'cat_img_url'       => '',
                    'cat_img_align'     => 'left',
                    'enable_multi_row'  => false,
                    'txtcolor_title'    => '',
                    'bgcolor_title'     => '',
                    'rtl'               => ''
                ),
                $atts
            )
        );

        
        
        // Generate custom ID
        $id = uniqid('netbase_custom_');
        
        //$available_tabs = explode(",",$category_slug);    

        $catvalues = ( array ) vc_param_group_parse_atts( $category_product );
        $nbcss_custom ='';
        if ( $bgcolor_title ) {
            $nbcss_custom .= 'background:' . $bgcolor_title . ';';
        } 
        if ( $txtcolor_title ) {
            $nbcss_custom .= 'color:' . $txtcolor_title . ';';
        } 
        if ( $nbcss_custom ) {
            $nbcss_custom = ' style="' . $nbcss_custom . '"';
        }
        
        if ( ! empty( $slider ) ) {
                if($margin != ''){                    
                    $attr[] = '"margin": "' . ( int ) $margin . '"';
                }
                
                if ( $navigation ) {
                    $attr[] = '"nav": "true"';
                }
                if ( $pagination ) {
                    $attr[] = '"dots": "true"';
                }
                
                if ( ! empty( $columnstablet ) ) {
                    $attr[] = '"tablet_cols": "' . ( int ) $columnstablet . '"';
                }
                if ( ! empty( $column ) ) {
                    $attr[] = '"items": "' . ( int ) $column . '"';
                }
                if($autoplay){
                    $attr[] = '"autoplay": "true"';
                }

                if($rtl){
                    $attr[] = '"rtl": "true"';
                }
                /*if($loop){
                    $attr[] = '"loop": "true"';
                }*/

                if ( ! empty( $attr ) ) {
                    $data_owlcarousel = '{' . esc_attr( implode( ', ', $attr ) ) . '}';
                }

                /*if($dots_size && $pagination){
                    $classes[] =' dots-'.$dots_size.' ';
                } */               

                if ( $nav_position && $navigation) {
                    $classesowl[] ='nav-'.$nav_position;
                }                

                $classesowl[] = 'textdomain-carousel owl-carousel owl-loaded owl-drag nb-fw-carousel';
            }
            else
            {
                $classesowl[] = '';
            }

        ob_start();
        ?>
        <?php
            $tab_header_class = (isset($p_tab_style) && $p_tab_style != '') ? $p_tab_style . '-style' : '';
        ?>
        <div class="wpt-tab-header owl-carousel <?php echo esc_attr( $tab_header_class );?>">
            <?php

            if( isset($tab_title) && $tab_title != '' ) {
                echo '<h3 class="widget-title" '.$nbcss_custom.'>' . $tab_title . '</h3>';
            }
            ?>

            <div class="wpt-tabs tabs <?php if($tab_title == '') echo 'no-title';?>">
            <?php
                foreach ( $catvalues as $key => $catvalue ) {
                    $available_tabs[] = $catvalue[ 'category' ] ;              
                    ?>
                    <div class="tab_title <?php if($key ==0) echo 'selected';?>">
                        <a href="#" id="<?php echo $id.'-'.$key; ?>-tab">
                            <?php
                            $idObj1= get_term_by('slug', $catvalue[ 'category' ], 'product_cat'); 
                            if ( 'icon' == $catvalue['style'] ) {            
                                echo '<i class="' . esc_attr( str_replace('fas', 'fa', $catvalue['icon_fontawesome'] )) .'" ></i>';
                            }
                            else if ( 'image' == $catvalue['style'] )
                            {
                                if ( ! empty( $catvalue['graphic'] ) ) {
                                        // Get image link and image data
                                    $image = wpb_getImageBySize( array( 'attach_id' => preg_replace( '/[^\d]/', '', $catvalue['graphic'] ) ) );

                                    echo '<div class="image-icon"><img src="' . esc_url( $image['p_img_large'][0] ) . '" alt="' . esc_attr__( 'image-icon', 'nb-fw' ) . '" width="' . esc_attr( $image['p_img_large'][1] ) . '" height="' . esc_attr( $image['p_img_large'][2] ) . '" /></div>';
                                }
                            }
                            if ( $idObj1 instanceof WP_Term ) {
                                echo $idObj1->name;
                            }else{
                                echo esc_html__( 'All Products', 'nb-fw' );
                            }
                        ?>
                            
                        </a>
                    </div>

                <?php
                    $cat_images[ $key ]['img'] = isset( $catvalue[ 'cat_img' ] ) ? $catvalue[ 'cat_img' ] : '' ;
                    $cat_images[ $key ]['img_align'] = $catvalue[ 'cat_img_align' ];
                    $cat_images[ $key ]['cat_img_url'] = isset( $catvalue[ 'cat_img_url' ] ) ? $catvalue[ 'cat_img_url' ] : '';


                    $enable_multi_row_arr[ $key ][ 'enable_multi_row' ] = isset( $catvalue[ 'enable_multi_row' ] ) ? $catvalue[ 'enable_multi_row' ] : false;
                }

                if ( function_exists('icl_object_id') ) {
                    array_push($datajoson, $available_tabs,$classesowl,$column, $per_page, $data_owlcarousel, $cat_images,$enable_multi_row_arr, $product_type, ICL_LANGUAGE_CODE);
               }
               else {
                    array_push($datajoson, $available_tabs,$classesowl,$column, $per_page, $data_owlcarousel, $cat_images,$enable_multi_row_arr, $product_type);
               }

               
                ?>
            </div>
        </div>
        
        <div class="inside vk-tabcontent"> 
            <?php foreach ($available_tabs as $key => $value) { ?>
                <?php if($key != 0):?>
                    <div id="<?php echo $id.'-'.$key; ?>-tab-content" class="tab-content" >              
                    </div>
                <?php else:?>
                    <div id="<?php echo $id.'-'.$key; ?>-tab-content" class="tab-content" >
                    <?php
                        
                        set_query_var( 'temp_style', 'grid-type' );

                        $classes = array();

                        switch ($column) {
                        case '1':
                            $classes[] = 'columns-1';
                            break;
                        case '2':
                            $classes[] = 'columns-2';
                            break;
                        case '3':
                            $classes[] = 'columns-3';
                            break;
                        case '4':
                            $classes[] = 'columns-4';
                            break;
                        case '6':
                            $classes[] = 'columns-6';
                            break;
                        default:
                            $classes[] = 'columns-4';
                            break;
                        }    
                        $classslider = $classesowl;
                        $data_owl_options = $data_owlcarousel;
                        $enable_multi_row_data = $enable_multi_row_arr[0];

                        $args = array('post_type' => 'product', 'posts_per_page' => $per_page, 'product_cat'=> $value, 'post_status' => 'publish', 'orderby' => 'desc' );

                        $this->nb_filter_product_by_product_type($args, $product_type);

                        $loop = new WP_Query( $args );

                        $showcount = $loop->post_count; 
                        $cat_images_arr = $cat_images[0];
                        $cat_img_align_class = '';

                        if( ! empty( $cat_images_arr['img'] ) && ! empty( $cat_images_arr['img_align'] ) ) {

                            $cat_img_align_class = 'img-align-' . $cat_images_arr['img_align'];
                        }

                        echo '<div class="tab-product-wrapper ' . esc_attr( $cat_img_align_class ) . '">';

                            if ( ! empty( $cat_images_arr['img'] ) ) {

                                echo '<div class="cat_img">';

                                $cat_images = explode(',', $cat_images_arr['img']);

                                foreach($cat_images as $index => $cat_img)
                                {
                                    $img_data = wp_get_attachment_image_src( $cat_img, 'full' );

                                    $image_links = isset($cat_images_arr['cat_img_url']) ? explode(',', $cat_images_arr['cat_img_url']) : '';

                                    $image_link = isset($image_links[$index]) ? 'href="' . $image_links[$index] . '"' : '';

                                    echo '<a ' . $image_link . '><img src="' . esc_url( $img_data[0] ) . '" alt="' . esc_attr__( 'image-cat', 'nb-fw' ) . '" /></a>';
                                }

                                echo '</div>';
                            }

                            if ( $loop->have_posts() ) {
                            echo '<div class="woocommerce '.esc_attr( implode( ' ', $classes ) ).' nb_wcproducts_default">';
                                echo '<div class="nb_wc-products '.esc_attr( implode( ' ', $classslider ) ).'" data-cols-xl="'.esc_attr($column).'" data-cols-lg="3" data-cols-md="3" data-cols-sm="2" data-owl-options="' . esc_html($data_owl_options) . '">';                                          
                                    
                                    
                                    if( $enable_multi_row_data[ 'enable_multi_row' ] === 'true') {
                                        $count = 0;
                                        while ( $loop->have_posts() ) : $loop->the_post();
                                            if( $count % 2 == 0 ) {
                                                echo '<div class="products-column multi-row">';
                                            }

                                                wc_get_template_part( 'content', 'product' );

                                            $count++;
                                            if( $count % 2 == 0 ) {
                                                echo '</div>';
                                            }
                                        endwhile;

                                    }
                                    else {

                                        while ( $loop->have_posts() ) : $loop->the_post();
                                            echo '<div class="products-column">';
                                                wc_get_template_part( 'content', 'product' );
                                            echo '</div>';
                                        endwhile;
                                    }
                                
                                echo '</div>';
                            echo '</div>';                
                            }else{ 
                                echo '<p>No product found</p>';
                            }
                        echo '</div>';
                    ?>
                    </div>
                <?php endif;?>
            <?php } ?>                    
        <div class="clear"></div>
        </div> <!--end .inside -->
        <script type="text/javascript">  
            jQuery(function($) {
                $('#<?php echo esc_attr($id); ?>_content').data('args', <?php echo json_encode($datajoson); ?>);

            });  
        </script>
        <?php
        $html .= '<div id="' . esc_attr($id) . '_content" class="vktab_widget_content" >' . ob_get_clean() . '</div>';

        wp_reset_postdata();
        return apply_filters('netbase_shortcode_ajax_tab_products', force_balance_tags($html));
    }

    function product_tabs_ajax_content() {
        $tab = $_POST['tab'];
        $args = $_POST['args'];
        set_query_var( 'temp_style', 'grid-type' );
        //$arrslugcat = explode(",",$args['category_slug']);  
        $arrslugcat = $args[0];
        
        $classes = array();
        
        $column =$args[2];
        switch ($column) {
        case '1':
            $classes[] = 'columns-1';
            break;
        case '2':
            $classes[] = 'columns-2';
            break;
        case '3':
            $classes[] = 'columns-3';
            break;
        case '4':
            $classes[] = 'columns-4';
            break;
        case '6':
            $classes[] = 'columns-6';
            break;
        default:
            $classes[] = 'columns-4';
            break;
        }    
        $classslider = $args[1] ;
        $data_owl_options = $args[4];
        $cat_images_data = $args[5];
        $enable_multi_row_data = $args[6];
        $product_type = $args[7];
        $current_lang = isset($args[8]) ? $args[8] : '';
        foreach ($arrslugcat as $key => $value) {
        
                switch($tab){
                    case $key:                      
                    if($value){
                        $catname1 = trim($value);
                    }else{
                        $catname1 = '';
                    }

                    
                    $args = array('post_type' => 'product', 'posts_per_page' => $args[3], 'product_cat'=>$catname1, 'post_status' => 'publish', 'orderby' => 'desc' );

                    if ( $current_lang != '' ) {
                        do_action( 'wpml_switch_language', $current_lang ); // switch the content language
                    }

                    $this->nb_filter_product_by_product_type($args, $product_type);

                    $loop = new WP_Query( $args );

                    $showcount = $loop->post_count; 
                    $cat_images_arr = $cat_images_data[$key];
                    $cat_img_align_class = '';
                    $enable_multi_row_arr = $enable_multi_row_data[$key];

                    if( ! empty( $cat_images_arr['img'] ) && ! empty( $cat_images_arr['img_align'] ) ) {

                        $cat_img_align_class = 'img-align-' . $cat_images_arr['img_align'];
                    }

                    echo '<div class="tab-product-wrapper ' . esc_attr( $cat_img_align_class ) . '">';

                        if ( ! empty( $cat_images_arr['img'] ) ) {

                            echo '<div class="cat_img">';

                            $cat_images = explode(',', $cat_images_arr['img']);

                            foreach($cat_images as $index => $cat_img)
                            {
                                $img_data = wp_get_attachment_image_src( $cat_img, 'full' );

                                $image_links = isset($cat_images_arr['cat_img_url']) ? explode(',', $cat_images_arr['cat_img_url']) : '';

                                $image_link = isset($image_links[$index]) ? 'href="' . $image_links[$index] . '"' : '';

                                echo '<a ' . $image_link . '><img src="' . esc_url( $img_data[0] ) . '" alt="' . esc_attr__( 'image-cat', 'nb-fw' ) . '" /></a>';
                            }

                            echo '</div>';
                        }

                        if ( $loop->have_posts() ) {
                        echo '<div class="woocommerce '.esc_attr( implode( ' ', $classes ) ).' nb_wcproducts_default">';
                            echo '<div class="nb_wc-products '.esc_attr( implode( ' ', $classslider ) ).'" data-cols-xl="'.esc_attr($column).'" data-cols-lg="3" data-cols-md="3" data-cols-sm="2" data-owl-options="' . esc_html($data_owl_options) . '">';                                          
                                
                                
                                if( $enable_multi_row_arr[ 'enable_multi_row' ] === 'true') {
                                    $count = 0;
                                    while ( $loop->have_posts() ) : $loop->the_post();
                                        if( $count % 2 == 0 ) {
                                            echo '<div class="products-column multi-row">';
                                        }

                                            wc_get_template_part( 'content', 'product' );

                                        $count++;
                                        if( $count % 2 == 0 ) {
                                            echo '</div>';
                                        }
                                    endwhile;

                                }
                                else {

                                    while ( $loop->have_posts() ) : $loop->the_post();
                                        echo '<div class="products-column">';
                                            wc_get_template_part( 'content', 'product' );
                                        echo '</div>';
                                    endwhile;
                                }
                            
                            echo '</div>';
                        echo '</div>';                
                        }else{ 
                            echo '<p>No product found</p>';
                        }
                    echo '</div>';

                    break;
                }
        }   
        die(); // required to return a proper result
        
    }
    
    protected function getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {
            for ( $i = $pos; $i < count( $array ); $i ++ ) {
                if ( $array[ $i ]->category_parent == $parent_id ) {
                    $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
                    $value = $array[ $i ]->slug;
                    $dropdown[] = array(
                        'label' => $name,
                        'value' => $value,
                    );
                    $this->getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
                }
            }
    } 

    protected function nb_filter_product_by_product_type( &$args = array(), $product_type = 'recent' ){
        switch( $product_type ){
            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;
            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;
            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'top_rated':
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;
            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;
            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }
    }
} // End Element Class
 
 
// Element Class Init
new NB_Element_Ajax_Tab_Products(); 
}
