<?php
class NB_Dokan_LiveChat {

	public function __construct() {
		add_action('dokan_settings_form_bottom', array( $this, 'dokan_settings_live_chat_show'), 10, 2);
		add_action('dokan_store_profile_saved', array( $this, 'dokan_settings_live_chat_save'), 10, 2 );

		add_action( 'woocommerce_after_single_product', array( $this, 'embed_code_single_product'), 5 );
		add_action( 'dokan_store_profile_frame_after', array($this, 'embed_code_store_page'), 10, 2);
 

	}

	public function embed_code_store_page($user_data, $store_info) {
		if( function_exists('dokan') ) {
			add_action('wp_footer', function() use ( $store_info ) { 
				if( isset($store_info['dokan_store_livechat']) && !empty($store_info['dokan_store_livechat']) ) {
					echo $this->show_embed_code($store_info['dokan_store_livechat']);
				}
			});
		}
	}

	public function embed_code_single_product() {
		global $post;

		if( function_exists('dokan') ) {
			$vendor      = dokan()->vendor->get( $post->post_author );
			$store_info = $vendor->get_shop_info();

			add_action('wp_footer', function() use ( $store_info ) { 
				if( isset($store_info['dokan_store_livechat']) && !empty($store_info['dokan_store_livechat']) ) {
					echo $this->show_embed_code($store_info['dokan_store_livechat']);
				}
			});
		}
	}

	public function dokan_settings_live_chat_show($current_user, $profile_info) {

		$dokan_store_livechat = isset( $profile_info['dokan_store_livechat'] ) ? esc_attr( $profile_info['dokan_store_livechat'] ) : '';
		$dokan_store_livechat = str_replace('&lt;div&gt;', "<div>", $dokan_store_livechat);
		$dokan_store_livechat = str_replace('&lt;/div&gt;', "</div>", $dokan_store_livechat);
		$dokan_store_livechat = preg_replace("/\<div([^>].*)\>([^<]*)<\/div\>/iU", "$2", $dokan_store_livechat);
	 	?>
            <div class="dokan-form-group" id="dokan_lchat_text">
                <label class="dokan-w3 dokan-control-label" for="dokan_store_lchat"><?php esc_html_e( 'Live Chat embed code', 'multistore' ); ?></label>
                <div class="dokan-w8 dokan-text-left">
                    <div id="dokan_store_lchat" class="div-form-control dokan-form-control" style="width: 100%; height: 200px" contenteditable="true"><?php echo $dokan_store_livechat;?></div>
                    <input type="hidden" name="dokan_store_livechat" value="<?php echo htmlspecialchars($dokan_store_livechat);?>" />

                </div>
            </div>

            <script type="text/javascript">
            	jQuery(document).ready(function($) {
            		$(document).on( 'keyup', '#dokan_store_lchat', function() {
            			var $val = $(this).html();
            			$('[name="dokan_store_livechat"]').val($val);
            		});
            	});
            </script>
        <?php
	 	
	}

	public function show_embed_code($html) {
		$html = strip_tags($html);
		$html = htmlspecialchars_decode($html);
		$html = preg_replace("/\<div([^>].*)\>([^<]*)<\/div\>/iU", "$2", $html);
		$html = html_entity_decode($html, ENT_QUOTES);

		return $html;
	}

	public function dokan_settings_live_chat_save($store_id, $dokan_settings) {
		// Automatically clear Autoptimize cache if save
		if ( class_exists('autoptimizeCache') ) {
		    autoptimizeCache::clearall();
		}

		$dokan_store_livechat = isset( $_POST['dokan_store_livechat'] ) ? $_POST['dokan_store_livechat'] : '';
		$dokan_store_livechat = str_replace('\\', '', $dokan_store_livechat);
		$dokan_store_livechat = preg_replace("/\<div([^>].*)\>([^<]*)<\/div\>/iU", "$2", $dokan_store_livechat);

		$dokan_settings['dokan_store_livechat'] = $dokan_store_livechat;

		update_user_meta( $store_id, 'dokan_profile_settings', $dokan_settings );
	}
}

new NB_Dokan_LiveChat();