<?php
if( ! class_exists('NB_Brands_Category')) {
	class NB_Brands_Category extends WP_Widget {
		public function __construct() {
			parent::__construct(
				'nb-brands-category',
				__( 'NB - Lists of Brands ', 'nbt-brands-thumbnail' ),
				array(
					'classname' => 'nbt-brands-thumbnail',
					'description' => __( 'Show all brands lists', 'nbt-brands-thumbnail' )
				)
			);
		}


		public function form( $instance ) {
			$title = esc_attr( $instance['title'] );
			$hide_empty = esc_attr( $instance['hide_empty'] );
			$count = esc_attr( $instance['count'] );
			?>
			<p>
				<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?>: 
					<input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>">
				</label>
			</p>

			<p>
				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>" value="1" <?php checked( $count, 1 ); ?>>
				<label for="<?php echo $this->get_field_id('count'); ?>">Show post counts</label><br>

				<input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('hide_empty'); ?>" name="<?php echo $this->get_field_name('hide_empty'); ?>" value="1" <?php checked( $hide_empty, 1 ); ?>>
				<label for="<?php echo $this->get_field_id('hide_empty'); ?>">Show empty brands</label>
			</p>
			<?php
		}

		public function update( $new_instance, $old_instance ) {
	        $instance = $old_instance;
	 		$instance['title'] = $new_instance['title'];
	        $instance['hide_empty'] = $new_instance['hide_empty'];
	        $instance['count'] = $new_instance['count'];

	        return $instance;
	    }

		public function widget( $args, $instance ) {
			global $post;

			extract( $args );

			$title = apply_filters( 'widget_title', $instance['title'] );
			$hide_empty = isset($instance['hide_empty']) ? false : true;
			$count = isset($instance['count']) ? $instance['count'] : "";

			echo $before_widget;
				if ( $title ) :
					echo $before_title . $title . $after_title;
				endif;

				// var_dump($hide_empty);
				// die();

				$terms = get_terms('nbproduct_brand', array(
				    'hide_empty' => $hide_empty
				));

				if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) :

				?>
				<ul class="product-categories">
					<?php foreach ( $terms as $term ) :
						if( $count ) {
							$count = ' (' . $term->count . ')';
						}
						?>
					<li class="cat-item cat-item-<?php echo $term->term_id;?>" style="position: relative;"><a href="<?php echo esc_url( get_term_link( $term ) );?>" alt="<?php echo esc_attr( sprintf( __( 'View all post filed under %s', 'nb-fw' ), $term->name ) );?>"><?php echo $term->name . $count;?></a></li>
					<?php endforeach;?>
				</ul>
				<?php
				else:
					echo 'No brand';
				endif;

			echo $after_widget;

		}
	}
}