<?php
class NB_Brands_Frontend {
	public function __construct() {
		add_action( 'woocommerce_product_meta_end', array($this, 'add_brands_product_meta'), 41 );
	}

	public function add_brands_product_meta() {
		global $product;
		if( !$product ) return;

		$brands = get_the_terms( $product->get_id(), 'nbproduct_brand');
		if( $brands ){
			echo '<div class="brand_wrapper"><span class="meta-name">'.esc_html__('Brands', 'multistore-elements' ).': </span>';
			$string = '';
			foreach ($brands as $key => $brand) {
				$string .= '<span><a href="'. esc_url( get_term_link( $brand ) ).'">'. esc_attr($brand->name) .'</a></span>, ';
			}
			echo rtrim($string, ', ') . '</div>';
		}
	}
}

if( ! is_admin() ) {
	new NB_Brands_Frontend();
}