<?php

define('NBT_BRANDS_PATH', plugin_dir_path( __FILE__ ));
define('NBT_BRANDS_URL', plugin_dir_url( __FILE__ ));

class NB_Brands_Admin {
	private $type;
	private $target;

	public function __construct() {
		add_action( 'init', array($this, 'create_taxonomy_brands') );
		add_action( 'nbproduct_brand_add_form_fields', array($this, '___add_form_field_term_meta_text') );
		add_action( 'nbproduct_brand_edit_form_fields', array($this, '___edit_form_field_term_meta_text') );
		// State that initialization completed.

		add_action( 'edit_nbproduct_brand',   array($this, '___save_term_meta_text') );
		add_action( 'create_nbproduct_brand', array($this, '___save_term_meta_text') );

		add_filter( 'manage_edit-nbproduct_brand_columns', array($this, '___edit_term_columns'), 10, 3 );
		add_filter( 'manage_edit-nbproduct_brand_columns', array($this, '__add_columns_thumbnail'), 10, 3 );
	
		add_action('admin_enqueue_scripts', array($this, 'embed_style'));

		$this->type = array(
			'default' => __('Default', 'nb-fw'),
			'url' => __('URL', 'nb-fw')
		);

		$this->target = array(
			'_self' => __('Default', 'nb-fw'),
			'_blank' => __('Open a new window or new tab', 'nb-fw')
		);


	}

	public function create_taxonomy_brands() {
	    register_meta( 'nbproduct_brand', 'brands_url', array($this, 'sanitize_term_meta_text') );
	    add_filter( 'manage_nbproduct_brand_custom_column', array($this, '__manage_term_custom_column'), 10, 3 );
	    add_filter( 'manage_nbproduct_brand_custom_column', array($this, '__show_columns_thumbnail'), 10, 3 );
	}


	public function ___add_form_field_term_meta_text() { ?>
	    <?php wp_nonce_field( basename( __FILE__ ), 'term_meta_text_nonce' ); ?>

	   <div class="form-field term-meta-text-wrap">
	        <label for="term-meta-text"><?php _e( 'Logo', 'nb-fw' ); ?></label>
	        <?php
	    	$image = WC()->plugin_url() . '/assets/images/placeholder.png';
	    	?>
		    <div class="nbtcs-wrap-image">
		     <div class="nbtcs-term-image-thumbnail" style="float:left;margin-right:10px;">
		      <img src="<?php echo esc_url( $image ) ?>" width="60px" height="60px" />
		     </div>
		     <div  class="nbtcs-term-image-action">
		      <input type="hidden" class="nbtcs-term-image" name="brands_thumbnail" value="" />
		      <button type="button" class="nbtcs-upload-image-button button"><?php esc_html_e( 'Upload/Add image', 'wcvs' ); ?></button>
		      <button type="button" class="nbtcs-remove-image-button button hidden"><?php esc_html_e( 'Remove image', 'wcvs' ); ?></button>
		     </div>
		    </div>
  		</div>
	    <div class="form-field term-meta-text-wrap" style="clear: both;">
	        <label for="term-meta-text"><?php _e( 'Type', 'nb-fw' ); ?></label>
			<select name="brands_type" id="brands_type" class="postform">
				<?php if( is_array($this->type) && !empty($this->type) ){
					foreach ($this->type as $key => $value) {
						?>
						<option value="<?php echo $key;?>"><?php echo $value;?></option>
						<?php
					}
				}?>
			</select>
	    </div>
	    <div class="form-field term-meta-text-wrap">
	        <label for="term-meta-text"><?php _e( 'Target', 'nb-fw' ); ?></label>
			<select name="brands_target" id="brands_target" class="postform">
				<?php if( is_array($this->target) && !empty($this->target) ){
					foreach ($this->target as $key => $value) {
						?>
						<option value="<?php echo $key;?>"><?php echo $value;?></option>
						<?php
					}
				}?>
			</select>
	    </div>
	    <div class="form-field term-meta-text-wrap">
	        <label for="term-meta-text"><?php _e( 'URL', 'nb-fw' ); ?></label>
	        <input type="text" name="brands_url" id="term-meta-text" value="" class="term-meta-text-field" />
	    </div>
	<?php }

	public function ___edit_form_field_term_meta_text(){
		$term_id = absint( $_REQUEST['tag_ID'] );

		$brands_type = get_term_meta( $term_id, 'brands_type', true );
		$brands_type = self::sanitize_term_meta_text( $brands_type );
	    if ( ! $brands_type ){
	        $brands_type = "";
	    }

		$brands_thumbnail = get_term_meta( $term_id, 'brands_thumbnail', true );
		$brands_thumbnail = self::sanitize_term_meta_text( $brands_thumbnail );
	    if ( ! $brands_thumbnail ){
	        $brands_thumbnail = "";
	    }

		$brands_url = get_term_meta( $term_id, 'brands_url', true );
		$brands_url = self::sanitize_term_meta_text( $brands_url );
	    if ( ! $brands_url ){
	        $brands_url = "";
	    }

	    ?>

	    <tr class="form-field term-meta-text-wrap">
	        <th scope="row"><label for="term-meta-text"><?php _e( 'Logo', 'nb-fw' ); ?></label></th>
	        <td>
	            <?php wp_nonce_field( basename( __FILE__ ), 'term_meta_text_nonce' ); ?>
				<?php
				$image = $brands_thumbnail ? wp_get_attachment_image_src( $brands_thumbnail ) : '';
				$image = $image ? $image[0] : NBT_BRANDS_URL . '/images/placeholder.png';
				?>
				<div class="nbtcs-wrap-image">
					<div class="nbtcs-term-image-thumbnail" style="float:left;margin-right:10px;">
						<img src="<?php echo esc_url( $image ) ?>" width="60px" height="60px" />
					</div>
					<div class="nbtcs-term-image-action">
						<input type="hidden" class="nbtcs-term-image" name="brands_thumbnail" value="<?php echo esc_attr( $brands_thumbnail ) ?>" />
						<button type="button" class="nbtcs-upload-image-button button"><?php esc_html_e( 'Upload/Add image', 'wcvs' ); ?></button>
						<button type="button" class="nbtcs-remove-image-button button <?php echo $brands_thumbnail ? '' : 'hidden' ?>"><?php esc_html_e( 'Remove image', 'wcvs' ); ?></button>
					</div>
				</div>
	        </td>
	    </tr>


	    <tr class="form-field term-meta-text-wrap" style="clear: both;">
	        <th scope="row"><label for="term-meta-text"><?php _e( 'Type', 'nb-fw' ); ?></label></th>
	        <td>
	            <?php wp_nonce_field( basename( __FILE__ ), 'term_meta_text_nonce' ); ?>
				<select name="brands_type" id="brands_type" class="postform">
					<?php if( is_array($this->type) && !empty($this->type) ){
						foreach ( $this->type as $key => $value) {
							?>
							<option value="<?php echo $key;?>"<?php selected( $key, $brands_type); ?>><?php echo $value;?></option>
							<?php
						}
					}?>
				</select>
	        </td>
	    </tr>
	    <tr class="form-field term-meta-text-wrap">
	        <th scope="row"><label for="term-meta-text"><?php _e( 'Target', 'nb-fw' ); ?></label></th>
	        <td>
	            <?php wp_nonce_field( basename( __FILE__ ), 'term_meta_text_nonce' ); ?>
				<select name="brands_target" id="brands_target" class="postform">
					<?php if( is_array($this->target) && !empty($this->target) ){
						foreach ( $this->target as $key => $value) {
							?>
							<option value="<?php echo $key;?>"<?php selected( $key, $brands_type); ?>><?php echo $value;?></option>
							<?php
						}
					}?>
				</select>
	        </td>
	    </tr>
	    <tr class="form-field term-meta-text-wrap">
	        <th scope="row"><label for="term-meta-text"><?php _e( 'URL', 'nb-fw' ); ?></label></th>
	        <td>
	            <?php wp_nonce_field( basename( __FILE__ ), 'term_meta_text_nonce' ); ?>
				<input type="text" name="brands_url" id="term-meta-text" value="<?php echo $brands_url;?>" class="term-meta-text-field" />
	        </td>
	    </tr>
	    <?php
	}

	public function ___save_term_meta_text( $term_id ) {
	    // verify the nonce --- remove if you don't care
	    if ( ! isset( $_POST['term_meta_text_nonce'] ) || ! wp_verify_nonce( $_POST['term_meta_text_nonce'], basename( __FILE__ ) ) )
	        return;

	    if(isset($_POST['brands_thumbnail'])){
	    	update_term_meta( $term_id, 'brands_thumbnail', $_POST['brands_thumbnail'] );
	    }
	    


		$brands_type = get_term_meta( $term_id, 'brands_type', true );
		$brands_type = self::sanitize_term_meta_text( $brands_type );

	    $brands_type_new = isset( $_POST['brands_type'] ) ? self::sanitize_term_meta_text ( $_POST['brands_type'] ) : '';
	    if ( $brands_type && '' === $brands_type_new ){
	        delete_term_meta( $term_id, 'brands_type' );
	    }
	    else if ( $brands_type !== $brands_type_new ){
	        update_term_meta( $term_id, 'brands_type', $brands_type_new );
	    }

		$brands_target = get_term_meta( $term_id, 'brands_target', true );
		$brands_target = self::sanitize_term_meta_text( $brands_target );

	    $brands_target_new = isset( $_POST['brands_target'] ) ? self::sanitize_term_meta_text ( $_POST['brands_target'] ) : '';
	    if ( $brands_target && '' === $brands_target_new ){
	        delete_term_meta( $term_id, 'brands_target' );
	    }
	    else if ( $brands_target !== $brands_target_new ){
	        update_term_meta( $term_id, 'brands_target', $brands_target_new );
	    }

		$brands_url = get_term_meta( $term_id, 'brands_url', true );
		$brands_url = self::sanitize_term_meta_text( $brands_url );

	    $brands_url_new = isset( $_POST['brands_url'] ) ? self::sanitize_term_meta_text ( $_POST['brands_url'] ) : '';
	    if ( $brands_url && '' === $brands_url_new ){
	        delete_term_meta( $term_id, 'brands_url' );
	    }
	    else if ( $brands_url !== $brands_url_new ){
	        update_term_meta( $term_id, 'brands_url', $brands_url_new );
	    }
	}

	public function ___edit_term_columns( $columns ) {
	    $columns['brands_type'] = __( 'Type', 'nb-fw' );
	    return $columns;
	}

	public function __add_columns_thumbnail( $columns ) {
		$new_columns          = array();
		$new_columns['cb']    = $columns['cb'];
		$new_columns['brands_thumbnail'] = '';
		unset( $columns['cb'] );
		unset( $columns['description'] );

		return array_merge( $new_columns, $columns );
	}

	public function __manage_term_custom_column($out, $column, $term_id ) {

	    if ( 'brands_type' === $column && is_array($this->type) && !empty($this->type) ) {
			$brands_type = get_term_meta( $term_id, 'brands_type', true );
			$brands_type = self::sanitize_term_meta_text( $brands_type );


			$type = $this->type;

			if(!$brands_type){
				$brands_type = 'default';
			}
			echo $type[$brands_type];
	   
	       
	    }
	}

	public function __show_columns_thumbnail($columns, $column, $term_id) {
		if ( $column == 'brands_thumbnail' ) {
			$brands_thumbnail = get_term_meta( $term_id, 'brands_thumbnail', true );
			$brands_thumbnail = self::sanitize_term_meta_text( $brands_thumbnail );
			$image = $brands_thumbnail ? wp_get_attachment_image_src( $brands_thumbnail ) : '';
			$image = $image ? $image[0] : NBT_BRANDS_URL . '/images/placeholder.png';
			printf( '<img class="swatch-preview swatch-image" src="%s" width="44px" height="44px">', esc_url( $image ) );
	
		}
	}

	public function sanitize_term_meta_text ( $value ) {
	    return sanitize_text_field ($value);
	}


	public function embed_style(){
		$style = '
		.nbtcs-term-image-action {
		    line-height: 60px;
		    position: relative;
		    width: 213px;
		    margin-left: 70px;
		}

		.nbtcs-remove-image-button {
			display: inline-block;
		    position: absolute;
		    left: 0;
		    bottom: 0;
		}
		.column-brands_thumbnail .swatch-preview {
		    width: 60px;
		    height: auto;
		    line-height: 80px;
		    text-align: center;
		    font-weight: 700;
		    border: 1px solid #e6e6e6;
		}
		#brands_thumbnail{
			width: 60px;
		}
		';
		wp_add_inline_style('dashicons', $style);
		if( isset($_GET['taxonomy']) && $_GET['taxonomy'] == 'nbproduct_brand' ){
			wp_enqueue_media();
		
			wp_enqueue_script( 'admin-brands-script', NB_ELEMENTS_URL . 'modules/brands/admin.js', null, null, true );

			 wp_localize_script(
			   'admin-brands-script',
			   'nbtcs',
			   array(
			    'i18n'        => array(
			     'mediaTitle'  => esc_html__( 'Choose an image', 'wcvs' ),
			     'mediaButton' => esc_html__( 'Use image', 'wcvs' ),
			    ),
			    'placeholder' => WC()->plugin_url() . '/assets/images/placeholder.png'
			   )
			);
		}


	}
}

if( is_admin() ) {
	new NB_Brands_Admin();
}