jQuery( function( $ ) {
	var wp = window.wp;
	/**
	 * Variations Price Matrix actions
	 */
	var nbt_brands_admin = {

		/**
		 * Initialize variations actions
		 */
		init: function() {
			$(document).on('click', '.nbtcs-upload-image-button', this.upload_image);
			$(document).on( 'click', '.nbtcs-remove-image-button', this.remove_upload_image);
		},
		upload_image: function(e){

				e.preventDefault();
				var $button = $( this ).closest('.nbtcs-wrap-image');
				
		

			// Create the media frame.
			var frame = wp.media.frames.downloadable_file = wp.media( {
				title   : nbtcs.i18n.mediaTitle,
				button  : {
					text: nbtcs.i18n.mediaButton
				},
				multiple: false
			} );

			// When an image is selected, run a callback.
			frame.on( 'select', function () {
				var attachment = frame.state().get( 'selection' ).first().toJSON();
				$button.addClass('class_name' + attachment.id);
				$button.find( 'input.nbtcs-term-image' ).val( attachment.id );
				$button.find( '.nbtcs-remove-image-button' ).show();
				console.log(attachment);
				$button.find( 'img' ).attr( 'src', attachment.url );
			} );

			// Finally, open the modal.
			frame.open();
		},
		remove_upload_image: function(){
			var $button = $( this );

			$button.siblings( 'input.nbtcs-term-image' ).val( '' );
			$button.siblings( '.nbtcs-remove-image-button' ).show();
			$button.parent().prev( '.nbtcs-term-image-thumbnail' ).find( 'img' ).attr( 'src', nbtcs.placeholder );

			return false;
		}
	}


	nbt_brands_admin.init();

});