<?php
require_once(NB_ELEMENTS_PATH . 'modules/brands/admin.php');
require_once(NB_ELEMENTS_PATH . 'modules/brands/widgets/brand-category.php');
add_action( 'widgets_init', 'nb_register_widgets_brand' );
function nb_register_widgets_brand() {
	register_widget( 'NB_Brands_Category' );
}

add_action( 'init', 'nb_create_taxonomy_brands' );
function nb_create_taxonomy_brands() {
    register_taxonomy(
        'nbproduct_brand',
        'product',
        array(
            'label' => __( 'Brands' ),
            'rewrite' => array( 'slug' => 'brands' ),
            'hierarchical' => true,
        )
    );
}

add_action( 'woocommerce_product_meta_end', 'add_brands_product_meta', 9999 );
function add_brands_product_meta() {
    global $product;

    if( !$product ) return;

    $brands = get_the_terms( $product->get_id(), 'nbproduct_brand');
    if( $brands ){
        echo '<div class="brand_wrapper"><span class="meta-name">'.esc_html__('Brands', 'multistore-elements' ).': </span>';
        $string = '';
        foreach ($brands as $key => $brand) {
            $string .= '<span><a href="'. esc_url( get_term_link( $brand ) ).'">'. esc_attr($brand->name) .'</a></span>, ';
        }
        echo rtrim($string, ', ') . '</div>';
    }
}