<?php
/**
 * Plugin Name:       Jewelry Booster
 * Plugin URI:        netbaseteam.com
 * Description:       Add functionality to Jewelry WordPress Theme
 * Version:           1.0.0
 * Author:            netbaseteam
 * Author URI:        netbaseteam.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       jwboost
 * Domain Path:       /languages
*/

if (!defined('ABSPATH')) {
	exit;
}
if (!class_exists('Jewelry_Booster')) {
    class Jewelry_Booster {
        private static $instance = null;

        /**
        * Single instance
        * 
        * @since 1.0.0
        * @return object
        */
        public static function get_instance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

        /**
        * Constructor
        * 
        * @since 1.0.0
        */
        private function __construct() {
            $this->define_constant();

            $this->jewelry_getfiles(JWB_INC_DIR . '/one-click-import/', 'php');
            $this->jewelry_getfiles(JWB_INC_DIR . '/redux-options/', 'php');
        }

        /**
        * Define all plugin constants
        * 
        * @since 1.0.0
        */
        public function define_constant() {
            if(!defined('JWB_URL')) {
                define('JWB_URL', untrailingslashit( plugins_url( '/', __FILE__ ) ));
            }

            if(!defined('JWB_DIR')) {
                define('JWB_DIR', untrailingslashit( plugin_dir_path( __FILE__ ) ));
            }

            if(!defined('JWB_VER')) {
                define('JWB_VER', '1.0.0');
            }

            if(!defined('JWB_INC_DIR')) {
                define('JWB_INC_DIR', JWB_DIR . '/includes/');
            }

            if(!defined('JWB_ASSETS_DIR')) {
                define('JWB_ASSETS_DIR', JWB_DIR . '/assets/');
            }

            if(!defined('JWB_ASSETS_URL')) {
                define('JWB_ASSETS_URL', JWB_URL . '/includes/');
            }
        }

        /**
        * Get all includes and assets files
        * 
        * @since 1.0.0
        * @param string  $path
        * @param string  $ext
        */
        public function jewelry_getfiles($path, $ext) {
            if ( $ext == 'css' || $ext == 'js' ) {
                $files = scandir( $path.$ext.'/' );
            } else {
                $files = scandir( $path. '/' );
            }

            foreach($files as $key => $file) {
                if (preg_match("/\.(".$ext.")$/", $file)) {
                    $file_id = $ext.'jewelry';
                    if ($ext == 'css') {
                        wp_enqueue_style($file_id, JWB_ASSETS_DIR.$ext.'/'.$file, array(), JWB_VER);
                    }
                    if ($ext == 'js') {
                        wp_enqueue_script($file_id, JWB_ASSETS_DIR.$ext.'/'.$file, array(), JWB_VER, true);
                    }
                    if ($ext == 'php') {
                        require($path.$file);
                    }
                }
            }
        }

        /**
        * Get all third party
        * 
        * @since 1.0.0
        */
        public function jewelry_get_thirdparty() {
            $plugins = scandir(JWB_INC.'/thirdparty/');
            foreach ($plugins as $key => $plugin) {
                if (strlen($plugin) > 3 && $plugin !='.DS_Store') {
                    $plugin_name = scandir(JWB_INC . '/thirdparty/' .$plugin. '/');
                    foreach ($plugin_name as $key => $file) {
                        if (preg_match("/\.(php)$/", $file)) {
                            require(JWB_INC . '/thirdparty/' .$plugin. '/' .$file);
                        }
                    }
                }
            }
        }

        public function jewelry_one_click_import() {
            $this->jewelry_getfiles(JWB_INC_DIR . '/one-click-import/', 'php');
        }
    }
}

Jewelry_Booster::get_instance();