<?php

    /**
     * ReduxFramework Jewelry WordPress Theme Config File
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    $opt_name = "jewelry_options";

    /**
     * ---> SET ARGUMENTS
     * All the arguments for Redux.
     * */

    $theme = wp_get_theme();

    $args = array(
        'opt_name'             => $opt_name,
        'display_name'         => $theme->get( 'Name' ),
        'display_version'      => $theme->get( 'Version' ),
        'menu_type'            => 'menu',
        'allow_sub_menu'       => true,
        'menu_title'           => esc_html__( 'Jewelry Options', 'jewelry' ),
        'page_title'           => esc_html__( 'Jewelry Options', 'jewelry' ),
        'google_api_key'       => '',
        'google_update_weekly' => false,
        'async_typography'     => false,
        'admin_bar'            => true,
        'admin_bar_icon'       => 'dashicons-portfolio',
        'admin_bar_priority'   => 50,
        'global_variable'      => '',
        'dev_mode'             => false,
        'update_notice'        => true,
        'customizer'           => true,
        'page_priority'        => null,
        'page_parent'          => 'themes.php',
        'page_permissions'     => 'manage_options',
        'menu_icon'            => '',
        'page_icon'            => 'icon-themes',
        'page_slug'            => 'jewelry_options',
        'save_defaults'        => true,
        'default_show'         => true,
        'default_mark'         => '',
        'show_import_export'   => true,
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        'output_tag'           => true,
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.
        'use_cdn'              => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );

    // ADMIN BAR LINKS
    $args['admin_bar_links'][] = array(
        'id'    => 'redux-docs',
        'href'  => 'http://docs.reduxframework.com/',
        'title' => esc_html__( 'Documentation', 'jewelry' ),
    );

    $args['admin_bar_links'][] = array(
        //'id'    => 'redux-support',
        'href'  => 'https://github.com/ReduxFramework/redux-framework/issues',
        'title' => esc_html__( 'Support', 'jewelry' ),
    );


    // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
    $args['share_icons'][] = array(
        'url'   => 'https://github.com/ReduxFramework/ReduxFramework',
        'title' => 'Visit us on GitHub',
        'icon'  => 'el el-github'
        //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
    );
    $args['share_icons'][] = array(
        'url'   => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
        'title' => 'Like us on Facebook',
        'icon'  => 'el el-facebook'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://twitter.com/reduxframework',
        'title' => 'Follow us on Twitter',
        'icon'  => 'el el-twitter'
    );
    $args['share_icons'][] = array(
        'url'   => 'http://www.linkedin.com/company/redux-framework',
        'title' => 'Find us on LinkedIn',
        'icon'  => 'el el-linkedin'
    );

    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = sprintf( esc_html__( '<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'jewelry' ), $v );
    } else {
        $args['intro_text'] = esc_html__( '<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'jewelry' );
    }

    // Add content after the form.
    $args['footer_text'] = esc_html__( '<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'jewelry' );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => esc_html__( 'Theme Information 1', 'jewelry' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'jewelry' )
        ),
        array(
            'id'      => 'redux-help-tab-2',
            'title'   => esc_html__( 'Theme Information 2', 'jewelry' ),
            'content' => esc_html__( '<p>This is the tab content, HTML is allowed.</p>', 'jewelry' )
        )
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    $content = esc_html__( '<p>This is the sidebar content, HTML is allowed.</p>', 'jewelry' );
    Redux::setHelpSidebar( $opt_name, $content );


    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    // -> START GENERAL SECTION
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'General', 'jewelry' ),
        'id'     => 'jw-general',
        'desc'   => esc_html__( 'Change some site main options', 'jewelry' ),
        'icon'   => 'el-icon-cog el-icon-large',
        'fields' => array(
            array(
                'id'       =>'header_logo',
                'type'     => 'media',
                'title'    => esc_html__('Site\'s header logo', 'jewelry'),                
            ),
            array(
                'id'       =>'site_favicon',
                'url'      => false,
                'type'     => 'media', 
                'title'    => esc_html__('Site Favicon', 'jewelry'),
                'default'  => '',
                'subtitle' => esc_html__('Upload a 16px x 16px .png or .gif image that will be your favicon.', 'jewelry'),
            ),
            array(
                'id'       =>'site_iphone_icon',
                'url'      => false,
                'type'     => 'media', 
                'title'    => esc_html__('Apple iPhone Icon ', 'jewelry'),
                'default'  => '',
                'subtitle' => esc_html__('Custom iPhone icon (57px x 57px).', 'jewelry'),
            ),            
            array(
                'id'       =>'site_iphone_icon_retina',
                'url'      => false,
                'type'     => 'media', 
                'title'    => esc_html__('Apple iPhone Retina Icon ', 'jewelry'),
                'default'  => '',
                'subtitle' => esc_html__('Custom iPhone retina icon (114px x 114px).', 'jewelry'),
            ),            
            array(
                'id'       =>'site_ipad_icon',
                'url'      => false,
                'type'     => 'media', 
                'title'    => esc_html__('Apple iPad Icon ', 'jewelry'),
                'default'  => '',
                'subtitle' => esc_html__('Custom iPad icon (72px x 72px).', 'jewelry'),
            ),            
            array(
                'id'       =>'site_ipad_icon_retina',
                'url'      => false,
                'type'     => 'media', 
                'title'    => esc_html__('Apple iPad Retina Icon ', 'jewelry'),
                'default'  => '',
                'subtitle' => esc_html__('Custom iPad retina icon (144px x 144px).', 'jewelry'),
            ),
        )
    ) );


    // -> START FOOTER
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer', 'jewelry' ),
        'id'     => 'jw-footer',
        'desc'   => esc_html__( 'Change display of footer area', 'jewelry' ),
        'icon'   => 'el el-icon-photo',
        'fields' => array(
            array(
                'id'       => 'footer_widgets',
                'type'     => 'switch',
                'title'    => esc_html__('Enable footer widgets area.', 'jewelry'),
                'default'  => true,
            ),
            array(
                'id'      => 'footer_columns',
                'type'    => 'button_set',
                'title'   => esc_html__( 'Footer Columns', 'jewelry' ),
                'desc'    => esc_html__( 'Select the number of columns you would like for your footer widgets area.', 'jewelry' ),
                'type'    => 'button_set',
                'default' => '4',
                'required' => array('footer_widgets', '=', true ),
                'options' => array(
                    '1'   => esc_html__( '1 Column', 'jewelry' ),
                    '2'   => esc_html__( '2 Columns', 'jewelry' ),
                    '3'   => esc_html__( '3 Columns', 'jewelry' ),
                    '4'   => esc_html__( '4 Columns', 'jewelry' )
                ),
            ),
            array(
                'id'       => 'footer_bottom',
                'type'     => 'switch',
                'title'    => esc_html__('Enable footer bottom with section for copyright and a image.', 'jewelry'),
                'default'  => true
            ),
            array(
                'id'       =>'footer_bottom_copyright',
                'type'     => 'textarea',
                'title'    => esc_html__('Footer Copyright', 'jewelry'),
                'subtitle' => esc_html__('Enter the copyright section text(allow link tag).', 'jewelry'),
                'required' => array('footer_bottom', '=', true )
            ),
            array(
                'id'       =>'footer_bottom_image',
                'type'     => 'media',
                'title'    => esc_html__('Footer Bottom Image', 'jewelry'),
                'required' => array('footer_bottom', '=', true )
            ),
        )
    ) );

    // -> START WOOCOMMERCE
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Woocommerce', 'jewelry' ),
        'id'     => 'jw-woocommerce',
        'desc'   => esc_html__( 'Woocommerce Configuration', 'jewelry' ),
        'icon'   => 'el el-shopping-cart',
        'fields' => array(
            array(
                'id' => 'page_title',
                'type' => 'switch',
                'title' => esc_html__('Page title', 'jewelry'),
                'subtitle' => esc_html__('Show page title and breadcrumb for Woocommerce\'s page', 'jewelry'),
                'default' => true,
            ),
            array(
                'id' => 'shop_top_banner',
                'type' => 'media',
                'title' => esc_html__('Banner in top of shop page', 'jewelry'),
            ),
            array(
                'id' => 'shop_bottom_banner',
                'type' => 'media',
                'title' => esc_html__('Banner in bottom of shop page', 'jewelry'),
            ),
            array(
                'id' => 'products_per_row',
                'type'    => 'button_set',
                'title' => esc_html__('Products per row', 'jewelry'),
                'desc' => esc_html__('Select the number of products per row when in grid view', 'jewelry'),
                'default' => '3',
                'options' => array(                    
                    '2'   => esc_html__( '2 Products', 'jewelry' ),
                    '3'   => esc_html__( '3 Products', 'jewelry' ),
                    '4'   => esc_html__( '4 Products', 'jewelry' ),
                ),
            ),
            array(
                'id' => 'cart_notice',
                'type' => 'textarea',
                'title' => esc_html__('Cart Notice', 'jewelry'),
                'desc' => esc_html__('Notice on cart page', 'jewelry')
            )
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title' => esc_html__('Blog', 'jewelry'),
        'id' => 'jw-blog',
        'desc' => esc_html__('Blog layout configuration', 'jewelry'),
        'icon' => 'el el-list',
        'fields' => array(
            array(
                'id' => 'blog_top_banner',
                'type' => 'media',
                'title' => esc_html__('Blog top banner', 'jewelry'),
            ),
        )
    ) );

    // -> START lAYOUTS
    Redux::setSection( $opt_name, array(
        'title' => esc_html__('Layouts', 'jewelry'),
        'id'     => 'jw-layouts',
        'desc'   => esc_html__( 'Layouts Configuration', 'jewelry' ),
        'icon'   => 'el el-website',
        'fields' => array(            
            array(
                'id' => 'page_layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Page Layout', 'jewelry' ),
                'subtitle' => esc_html__( 'Default page layout.', 'jewelry' ),
                'options'  => array(
                    'left-sidebar'  => 'Left Sidebar',
                    'no-sidebar'    => 'No Sidebar',
                    'right-sidebar' => 'Right Sidebar'
                ),
                'default'  => 'left-sidebar'
            ),
            array(
                'id'       => 'blog_layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Blog Layout', 'jewelry' ),
                'subtitle' => esc_html__( 'Default blog layout ( category, tag, single, search, author, archive ).', 'jewelry' ),
                'options'  => array(
                    'left-sidebar'  => 'Left Sidebar',
                    'no-sidebar'    => 'No Sidebar',
                    'right-sidebar' => 'Right Sidebar'
                ),
                'default'  => 'left-sidebar'
            ),
            array(
                'id'       => 'shop_layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'WooCommerce Shop Page Layout', 'jewelry' ),
                'subtitle' => esc_html__( 'Layout for Woocommerce shop page.', 'jewelry' ),
                'options'  => array(
                    'left-sidebar'  => 'Left Sidebar',
                    'no-sidebar'    => 'No Sidebar',
                    'right-sidebar' => 'Right Sidebar'
                ),
                'default'  => 'left-sidebar'
            ),
            array(
                'id'       => 'single_product_layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Single WooCommerce Product Layout', 'jewelry' ),
                'subtitle' => esc_html__( 'Layout for single product', 'jewelry' ),
                'options'  => array(
                    'left-sidebar'  => 'Left Sidebar',
                    'no-sidebar'    => 'No Sidebar',
                    'right-sidebar' => 'Right Sidebar'
                ),
                'default'  => 'left-sidebar'
            ),
        )
    ) );    

    /*
     * <--- END SECTIONS
     */
