<?php
/**
 * Plugin Name: WordPress Booking Hotel
 * Plugin URI: http://demo12.cmsmart.net/booking_hotel
 * Description: WordPress Booking Hotel Pro is a plugin developed for booking hotel.
 * Version: 1.1.0
 * Author: NetBase Team
 * Author URI: https://netbaseteam.com
 * Text Domain: wpbookinghotel
**/

use WpBookingHotel\Application\Application as ApplicationAlias;
use WpBookingHotel\Factory as FactoryAlias;

if(!defined('DS')) {
    define("DS",DIRECTORY_SEPARATOR);
}
if (!defined("WPBOOKINGHOTEL_PLUGIN_NAME")) {
    define('WPBOOKINGHOTEL_PLUGIN_NAME', pathinfo(__DIR__, PATHINFO_FILENAME));
}
global $wp;

define("WPBOOKINGHOTEL_PATH_ROOT",plugin_dir_path(__FILE__));
define("_WPBOOKINGHOTEL_EXEC",1);
define("WPBOOKINGHOTEL_PREFIX_TABLE","woobooking_");
define("WPBOOKINGHOTEL_MINIMUM_ELEMENTOR_VERSION","2.0.0");
define("WPBOOKINGHOTEL_MINIMUM_PHP_VERSION","7.0");
define("WPBOOKINGHOTEL_ADMIN_PATH",WPBOOKINGHOTEL_PATH_ROOT.DS."admin");
define("WPBOOKINGHOTEL_ADMIN_WOOPANEL_PATH",WPBOOKINGHOTEL_PATH_ROOT.DS."admin_woopanel");
define("WPBOOKINGHOTEL_FRONTEND_PATH",WPBOOKINGHOTEL_PATH_ROOT.DS."frontend");
define("WPBOOKINGHOTEL_PLUGIN_DIR_URL",plugin_dir_url(__FILE__));
define("WPBOOKINGHOTEL_SITE_URL",get_site_url());
require_once WPBOOKINGHOTEL_PATH_ROOT.DS."wpbookinghotelconfig.php";
require_once WPBOOKINGHOTEL_PATH_ROOT.DS."NBAppHelper.php";
// Check for required Elementor version
if(file_exists(ABSPATH . 'wp-content/plugins/elementor/elementor.php'))
{
    include_once( ABSPATH . 'wp-content/plugins/elementor/elementor.php' );
}

/**
 * Class wpbookinghotel
 */
class wpbookinghotel
{

    public static function init()
    {
        $url="https://developer.wordpress.org/reference/functions/wp_redirect/";
        require_once __DIR__."/vendor/autoload.php";
        $input= FactoryAlias::getInput();
        $clientId=is_admin()?1:0;
        $data=$input->getData();
        $uri= FactoryAlias::getUri();
        $path=$uri->getPath();
        if(strpos($path,"wpbookinghotel_backend")!==false){
            $clientId=1;
        }
        $submit_clientId=$input->getString('submit_clientid',"");
        if($submit_clientId!==""){
            $clientId=(int)$submit_clientId;
        }
        $page="";
        if(strpos($path,"sellercenter")!==false || strpos($path,"wpbookinghotel_backend_woopanel")!==false){
            $clientId=2;
            $paths=explode('/',$path);
            foreach ($paths as $a_path){
                if(strpos($a_path,"wb_")!==false){
                    $page=str_replace("wb_","",$a_path);
                }
            }

        }
        $input->set('woopanel_page',$page);
        if($clientId==2){
            require_once __DIR__."/admin_woopanel/includes/defined.php";
        }elseif($clientId==1){
            require_once __DIR__."/admin/includes/defined.php";
        }else{
            require_once __DIR__."/frontend/includes/defined.php";
        }
        FactoryAlias::setApplicationClient($clientId);
        $app=ApplicationAlias::getInstance($clientId);
        $app->execute();

    }
}

wpbookinghotel::init();
if(!function_exists("wpbookinghotel_get_content")) {
    function wpbookinghotel_render_content($content)
    {
        echo (wpbookinghotel_get_content($content));
    }
}
if(!function_exists("wpbookinghotel_get_content")) {
    function wpbookinghotel_get_content($content)
    {
        return $content;
    }
}