<?php
namespace WpBookingHotel\Wordpress;

use Exception;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Factory;
use WpBookingHotel\Filesystem\File;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Log\Log;
use WpBookingHotel\Mvc\Controller\Controller;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Mvc\View\View;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Wordpress\ECommerce\ECommerce;

/**
 * Class Wordpress
 * @package WpBookingHotel\Wordpress
 */
class WordpressSite extends Wordpress
{

    /**
     * @var
     */
    private static $instance;
    public static $key_woo_booking = "wpbookinghotel";
    public static $prefix_link = "wb_";

    /**
     * @var string
     */
    public static $namespace = "wpbookinghotel_api/1.0";
    private static $parsed_route=false;
    /**
     * @var int
     */
    private $clientId=0;
    private $init_GutembergBlock=0;
    public function init(){
        add_action( 'wp_ajax_action_ajax_by_task', array($this,'wp_appointment_action_ajax_by_task') );
        add_action( 'wp_ajax_nopriv_action_ajax_by_task',   array($this,'wp_appointment_action_ajax_by_task') );
        add_filter( 'wp_title', array($this,'theme_slug_filter_wp_title' ));

        if(!$this->is_admin()) {
            if(session_id() == '')
                session_start();
            add_action( 'woopanel_menus', array($this,'add_menu_to_woopanel') );
            add_filter( 'woopanel_submenus', array( $this, 'add_sub_menu_to_woopanel') );
            add_filter( 'woopanel_vendor_query_var', array( $this, 'woopanel_query_var_filter') );

            $list_view_for_woo_panel=WordpressAdmin::get_list_view_for_woo_panel();

            foreach ($list_view_for_woo_panel as $menu){
                $menu=(object)$menu;
                add_action( "woopanel_dashboard_{$menu->id}_endpoint", array($this,'render_page_by_endpoint_woopanel') );
            }

            add_action( 'wp_enqueue_scripts', array($this,'wp_enqueue_scripts') );
            $input=Factory::getInput();
            $data=$input->getData();
            if(isset($data['_locale'])){
                return false;
            }
            // $task=$input->getString('task',"");
            // if ($task) {
            //     list($controller, $task) = explode(".", $task);
            //     $class_name ="WpBookingHotelFrontend\app\\controllers\\". ucfirst($controller) . "Controller";
            //     if (class_exists($class_name)) {
            //         $class_controller = new $class_name();
            //         if (method_exists($class_controller, $task)) {
            //             //not return
            //             call_user_func(array($class_controller, $task));

            //         }
            //     }
            // }

            add_action( 'init', array( $this, 'load_plugin_textdomain' ) );
            WpBookingHotelHtmlFrontend::load_jquery_library('less');
            WpBookingHotelHtmlFrontend::load_jquery_library('main_app');
            WpBookingHotelHtmlFrontend::load_jquery_library('lazy_load');
            WpBookingHotelHtmlFrontend::load_jquery_library('bootstrap');

            $path = "wp-content/plugins/wpbookingpro/frontend/app/views.xml";
            add_shortcode('wpbookinghotel', array($this, "front_end_render_view"));
            add_action('rest_api_init', array($this, 'wp_register_rest_route'));
            $list_view = $this->get_list_layout_block_frontend();

            foreach ($list_view as $key => $view) {
                $a_key = self::$key_wpbookinghotel . "-block-" . $key;
                add_shortcode($a_key, array($this, 'woo_booking_render_block_by_tag_func'));
            }


            $gutembergBlock = GutembergBlock::getInstance();
            $gutembergBlock->init();
            $widgets = Widgets::getInstance();
            $widgets->init();
            if($this->checkInstalled()) {
                add_action( 'wp_head', array($this,'gretathemes_meta_description'));
                add_filter('pre_get_document_title',array($this,'add_title_for_hotel'),10, 3 );
            }


            $eCommerce = ECommerce::getInstance();

            add_action('wp_footer', array($this, 'wp_hook_add_script_footer'));
            add_filter( 'init', array($this,"tour_op_generate_rewrite_rules"));
        }



    }
    public function tour_op_generate_rewrite_rules()
    {
        $wordpress=Factory::getWordpress(0);
        if(!$wordpress->checkInstalled()) { return; }
        parent::tour_op_generate_rewrite_rules();

    }
    function add_title_for_hotel(){
        $title="";
        $this->parse_route();
        $input = Factory::getInput();

        $hotel_id = $input->getInt('hotel_id',0);
        $modelhotel= \WpBookingHotel\Mvc\Model\Model::getInstance('hotel');
        $hotel=$modelhotel->getItem($hotel_id);
        if(isset($hotel->id)) {
            $title=$hotel->name;
        }
        return $title;
    }
    public function parse_route(){
        if(!static::$parsed_route) {
            $input = Factory::getInput();
            $uri = Factory::getUri();
            $app = Factory::getApplication(0);
            $_router = $app->getRouter(0);
            $vars = $_router->parse($uri);
            foreach ($vars as $key => $value) {
                $input->set($key, $value);
            }
        }
    }
    function gretathemes_meta_description() {
        $this->parse_route();
        $input = Factory::getInput();
        $hotel_id = $input->getInt('hotel_id',0);
        $modelhotel=Model::getInstance('hotel');
        $content="";

        $hotel=$modelhotel->getItem($hotel_id);
        if(isset($hotel->id)) {
            ob_start();
            ?>
            <meta name="description" content="<?php esc_attr_e($hotel->meta_description) ?>"/>
            <meta name="keyword" content="<?php esc_attr_e($hotel->meta_keyword) ?>"/>

            <?php
            $content = ob_get_clean();
        }
        echo $content;
    }
    public function theme_slug_filter_wp_title( $title ) {
        if ( is_404() ) {
            $title = 'ADD 404 TITLE TEXT HERE';
        }
        // You can do other filtering here, or
        // just return $title
        return $title;
    }

    public static function add_menu_to_woopanel($woopanel_menus){
        $woopanel_menus[4]=array(
            "id"=>"wp_bookinghotel",
            "menu_slug"=>"wp_bookinghotel",
            "menu_title"=>"wp booking hotel",
            "capability"=>"",
            "page_title"=>"wp booking hotel",
            "icon"=>"flaticon-line-graph",
            "classes"=>"wp-bookinghotel",
            "permission"=>"global",
        );

        return $woopanel_menus;

    }

    public static function wp_enqueue_scripts(){
        $config=Factory::getConfig();
        $environment=$config->get('environment',"development");
        if($environment=="production") {
            wp_enqueue_style( 'wpbookinghotel-main-frontend-style', WPBOOKINGHOTEL_PLUGIN_DIR_URL . '/frontend/app/assets/less/style.css', array());
        }else{

        }


    }

    public static function checkInstalled()
    {
        $app = Factory::getApplication(1);
        $db = Factory::getDBO();
        $installed = true;
        $list_table_in_database = $db->setQuery("SHOW TABLES LIKE " . $db->quote("woobooking\\_%"))->loadColumn();
        if (count($list_table_in_database) == 0) {
            $installed = false;
        }
        $json_table_need_install = File::read(WPBOOKINGHOTEL_PLUGIN_DIR_URL . "/install/tables.json");

        $json_table_need_install = json_decode($json_table_need_install);

        foreach ($json_table_need_install as $need_table) {
            if (!in_array($need_table, $list_table_in_database)) {
                $installed = false;
                break;
            }
        }

        return $installed;
    }

    private static function get_true_menu_of_woo_booking($menu)
    {
        return str_replace(self::$prefix_link, "", $menu);
    }

    public static function goToPopupInstall()
    {
        $root_url = Factory::getRootUrl();
        $html = '<html><head>';
        $html .= '<meta http-equiv="content-type" content="text/html; charset=utf-8" />';
        $html .= '<script>document.location.href=' . json_encode(str_replace("'", '&apos;',
                $root_url . '/wp-admin/admin.php?page=wb_config&layout=install')) . ';</script>';
        $html .= '</head><body></body></html>';
        echo ($html);
    }

    public static function add_sub_menu_to_woopanel($woopanel_submenus){
        $list_view_for_woo_panel=WordpressAdmin::get_list_view_for_woo_panel();

        $woopanel_submenus['wp_bookinghotel']=($list_view_for_woo_panel);
        return $woopanel_submenus;

    }
    public static function wp_appointment_action_ajax_by_task(){
        $input = Factory::getInput();
        $task=$input->getString("task","");
        if ($task) {
            list($controller, $task) = explode(".", $task);
            $class_name ="WpBookingHotelFrontend\app\\controllers\\". ucfirst($controller) . "Controller";
            if (class_exists($class_name)) {
                $class_controller = new $class_name();
                if (method_exists($class_controller, $task)) {
                    //not return
                    call_user_func(array($class_controller, $task));

                }
            }
        }
    }

    public function woopanel_query_var_filter( $query_vars ) {
        $list_view_for_woo_panel=WordpressAdmin::get_list_view_for_woo_panel();
        foreach ($list_view_for_woo_panel as $menu){
            $menu=(object)$menu;
            $query_vars[] = $menu->id;
        }
        return $query_vars;
    }


    public function wp_register_rest_route(){
        register_rest_route(
            self::$namespace,
            "wpbookinghotel_frontend/action_task",
            array(
                'methods' => 'POST',
                'callback' => array($this, 'action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookinghotel_frontend/action_task",
            array(
                'methods' => 'GET',
                'callback' => array($this, 'action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookinghotel_frontend/task",
            array(
                'methods' => 'POST',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookinghotel_frontend/task",
            array(
                'methods' => 'GET',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookinghotel_backend/task",
            array(
                'methods' => 'POST',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
        register_rest_route(
            self::$namespace,
            "wpbookinghotel_backend/task",
            array(
                'methods' => 'GET',
                'callback' => array($this, 'ajax_action_task'),
            )
        );
    }

    public  function load_plugin_textdomain(){
        load_plugin_textdomain( 'wpbookinghotel', false, WPBOOKINGHOTEL_PATH_ROOT . '/languages/' );
    }

    function woo_booking_render_block_by_tag_func($atts, $content, $a_view)
    {


        $input = Factory::getInput();
        if (is_array($atts) && $id = reset($atts)) {

            list($package, $block, $block_name) = explode("-", $a_view);

            wp_kses(Controller::view_block_module($id, $block_name),true);
        }
        return false;
    }
    public function getKeyWooBooking()
    {
        return self::$key_woo_booking;
    }

    public static function get_api_task()
    {
        return "wpbookinghotel_frontend/task";

    }
    public static function get_action_task()
    {
        return "wpbookinghotel_frontend/action_task";

    }
    public function front_end_render_view($params,$option,$view){
        $input=Factory::getInput();
        WpBookingHotelHtmlFrontend::load_jquery_library('bootstrap');
        $view=isset($params['view'])?$params['view']:"hotels-list";
        $a_view=$input->getString('view',"");
        if($a_view){
            $view=$a_view;
        }
        list($view, $layout) = explode("-", $view);

        echo (Controller::view("$view.$layout"));
        add_action('wp_footer', array($this, 'wp_hook_add_script_footer'));

    }
    public function get_wpbookinghotel_api_task(){
        return "/wp-json/".self::$namespace.'/'.$this->get_action_task();
    }
    public function wp_hook_add_script_footer(){
        global $wp;

        wp_enqueue_script("jquery");

        $doc = Factory::getDocument();

        $lessStyleSheets = $doc->getLessStyleSheets();
        $config=Factory::getConfig();

        $environment=$config->get('environment',"development");
        if($environment=="development") {
            foreach ($lessStyleSheets as $src => $item) {
                ob_start();
                ?>
                <link rel="stylesheet/less" type="text/css"
                      href="<?php  Text::_echo(WPBOOKINGHOTEL_PLUGIN_DIR_URL . "/" . $src) ?>"/>
                <?php
                echo (ob_get_clean());
            }
        }else{
            //$doc->addStyleSheet('frontend/app/assets/less/style.css');
        }
        $styleSheets = $doc->getStyleSheets();


        foreach ($styleSheets as $src => $item) {
            $random = random_int(100000, 900000);
            if (strpos($src, 'http') !== false) {
                wp_enqueue_style('wpbookinghotel-css-' . $random, $src);
            } else {
                wp_enqueue_style('wpbookinghotel-css-' . $random, WPBOOKINGHOTEL_PLUGIN_DIR_URL . '/' . $src);
            }
        }

        ob_start();
        ?>
        <script type="text/javascript">
            var wpbookinghotel_root_url = "<?php  echo (WPBOOKINGHOTEL_SITE_URL) ?>";
            var wpbookinghotel_current_url = "<?php  echo (WPBOOKINGHOTEL_SITE_URL) ?>";
            var wpbookinghotel_root_url_plugin = "<?php echo (WPBOOKINGHOTEL_PLUGIN_DIR_URL); ?>/";
            var wpbookinghotel_api_task = "/wp-json/<?php echo (self::$namespace.'/'.$this->get_api_task()) ?>";
        </script>
        <?php
        $content=ob_get_clean();
        $content= Utility::remove_string_javascript($content);
        wp_enqueue_script('wpbookinghotel-js-init', WPBOOKINGHOTEL_PLUGIN_DIR_URL .'frontend/resources/init.js' );
        wp_add_inline_script('wpbookinghotel-js-init', $content);

        $scripts = $doc->getScripts();
        foreach ($scripts as $src => $item){
            try {
                $random = random_int(100000, 900000);
                if (strpos($src, 'http') !== false || strpos($src, 'https') !== false) {
                    wp_enqueue_script('wpbookinghotel-js-out-site'.$random,$src,array('jquery') );
                } else {
                    $src=WPBOOKINGHOTEL_PLUGIN_DIR_URL . $src;
                    wp_enqueue_script('wpbookinghotel-js-in-site-'.$random, $src,array('jquery') );
                }
            } catch (Exception $e) {
            }

        }
        wp_enqueue_script('wpbookinghotel-js-defined', WPBOOKINGHOTEL_PLUGIN_DIR_URL .'frontend/resources/define.js' );
        $doc=Factory::getDocument();
        $script = $doc->getScript();
        foreach ($script as $content) {
            wp_add_inline_script('wpbookinghotel-js-defined', $content);
        }
    }



}